<?php
/**
 * Handling the creation and update of the MU plugin.
 *
 * @package QACP
 */

namespace QACP\MUPH;

/**
 * Creates the MU plugin in the dedicated WP folder.
 *
 * @return void
 */
function create_mu_plugin() {

	$_filename = 'qacp-catch-events.php';
	$_source = plugin_dir_path( __FILE__ ) . "/$_filename";
	$_destination = WPMU_PLUGIN_DIR . "/$_filename";

	if ( ! is_dir( WPMU_PLUGIN_DIR ) ) {

		wp_mkdir_p( WPMU_PLUGIN_DIR );
	}

	if ( ! file_exists( $_destination ) ) {

		$_contents = file_get_contents( $_source );
		$_contents = str_replace( '{QACP_PLUGIN_PATH}', QACP_PLUGIN_PATH, $_contents );
		file_put_contents( $_destination, $_contents );

	}
}

/**
 * Removes the MU plugin file.
 *
 * @return void
 */
function remove_mu_plugin() {

	$_filename = 'qacp-catch-events.php';
	$_destination = WPMU_PLUGIN_DIR . "/$_filename";

	if ( file_exists( $_destination ) ) {

		$res = wp_delete_file( $_destination );
	}
}

/**
 * Replaces the MU plugin file with the new one.
 *
 * @return void
 */
function replace_mu_plugin_file() {

	remove_mu_plugin();
	create_mu_plugin();
}

/**
 * Checks the plugin version.
 *
 * @return bool true.
 */
function check_version() {

	$_qacp = \QACP::instance();
	$_plugin_version = $_qacp->get_version();
	$_previous_version = get_site_option( 'qacp_plugin_version' );

	if ( $_plugin_version != $_previous_version ) {

		replace_mu_plugin_file();
		update_option( 'qacp_plugin_version', $_plugin_version, true );
	}

	return true;
}

/**
 * This function tries to update.
 * Checking the version and also checking if the file doesn't exist even if version is the same ( like a developer deleted it ).
 *
 * @return void
 */
function maybe_update() {

	// Checking MU plugin's version.
	//
	check_version();

	// Tries to create.
	//
	create_mu_plugin();
}
