<?php
/**
 * Handling required DB tables and versioning.
 *
 * @package QACP
 */

namespace QACP\DB;

add_action( 'plugins_loaded', __NAMESPACE__ . '\update_db_check' );

/**
 * Returns DB version.
 *
 * @return string DB tables version.
 */
function get_plugin_db_version() {

	$_qacp_db_version = '1.48';

	return $_qacp_db_version;
}
/**
 * Creates necessary tables for the plugin's operation.
 *
 * @return void
 */
function create_table() {

	global $wpdb;
	$_table_name = $wpdb->prefix . 'qacp_queue';
	$_wpdb_collate = $wpdb->collate;

	$_sql =
		"CREATE TABLE {$_table_name} (
		id mediumint(8) unsigned NOT NULL auto_increment ,
		data longtext NULL,
		user_id bigint(20) NULL,
		event_time int(11) NULL,
		action longtext NULL,
		sent smallint(1) NULL,
		PRIMARY KEY  (id),
		KEY sent (sent,event_time)
		)
		COLLATE {$_wpdb_collate}";

	require_once ABSPATH . 'wp-admin/includes/upgrade.php';
	dbDelta( $_sql, true );

	$_db_version = get_plugin_db_version();
	update_option( 'qacp_db_version', $_db_version, true );
}

/**
 * Checking if db version has changed. Updates if it has.
 *
 * @return void
 */
function update_db_check() {

	$_plugin_db_version = get_plugin_db_version();
	$_db_version = get_site_option( 'qacp_db_version' );

	if ( $_db_version != $_plugin_db_version ) {

		create_table();
	}
}
