<?php
/**
 * Provides functionality for scheduling the plugin's operations.
 *
 * @package QACP
 */

namespace QACP\CRON_SCHEDULER;

/**
 * Activates scheduling via WC action-scheduler
 */
function schedule_queue_processing() {

	if ( function_exists( 'as_has_scheduled_action' ) ) {

		if ( false === as_has_scheduled_action( 'qacp_queue_processing' ) ) {

			$_cron_action_interval = \QACP\Options\get_cron_action_interval();
			as_schedule_single_action( strtotime( "+ $_cron_action_interval seconds" ), 'qacp_queue_processing' );
		}
	}
}

/**
 * DB Backup Cron Scheduler
 *
 * @return void
 */
function schedule_db_bck_and_clean() {

	if ( function_exists( 'as_has_scheduled_action' ) ) {
		if ( false === as_has_scheduled_action( 'qacp_db_backup_hook' ) ) {

			$_cron_action_interval = DAY_IN_SECONDS; // \GIAW\Admin\get_cron_action_interval();
			as_schedule_single_action( strtotime( 'now' ) + $_cron_action_interval, 'qacp_db_backup_hook' );
		}
	}
}

/**
 * Hooking to cron events
 */
if ( ( \QACP\Options\get_is_enabled() ) ) {

	// Queue processing.
	//
	add_action( 'init', __NAMESPACE__ . '\schedule_queue_processing' );
	add_action( 'init', __NAMESPACE__ . '\schedule_db_bck_and_clean' );
}
