<?php
/**
 * Plugin Uninstall - SAFE VERSION
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly or not uninstalling.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// CHECK: Should we delete data?
// Default is FALSE (preserve data) if the option isn't set.
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$delete_data = get_option( 'qcnc_delete_data_on_uninstall', false );

// 🛑 SAFETY CHECK: If the user hasn't explicitly checked the box, STOP HERE.
if ( ! $delete_data ) {
    return; 
}

// =============================================================================
// ☢️ DANGER ZONE: DATA DELETION LOGIC BELOW
// Only runs if 'qcnc_delete_data_on_uninstall' is explicitly TRUE
// =============================================================================

global $wpdb;

// Delete plugin tables.
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tables = [
    $wpdb->prefix . 'qcnc_product_costs',
    $wpdb->prefix . 'qcnc_order_profit',
    $wpdb->prefix . 'qcnc_order_items_profit',
    $wpdb->prefix . 'qcnc_cost_rules',
    $wpdb->prefix . 'qcnc_margin_alerts',
    $wpdb->prefix . 'qcnc_payment_gateway_fees',
    $wpdb->prefix . 'qcnc_report_cache',
];

// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
foreach ( $tables as $table ) {
    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, PluginCheck.Security.DirectDB.UnescapedDBParameter, WordPress.DB.DirectDatabaseQuery.SchemaChange
    $wpdb->query( "DROP TABLE IF EXISTS {$table}" );
}

// Delete plugin options.
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$options = [
    'qcnc_activated',
    'qcnc_version',
    'qcnc_db_version',
    'qcnc_activation_time',
    'qcnc_low_margin_threshold',
    'qcnc_loss_order_alert',
    'qcnc_monthly_summary_email',
    'qcnc_alert_email',
    'qcnc_default_currency',
    'qcnc_enable_slack_alerts',
    'qcnc_slack_webhook_url',
    'qcnc_calculation_on_save',
    'qcnc_cache_duration',
    'qcnc_enable_debug_logging',
    'qcnc_delete_data_on_uninstall', // Delete this option itself last
];

// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
foreach ( $options as $option ) {
    delete_option( $option );
}

// Delete all transients.
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery
$wpdb->query(
    "DELETE FROM {$wpdb->options} 
     WHERE option_name LIKE '_transient_qcnc_%' 
     OR option_name LIKE '_transient_timeout_qcnc_%'"
);

// Delete all product meta.
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery
$wpdb->query(
    "DELETE FROM {$wpdb->postmeta} 
     WHERE meta_key LIKE '_qcnc_%'"
);

// Delete log files.
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$upload_dir = wp_upload_dir();
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$log_dir = $upload_dir['basedir'] . '/qcnc-logs';

if ( file_exists( $log_dir ) ) {
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    $files = glob( $log_dir . '/*' );
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    foreach ( $files as $file ) {
        if ( is_file( $file ) ) {
            wp_delete_file( $file );
        }
    }
    // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir
    rmdir( $log_dir );
}

// Clear cron jobs.
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$cron_hooks = [
    'qcnc_daily_profit_recalc',
    'qcnc_weekly_report',
    'qcnc_monthly_summary',
    'qcnc_cache_cleanup',
];

// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
foreach ( $cron_hooks as $hook ) {
    wp_clear_scheduled_hook( $hook );
}