<?php
/**
 * Monthly Summary Email Template
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php esc_html_e( 'Monthly Profit Summary', 'quarkcode-neuralcommerce-lite' ); ?></title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #007bff; color: #ffffff; padding: 30px; text-align: center; }
        .content { padding: 20px; background: #ffffff; }
        .stats-grid { display: table; width: 100%; margin: 20px 0; }
        .stat-box { display: table-cell; padding: 15px; text-align: center; background: #f8f9fa; border: 1px solid #dee2e6; }
        .stat-value { font-size: 24px; font-weight: bold; color: #007bff; }
        .stat-label { font-size: 12px; color: #6c757d; text-transform: uppercase; }
        .positive { color: #28a745; }
        .negative { color: #dc3545; }
        .footer { text-align: center; padding: 20px; font-size: 12px; color: #6c757d; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?php esc_html_e( '📊 Monthly Profit Summary', 'quarkcode-neuralcommerce-lite' ); ?></h1>
            <p><?php echo esc_html( wp_date( 'F Y', strtotime( 'last month' ) ) ); ?></p>
        </div>

        <div class="content">
            <h2><?php esc_html_e( 'Performance Overview', 'quarkcode-neuralcommerce-lite' ); ?></h2>

            <div class="stats-grid">
                <div class="stat-box">
                    <div class="stat-value"><?php echo esc_html( number_format_i18n( $summary['total_orders'] ) ); ?></div>
                    <div class="stat-label"><?php esc_html_e( 'Total Orders', 'quarkcode-neuralcommerce-lite' ); ?></div>
                </div>
                <div class="stat-box">
                    <div class="stat-value"><?php echo wp_kses_post( wc_price( $summary['total_revenue'] ) ); ?></div>
                    <div class="stat-label"><?php esc_html_e( 'Revenue', 'quarkcode-neuralcommerce-lite' ); ?></div>
                </div>
                <div class="stat-box">
                    <div class="stat-value <?php echo floatval( $summary['total_profit'] ) >= 0 ? 'positive' : 'negative'; ?>">
                        <?php echo wp_kses_post( wc_price( $summary['total_profit'] ) ); ?>
                    </div>
                    <div class="stat-label"><?php esc_html_e( 'Net Profit', 'quarkcode-neuralcommerce-lite' ); ?></div>
                </div>
            </div>

            <h3><?php esc_html_e( 'Detailed Metrics', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td style="padding: 10px; border-bottom: 1px solid #dee2e6;">
                        <?php esc_html_e( 'Average Margin:', 'quarkcode-neuralcommerce-lite' ); ?>
                    </td>
                    <td style="padding: 10px; border-bottom: 1px solid #dee2e6; text-align: right;">
                        <strong><?php echo esc_html( number_format( $summary['avg_margin'], 2 ) ); ?>%</strong>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 10px; border-bottom: 1px solid #dee2e6;">
                        <?php esc_html_e( 'Lowest Margin:', 'quarkcode-neuralcommerce-lite' ); ?>
                    </td>
                    <td style="padding: 10px; border-bottom: 1px solid #dee2e6; text-align: right;">
                        <strong><?php echo esc_html( number_format( $summary['min_margin'], 2 ) ); ?>%</strong>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 10px; border-bottom: 1px solid #dee2e6;">
                        <?php esc_html_e( 'Highest Margin:', 'quarkcode-neuralcommerce-lite' ); ?>
                    </td>
                    <td style="padding: 10px; border-bottom: 1px solid #dee2e6; text-align: right;">
                        <strong><?php echo esc_html( number_format( $summary['max_margin'], 2 ) ); ?>%</strong>
                    </td>
                </tr>
            </table>

            <p style="text-align: center; margin-top: 30px;">
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-dashboard' ) ); ?>" 
                   style="display: inline-block; padding: 12px 24px; background: #007bff; color: #ffffff; text-decoration: none; border-radius: 4px;">
                    <?php esc_html_e( 'View Full Dashboard', 'quarkcode-neuralcommerce-lite' ); ?>
                </a>
            </p>
        </div>

        <div class="footer">
            <p><?php esc_html_e( 'NeuralCommerce - Profit Analytics & Cost Intelligence Hub', 'quarkcode-neuralcommerce-lite' ); ?></p>
        </div>
    </div>
</body>
</html>
