<?php
/**
 * Margin Alert Email Template
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php esc_html_e( 'Profit Alert', 'quarkcode-neuralcommerce-lite' ); ?></title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #f8f9fa; padding: 20px; text-align: center; border-bottom: 3px solid #dc3545; }
        .content { padding: 20px; background: #ffffff; }
        .alert-box { background: #fff3cd; border: 1px solid #ffc107; padding: 15px; margin: 20px 0; border-radius: 4px; }
        .stats-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .stats-table td { padding: 10px; border-bottom: 1px solid #dee2e6; }
        .stats-table td:first-child { font-weight: bold; width: 40%; }
        .negative { color: #dc3545; font-weight: bold; }
        .warning { color: #ffc107; font-weight: bold; }
        .footer { text-align: center; padding: 20px; font-size: 12px; color: #6c757d; }
        .button { display: inline-block; padding: 10px 20px; background: #007bff; color: #ffffff; text-decoration: none; border-radius: 4px; margin: 10px 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?php esc_html_e( '⚠️ Profit Alert', 'quarkcode-neuralcommerce-lite' ); ?></h1>
        </div>

        <div class="content">
            <?php if ( 'low_margin' === $alert_type ) : ?>
                <div class="alert-box">
                    <h2><?php esc_html_e( 'Low Margin Order Detected', 'quarkcode-neuralcommerce-lite' ); ?></h2>
                    <p>
                        <?php 
                        printf(
                            /* translators: 1: Order ID, 2: Margin percentage */
                            esc_html__( 'Order #%1$d has a margin of %2$s%%, which is below your threshold.', 'quarkcode-neuralcommerce-lite' ),
                            absint( $entity_id ),
                            number_format( $alert_data['margin_pct'], 2 )
                        );
                        ?>
                    </p>
                </div>
            <?php elseif ( 'loss_order' === $alert_type ) : ?>
                <div class="alert-box" style="background: #f8d7da; border-color: #dc3545;">
                    <h2><?php esc_html_e( '🚨 Loss-Making Order', 'quarkcode-neuralcommerce-lite' ); ?></h2>
                    <p>
                        <?php 
                        printf(
                            /* translators: %d: Order ID */
                            esc_html__( 'Order #%d has generated a loss!', 'quarkcode-neuralcommerce-lite' ),
                            absint( $entity_id )
                        );
                        ?>
                    </p>
                </div>
            <?php endif; ?>

            <h3><?php esc_html_e( 'Order Details', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <table class="stats-table">
                <tr>
                    <td><?php esc_html_e( 'Order ID:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                    <td>#<?php echo absint( $entity_id ); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e( 'Revenue:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                    <td><?php echo wp_kses_post( wc_price( $alert_data['revenue'] ) ); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e( 'COGS:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                    <td><?php echo wp_kses_post( wc_price( $alert_data['cogs_total'] ) ); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e( 'Payment Fee:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                    <td><?php echo wp_kses_post( wc_price( $alert_data['payment_fee'] ) ); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e( 'Shipping Cost:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                    <td><?php echo wp_kses_post( wc_price( $alert_data['shipping_cost'] ) ); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e( 'Net Profit:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                    <td class="<?php echo floatval( $alert_data['net_profit'] ) < 0 ? 'negative' : 'warning'; ?>">
                        <?php echo wp_kses_post( wc_price( $alert_data['net_profit'] ) ); ?>
                    </td>
                </tr>
                <tr>
                    <td><?php esc_html_e( 'Margin:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                    <td class="<?php echo floatval( $alert_data['margin_pct'] ) < 0 ? 'negative' : 'warning'; ?>">
                        <?php echo esc_html( number_format( $alert_data['margin_pct'], 2 ) ); ?>%
                    </td>
                </tr>
            </table>

            <p style="text-align: center;">
                <a href="<?php echo esc_url( admin_url( 'post.php?post=' . $entity_id . '&action=edit' ) ); ?>" class="button">
                    <?php esc_html_e( 'View Order', 'quarkcode-neuralcommerce-lite' ); ?>
                </a>
            </p>
        </div>

        <div class="footer">
            <p><?php esc_html_e( 'This is an automated email from NeuralCommerce Profit Analytics.', 'quarkcode-neuralcommerce-lite' ); ?></p>
            <p>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-settings' ) ); ?>">
                    <?php esc_html_e( 'Configure Alert Settings', 'quarkcode-neuralcommerce-lite' ); ?>
                </a>
            </p>
        </div>
    </div>
</body>
</html>
