<?php
/**
 * Generic Alert Email Template
 *
 * @package QuarkcodeNeuralCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #f8f9fa; padding: 20px; border-radius: 8px 8px 0 0; border-bottom: 3px solid #007cba; }
        .content { background: #fff; padding: 30px; border: 1px solid #ddd; }
        .alert-box { background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; }
        .alert-box.danger { background: #f8d7da; border-left-color: #dc3545; }
        .alert-box.warning { background: #fff3cd; border-left-color: #ffc107; }
        .alert-box.info { background: #d1ecf1; border-left-color: #17a2b8; }
        .button { display: inline-block; padding: 12px 24px; background: #007cba; color: #fff; text-decoration: none; border-radius: 4px; margin: 10px 0; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; font-size: 12px; color: #666; border-radius: 0 0 8px 8px; }
        table.data { width: 100%; border-collapse: collapse; margin: 20px 0; }
        table.data td { padding: 10px; border-bottom: 1px solid #eee; }
        table.data td:first-child { font-weight: 600; width: 40%; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1 style="margin: 0; color: #007cba;">📊 NeuralCommerce Alert</h1>
            <p style="margin: 10px 0 0 0; color: #666;"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></p>
        </div>

        <div class="content">
            <div class="alert-box <?php echo esc_attr( $data['severity'] ?? 'warning' ); ?>">
                <h2 style="margin-top: 0;">⚠️ <?php echo esc_html( $data['title'] ?? 'Alert Triggered' ); ?></h2>
                <p><?php echo wp_kses_post( $data['message'] ?? 'An alert has been triggered.' ); ?></p>
            </div>

            <?php if ( ! empty( $data['details'] ) ) : ?>
            <table class="data">
                <?php 
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                foreach ( $data['details'] as $label => $value ) : ?>
                <tr>
                    <td><?php echo esc_html( $label ); ?>:</td>
                    <td><strong><?php echo wp_kses_post( $value ); ?></strong></td>
                </tr>
                <?php endforeach; ?>
            </table>
            <?php endif; ?>

            <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-dashboard' ) ); ?>" class="button">
                View Dashboard →
            </a>
        </div>

        <div class="footer">
            <p>This is an automated alert from NeuralCommerce Profit Analytics</p>
            <p><a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-settings&tab=alerts' ) ); ?>">Manage Alert Settings</a></p>
        </div>
    </div>
</body>
</html>
