<?php
/**
 * Unprofitable Order Alert Email Template
 *
 * @package QuarkcodeNeuralCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$order = isset( $data['order_id'] ) ? wc_get_order( $data['order_id'] ) : null;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #fc5c7d 0%, #6a82fb 100%); padding: 30px; text-align: center; color: white; border-radius: 8px 8px 0 0; }
        .content { background: #fff; padding: 30px; border: 1px solid #ddd; }
        .alert-banner { background: #f8d7da; border: 2px solid #dc3545; padding: 20px; border-radius: 8px; margin: 20px 0; text-align: center; }
        .loss-amount { font-size: 48px; font-weight: 700; color: #dc3545; margin: 15px 0; }
        .order-details { background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0; }
        .button { display: inline-block; padding: 12px 24px; background: #dc3545; color: #fff; text-decoration: none; border-radius: 4px; margin: 10px 5px; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div style="font-size: 48px; margin-bottom: 10px;">🚨</div>
            <h1 style="margin: 0;">UNPROFITABLE ORDER ALERT</h1>
            <p style="margin: 10px 0 0 0; opacity: 0.9; font-size: 18px;">This order resulted in a loss</p>
        </div>

        <div class="content">
            <div class="alert-banner">
                <h2 style="margin: 0; color: #dc3545;">⚠️ ATTENTION REQUIRED</h2>
                <div class="loss-amount">
                    <?php echo wp_kses_post(wc_price( $data['profit'] ?? 0 )); ?>
                </div>
                <p style="margin: 0; font-size: 18px;"><strong>Loss on this order</strong></p>
                <p style="margin: 10px 0 0 0; color: #666;">
                    Margin: <strong><?php echo number_format( $data['margin'] ?? 0, 2 ); ?>%</strong>
                </p>
            </div>

            <?php if ( $order ) : ?>
            <div class="order-details">
                <h3 style="margin-top: 0;">📦 Order Information</h3>
                <table style="width: 100%;">
                    <tr>
                        <td><strong>Order Number:</strong></td>
                        <td>#<?php echo esc_html( $order->get_order_number() ); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Date:</strong></td>
                        <td><?php echo esc_html( $order->get_date_created()->format( 'M d, Y g:i A' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Customer:</strong></td>
                        <td><?php echo esc_html( $order->get_billing_first_name() . ' ' . $order->get_billing_last_name() ); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Order Total:</strong></td>
                        <td><?php echo wp_kses_post(wc_price( $data['revenue'] ?? $order->get_total() )); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Total Cost:</strong></td>
                        <td><?php echo wp_kses_post(wc_price( $data['cost'] ?? 0 )); ?></td>
                    </tr>
                    <tr style="border-top: 2px solid #dc3545;">
                        <td><strong>Net Profit/Loss:</strong></td>
                        <td><strong style="color: #dc3545;"><?php echo wp_kses_post(wc_price( $data['profit'] ?? 0 )); ?></strong></td>
                    </tr>
                </table>
            </div>

            <div style="background: #fff3cd; padding: 15px; border-radius: 8px; border-left: 4px solid #ffc107;">
                <h3 style="margin-top: 0;">🔍 Possible Causes:</h3>
                <ul style="margin: 10px 0; padding-left: 20px;">
                    <li>Product costs higher than selling price</li>
                    <li>Excessive discounts or coupons applied</li>
                    <li>High shipping or payment processing fees</li>
                    <li>Incorrect cost data entry</li>
                    <li>Special promotional pricing</li>
                </ul>
            </div>

            <div style="background: #e8f5e9; padding: 15px; border-radius: 8px; margin-top: 15px;">
                <h3 style="margin-top: 0;">✅ Recommended Actions:</h3>
                <ul style="margin: 10px 0; padding-left: 20px;">
                    <li>Review and verify product costs for accuracy</li>
                    <li>Check if any discounts need adjustment</li>
                    <li>Consider minimum order value requirements</li>
                    <li>Review pricing strategy for affected products</li>
                    <li>Set up cost-based pricing rules</li>
                </ul>
            </div>

            <div style="text-align: center; margin-top: 30px;">
                <a href="<?php echo esc_url( $order->get_edit_order_url() ); ?>" class="button">
                    View Order Details →
                </a>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-product-costs' ) ); ?>" class="button" style="background: #6c757d;">
                    Review Product Costs →
                </a>
            </div>
            <?php endif; ?>
        </div>

        <div class="footer">
            <p><strong>NeuralCommerce Profit Analytics</strong></p>
            <p style="color: #999;">Catching profit issues before they cost thousands</p>
            <p><a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-settings&tab=alerts' ) ); ?>">Manage Alert Settings</a></p>
        </div>
    </div>
</body>
</html>
