<?php
/**
 * Margin Drop Alert Email Template
 *
 * @package QuarkcodeNeuralCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$order = isset( $data['order_id'] ) ? wc_get_order( $data['order_id'] ) : null;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 30px; text-align: center; color: white; border-radius: 8px 8px 0 0; }
        .content { background: #fff; padding: 30px; border: 1px solid #ddd; }
        .alert-badge { display: inline-block; background: #ffc107; color: #000; padding: 8px 16px; border-radius: 20px; font-weight: 600; font-size: 14px; }
        .alert-badge.danger { background: #dc3545; color: #fff; }
        .metric-box { background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 15px 0; border-left: 4px solid #dc3545; }
        .metric { font-size: 32px; font-weight: 700; color: #dc3545; margin: 10px 0; }
        .comparison { display: flex; justify-content: space-around; margin: 20px 0; }
        .comparison-item { text-align: center; padding: 15px; }
        .comparison-value { font-size: 24px; font-weight: 600; }
        .comparison-label { font-size: 12px; color: #666; text-transform: uppercase; }
        .button { display: inline-block; padding: 12px 24px; background: #007cba; color: #fff; text-decoration: none; border-radius: 4px; margin: 15px 0; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div style="font-size: 48px; margin-bottom: 10px;">⚠️</div>
            <h1 style="margin: 0;">Low Profit Margin Alert</h1>
            <p style="margin: 10px 0 0 0; opacity: 0.9;">Immediate attention required</p>
        </div>

        <div class="content">
            <p style="font-size: 16px; color: #666;">
                <strong>Alert Time:</strong> <?php echo esc_html(wp_date( 'F j, Y g:i A' )); ?>
            </p>

            <div class="metric-box">
                <h2 style="margin-top: 0; color: #dc3545;">📉 Order Margin Below Threshold</h2>
                <?php if ( $order ) : ?>
                <p><strong>Order:</strong> #<?php echo esc_html( $data['order_number'] ?? $order->get_order_number() ); ?></p>
                <?php endif; ?>

                <div class="metric"><?php echo number_format( $data['margin'] ?? 0, 2 ); ?>%</div>
                <p style="margin: 0; color: #666;">Current Margin</p>
            </div>

            <div class="comparison">
                <div class="comparison-item">
                    <div class="comparison-value" style="color: #28a745;">
                        <?php echo number_format( $data['threshold'] ?? 20, 1 ); ?>%
                    </div>
                    <div class="comparison-label">Threshold</div>
                </div>
                <div class="comparison-item">
                    <div class="comparison-value" style="color: #dc3545;">
                        <?php 
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        $diff = ( $data['threshold'] ?? 20 ) - ( $data['margin'] ?? 0 );
                        echo number_format( abs( $diff ), 2 ); 
                        ?>%
                    </div>
                    <div class="comparison-label">Below Target</div>
                </div>
                <?php if ( isset( $data['profit'] ) ) : ?>
                <div class="comparison-item">
                    <div class="comparison-value">
                        <?php echo wp_kses_post(wc_price( $data['profit'] )); ?>
                    </div>
                    <div class="comparison-label">Profit</div>
                </div>
                <?php endif; ?>
            </div>

            <?php if ( isset( $data['average_margin'] ) ) : ?>
            <div style="background: #e3f2fd; padding: 15px; border-radius: 8px; margin: 20px 0;">
                <p style="margin: 0;"><strong>📊 30-Day Average Margin:</strong> <?php echo number_format( $data['average_margin'], 2 ); ?>%</p>
                <?php if ( isset( $data['drop_percentage'] ) ) : ?>
                <p style="margin: 5px 0 0 0; color: #d32f2f;">
                    <strong>↓ Drop:</strong> <?php echo number_format( $data['drop_percentage'], 2 ); ?>% below average
                </p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <div style="background: #fff8e1; padding: 15px; border-radius: 8px; border-left: 4px solid #ffc107;">
                <h3 style="margin-top: 0;">💡 Recommended Actions:</h3>
                <ul style="margin: 10px 0; padding-left: 20px;">
                    <li>Review product costs for this order</li>
                    <li>Check if pricing needs adjustment</li>
                    <li>Verify shipping and payment gateway fees</li>
                    <li>Consider margin optimization strategies</li>
                </ul>
            </div>

            <div style="text-align: center; margin-top: 30px;">
                <?php if ( $order ) : ?>
                <a href="<?php echo esc_url( $order->get_edit_order_url() ); ?>" class="button">
                    View Order Details →
                </a>
                <?php endif; ?>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-order-profitability' ) ); ?>" class="button" style="background: #6c757d;">
                    View All Orders →
                </a>
            </div>
        </div>

        <div class="footer">
            <p><strong>NeuralCommerce Profit Analytics</strong> | <?php echo esc_html( get_bloginfo( 'name' ) ); ?></p>
            <p><a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-settings&tab=alerts' ) ); ?>">Manage Alert Settings</a></p>
        </div>
    </div>
</body>
</html>
