<?php
/**
 * Daily Profit Summary Email Template
 *
 * @package QuarkcodeNeuralCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$yesterday = $data['yesterday'] ?? array();
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$last_week = $data['last_week'] ?? array();
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$date = $data['date'] ?? wp_date( 'Y-m-d', strtotime( '-1 day' ) );
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 650px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 40px 30px; text-align: center; color: white; border-radius: 8px 8px 0 0; }
        .content { background: #fff; padding: 30px; border: 1px solid #ddd; }
        .date-badge { display: inline-block; background: rgba(255,255,255,0.2); padding: 8px 16px; border-radius: 20px; font-size: 14px; }
        .metrics-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; margin: 25px 0; }
        .metric-card { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 8px; text-align: center; }
        .metric-card.revenue { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }
        .metric-card.cost { background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%); }
        .metric-card.profit { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }
        .metric-card.margin { background: linear-gradient(135deg, #30cfd0 0%, #330867 100%); }
        .metric-value { font-size: 32px; font-weight: 700; margin: 10px 0; }
        .metric-label { font-size: 12px; opacity: 0.9; text-transform: uppercase; letter-spacing: 1px; }
        .comparison { font-size: 14px; opacity: 0.85; margin-top: 5px; }
        .comparison.up { color: #a5d6a7; }
        .comparison.down { color: #ef9a9a; }
        .section { margin: 30px 0; }
        .section-title { font-size: 18px; font-weight: 600; color: #667eea; margin-bottom: 15px; border-bottom: 2px solid #f0f0f0; padding-bottom: 10px; }
        .product-list { background: #f8f9fa; border-radius: 8px; padding: 15px; }
        .product-item { background: white; padding: 15px; margin: 10px 0; border-radius: 6px; display: flex; justify-content: space-between; align-items: center; }
        .product-rank { background: #667eea; color: white; width: 30px; height: 30px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: 700; }
        .button { display: inline-block; padding: 14px 28px; background: #667eea; color: #fff; text-decoration: none; border-radius: 6px; margin: 10px 5px; font-weight: 600; }
        .footer { background: #f8f9fa; padding: 25px; text-align: center; font-size: 12px; color: #666; border-radius: 0 0 8px 8px; }
        table.summary-table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        table.summary-table td { padding: 12px; border-bottom: 1px solid #eee; }
        table.summary-table td:first-child { font-weight: 600; color: #555; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div style="font-size: 48px; margin-bottom: 15px;">📊</div>
            <h1 style="margin: 0;">Daily Profit Summary</h1>
            <div class="date-badge">
                <?php echo esc_html(wp_date( 'l, F j, Y', strtotime( $date ) )); ?>
            </div>
        </div>

        <div class="content">
            <!-- Key Metrics -->
            <div class="metrics-grid">
                <div class="metric-card revenue">
                    <div class="metric-label">Total Revenue</div>
                    <div class="metric-value"><?php echo wp_kses_post(wc_price( $yesterday['total_revenue'] ?? 0 )); ?></div>
                    <?php if ( isset( $yesterday['order_count'] ) ) : ?>
                    <div class="comparison"><?php echo intval( $yesterday['order_count'] ); ?> orders</div>
                    <?php endif; ?>
                </div>

                <div class="metric-card cost">
                    <div class="metric-label">Total Cost</div>
                    <div class="metric-value"><?php echo wp_kses_post(wc_price( $yesterday['total_cost'] ?? 0 )); ?></div>
                </div>

                <div class="metric-card profit">
                    <div class="metric-label">Net Profit</div>
                    <div class="metric-value"><?php echo wp_kses_post(wc_price( $yesterday['total_profit'] ?? 0 )); ?></div>
                    <?php if ( isset( $last_week['avg_profit'] ) ) : ?>
                        <?php 
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        $profit_diff = ( $yesterday['total_profit'] ?? 0 ) - $last_week['avg_profit'];
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        $diff_class = $profit_diff >= 0 ? 'up' : 'down';
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        $diff_icon = $profit_diff >= 0 ? '↑' : '↓';
                        ?>
                        <div class="comparison <?php echo esc_html($diff_class); ?>">
                            <?php echo esc_html($diff_icon); ?> <?php echo wp_kses_post(wc_price( abs( $profit_diff ) )); ?> vs 7-day avg
                        </div>
                    <?php endif; ?>
                </div>

                <div class="metric-card margin">
                    <div class="metric-label">Average Margin</div>
                    <div class="metric-value"><?php echo number_format( $yesterday['avg_margin'] ?? 0, 2 ); ?>%</div>
                    <?php if ( isset( $last_week['avg_margin'] ) ) : ?>
                        <?php 
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        $margin_diff = ( $yesterday['avg_margin'] ?? 0 ) - $last_week['avg_margin'];
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        $diff_class = $margin_diff >= 0 ? 'up' : 'down';
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        $diff_icon = $margin_diff >= 0 ? '↑' : '↓';
                        ?>
                        <div class="comparison <?php echo esc_html($diff_class); ?>">
                            <?php echo esc_html($diff_icon); ?> <?php echo number_format( abs( $margin_diff ), 2 ); ?>% vs 7-day avg
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Top Profitable Products -->
            <?php if ( ! empty( $data['top_products'] ) ) : ?>
            <div class="section">
                <div class="section-title">🏆 Top 5 Profitable Products</div>
                <div class="product-list">
                    <?php 
                    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                    foreach ( $data['top_products'] as $index => $product_data ) : ?>
                        <?php 
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            $product = wc_get_product( $product_data['product_id'] ); ?>
                        <?php if ( $product ) : ?>
                        <div class="product-item">
                            <div style="display: flex; align-items: center; gap: 15px;">
                                <div class="product-rank"><?php echo esc_html($index + 1); ?></div>
                                <div>
                                    <strong><?php echo esc_html( $product->get_name() ); ?></strong>
                                    <div style="font-size: 12px; color: #666;">
                                        <?php echo intval( $product_data['order_count'] ); ?> orders • 
                                        <?php echo number_format( $product_data['avg_margin'], 2 ); ?>% margin
                                    </div>
                                </div>
                            </div>
                            <div style="text-align: right;">
                                <strong style="color: #28a745; font-size: 18px;">
                                    <?php echo wp_kses_post(wc_price( $product_data['total_profit'] )); ?>
                                </strong>
                            </div>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Low Margin Products Warning -->
            <?php if ( ! empty( $data['low_margin_products'] ) ) : ?>
            <div class="section">
                <div class="section-title" style="color: #dc3545;">⚠️ Products with Low Margins</div>
                <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; border-radius: 8px;">
                    <p style="margin-top: 0;"><strong>These products had margins below 15% yesterday:</strong></p>
                    <div class="product-list" style="background: transparent;">
                        <?php 
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        foreach ( $data['low_margin_products'] as $product_data ) : ?>
                            <?php 
                                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                                $product = wc_get_product( $product_data['product_id'] ); ?>
                            <?php if ( $product ) : ?>
                            <div class="product-item" style="border-left: 4px solid #dc3545;">
                                <div>
                                    <strong><?php echo esc_html( $product->get_name() ); ?></strong>
                                    <div style="font-size: 12px; color: #666;">
                                        <?php echo intval( $product_data['order_count'] ); ?> orders
                                    </div>
                                </div>
                                <div style="text-align: right;">
                                    <strong style="color: #dc3545; font-size: 18px;">
                                        <?php echo number_format( $product_data['avg_margin'], 2 ); ?>%
                                    </strong>
                                    <div style="font-size: 11px; color: #666;">margin</div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                    <p style="margin-bottom: 0; font-size: 14px;">
                        💡 Consider reviewing costs and pricing for these products.
                    </p>
                </div>
            </div>
            <?php endif; ?>

            <!-- 7-Day Comparison -->
            <div class="section">
                <div class="section-title">📈 7-Day Performance Comparison</div>
                <table class="summary-table">
                    <tr>
                        <td>Average Daily Profit (Last 7 Days)</td>
                        <td style="text-align: right;"><strong><?php echo wp_kses_post(wc_price( $last_week['avg_profit'] ?? 0 )); ?></strong></td>
                    </tr>
                    <tr>
                        <td>Yesterday's Profit</td>
                        <td style="text-align: right;"><strong><?php echo wp_kses_post(wc_price( $yesterday['total_profit'] ?? 0 )); ?></strong></td>
                    </tr>
                    <tr style="background: #f8f9fa;">
                        <td><strong>Difference</strong></td>
                        <td style="text-align: right;">
                            <?php 
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            $diff = ( $yesterday['total_profit'] ?? 0 ) - ( $last_week['avg_profit'] ?? 0 );
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            $color = $diff >= 0 ? '#28a745' : '#dc3545';
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            $icon = $diff >= 0 ? '↑' : '↓';
                            ?>
                            <strong style="color: <?php echo esc_html($color); ?>; font-size: 16px;">
                                <?php echo esc_html($icon); ?> <?php echo wp_kses_post(wc_price( abs( $diff ) )); ?>
                                (<?php echo number_format( abs( $diff / max( $last_week['avg_profit'], 1 ) ) * 100, 2 ); ?>%)
                            </strong>
                        </td>
                    </tr>
                </table>
            </div>

            <!-- Action Buttons -->
            <div style="text-align: center; margin-top: 40px; padding-top: 30px; border-top: 2px solid #f0f0f0;">
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-dashboard' ) ); ?>" class="button">
                    View Full Dashboard →
                </a>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-reports' ) ); ?>" class="button" style="background: #6c757d;">
                    Generate Report →
                </a>
            </div>
        </div>

        <div class="footer">
            <p><strong>NeuralCommerce Daily Profit Summary</strong></p>
            <p style="color: #999; margin: 10px 0;">
                This automated summary helps you stay on top of your store's profitability
            </p>
            <p>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-settings&tab=alerts' ) ); ?>">Manage Email Preferences</a>
            </p>
            <p style="color: #999; font-size: 11px; margin-top: 15px;">
                <?php echo esc_html( get_bloginfo( 'name' ) ); ?> • <?php echo esc_html( get_bloginfo( 'url' ) ); ?>
            </p>
        </div>
    </div>
</body>
</html>
