<?php
/**
 * Cost Increase Alert Email Template
 *
 * @package QuarkcodeNeuralCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$product = isset( $data['product_id'] ) ? wc_get_product( $data['product_id'] ) : null;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); padding: 30px; text-align: center; color: white; border-radius: 8px 8px 0 0; }
        .content { background: #fff; padding: 30px; border: 1px solid #ddd; }
        .product-info { background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0; }
        .cost-comparison { display: flex; justify-content: space-around; margin: 20px 0; padding: 20px; background: #fff3cd; border-radius: 8px; }
        .cost-item { text-align: center; }
        .cost-value { font-size: 28px; font-weight: 700; margin: 10px 0; }
        .cost-label { font-size: 12px; color: #666; text-transform: uppercase; }
        .increase-badge { display: inline-block; background: #dc3545; color: white; padding: 8px 16px; border-radius: 20px; font-weight: 600; }
        .button { display: inline-block; padding: 12px 24px; background: #007cba; color: #fff; text-decoration: none; border-radius: 4px; margin: 10px 5px; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div style="font-size: 48px; margin-bottom: 10px;">📈</div>
            <h1 style="margin: 0;">Product Cost Increase Alert</h1>
            <p style="margin: 10px 0 0 0; opacity: 0.9;">Price adjustment may be needed</p>
        </div>

        <div class="content">
            <div class="product-info">
                <h2 style="margin-top: 0; color: #d32f2f;">
                    <?php echo esc_html( $data['product_name'] ?? 'Product' ); ?>
                </h2>
                <?php if ( ! empty( $data['sku'] ) ) : ?>
                <p style="color: #666;"><strong>SKU:</strong> <?php echo esc_html( $data['sku'] ); ?></p>
                <?php endif; ?>

                <div class="increase-badge">
                    ↑ <?php echo number_format( $data['increase_percentage'] ?? 0, 2 ); ?>% Increase
                </div>
            </div>

            <div class="cost-comparison">
                <div class="cost-item">
                    <div class="cost-label">Previous Cost</div>
                    <div class="cost-value" style="color: #28a745;">
                        <?php echo wp_kses_post(wc_price( $data['old_cost'] ?? 0 )); ?>
                    </div>
                </div>
                <div class="cost-item" style="font-size: 32px; color: #ccc;">→</div>
                <div class="cost-item">
                    <div class="cost-label">New Cost</div>
                    <div class="cost-value" style="color: #dc3545;">
                        <?php echo wp_kses_post(wc_price( $data['new_cost'] ?? 0 )); ?>
                    </div>
                </div>
            </div>

            <?php if ( isset( $data['price'] ) && $data['price'] > 0 ) : ?>
            <div style="background: #e8f5e9; padding: 15px; border-radius: 8px; margin: 20px 0;">
                <h3 style="margin-top: 0;">💰 Current Pricing Analysis</h3>
                <table style="width: 100%;">
                    <tr>
                        <td><strong>Selling Price:</strong></td>
                        <td><?php echo wp_kses_post(wc_price( $data['price'] )); ?></td>
                    </tr>
                    <tr>
                        <td><strong>New Cost:</strong></td>
                        <td><?php echo wp_kses_post(wc_price( $data['new_cost'] )); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Current Margin:</strong></td>
                        <td>
                            <?php 
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            $current_margin = ( $data['price'] > 0 ) 
                                ? ( ( $data['price'] - $data['new_cost'] ) / $data['price'] ) * 100 
                                : 0;
                                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            $margin_color = $current_margin > 30 ? '#28a745' : ( $current_margin > 15 ? '#ffc107' : '#dc3545' );
                            ?>
                            <strong style="color: <?php echo esc_html($margin_color); ?>">
                                <?php echo number_format( $current_margin, 2 ); ?>%
                            </strong>
                        </td>
                    </tr>
                </table>
            </div>

            <?php 
            // Calculate recommended price for target margin
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
            $target_margin = 30; // 30% target
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
            $recommended_price = $data['new_cost'] / ( 1 - ( $target_margin / 100 ) );
            ?>
            <div style="background: #fff3cd; padding: 15px; border-radius: 8px; border-left: 4px solid #ffc107;">
                <h3 style="margin-top: 0;">💡 Recommended Actions:</h3>
                <ul style="margin: 10px 0; padding-left: 20px;">
                    <li>Consider adjusting selling price to maintain margin</li>
                    <li><strong>Suggested Price for 30% Margin:</strong> <?php echo wp_kses_post(wc_price( $recommended_price )); ?></li>
                    <li>Review supplier costs and negotiate if possible</li>
                    <li>Check if competitors have similar increases</li>
                </ul>
            </div>
            <?php endif; ?>

            <div style="text-align: center; margin-top: 30px;">
                <?php if ( $product ) : ?>
                <a href="<?php echo esc_url( get_edit_post_link( $data['product_id'] ) ); ?>" class="button">
                    Edit Product →
                </a>
                <?php endif; ?>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-product-costs' ) ); ?>" class="button" style="background: #6c757d;">
                    View All Costs →
                </a>
            </div>
        </div>

        <div class="footer">
            <p><strong>NeuralCommerce Profit Analytics</strong></p>
            <p><a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-settings&tab=alerts' ) ); ?>">Manage Alert Settings</a></p>
        </div>
    </div>
</body>
</html>
