<?php
/**
 * Anomaly Detection Alert Email Template
 *
 * @package QuarkcodeNeuralCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); padding: 30px; text-align: center; color: white; border-radius: 8px 8px 0 0; }
        .content { background: #fff; padding: 30px; border: 1px solid #ddd; }
        .stats-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin: 20px 0; }
        .stat-card { background: #f8f9fa; padding: 15px; border-radius: 8px; text-align: center; }
        .stat-value { font-size: 24px; font-weight: 700; color: #007cba; }
        .stat-label { font-size: 12px; color: #666; text-transform: uppercase; margin-top: 5px; }
        .anomaly-list { background: #fff8e1; padding: 20px; border-radius: 8px; margin: 20px 0; }
        .anomaly-item { background: white; padding: 15px; margin: 10px 0; border-left: 4px solid #ff9800; border-radius: 4px; }
        .z-score { display: inline-block; padding: 4px 8px; background: #ff9800; color: white; border-radius: 4px; font-size: 12px; font-weight: 600; }
        .z-score.critical { background: #dc3545; }
        .button { display: inline-block; padding: 12px 24px; background: #007cba; color: #fff; text-decoration: none; border-radius: 4px; margin: 10px 5px; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div style="font-size: 48px; margin-bottom: 10px;">🔍</div>
            <h1 style="margin: 0;">Profit Anomaly Detected</h1>
            <p style="margin: 10px 0 0 0; opacity: 0.9;">Unusual patterns detected in your profit data</p>
        </div>

        <div class="content">
            <div style="background: #e3f2fd; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
                <h2 style="margin-top: 0; color: #1976d2;">📊 Statistical Analysis Summary</h2>
                <p style="margin: 0;">
                    Our AI has detected <strong><?php echo count( $data['anomalies'] ?? array() ); ?> unusual profit patterns</strong> 
                    in the last 7 days compared to your 90-day baseline.
                </p>
            </div>

            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-value"><?php echo wp_kses_post(wc_price( $data['profit_mean'] ?? 0 )); ?></div>
                    <div class="stat-label">Average Profit (90 days)</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?php echo number_format( $data['margin_mean'] ?? 0, 2 ); ?>%</div>
                    <div class="stat-label">Average Margin (90 days)</div>
                </div>
            </div>

            <?php if ( ! empty( $data['anomalies'] ) ) : ?>
            <div class="anomaly-list">
                <h3 style="margin-top: 0;">🚨 Detected Anomalies</h3>
                <p style="color: #666; font-size: 14px;">Orders with unusual profit or margin patterns (Z-score > 2.0)</p>

                <?php 
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Loop variable, not global
                foreach ( array_slice( $data['anomalies'], 0, 5 ) as $anomaly ) : ?>
                    <?php 
                    $order = wc_get_order( $anomaly['order_id'] );
                    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Loop variable, not global
                    $is_critical = abs( $anomaly['profit_z_score'] ) > 3 || abs( $anomaly['margin_z_score'] ) > 3;
                    ?>
                    <div class="anomaly-item">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <strong>Order #<?php echo esc_html($order ? $order->get_order_number() : $anomaly['order_id']); ?></strong>
                                <br/>
                                <small style="color: #666;"><?php echo esc_html(wp_date( 'M d, Y', strtotime( $anomaly['date'] ) )); ?></small>
                            </div>
                            <div style="text-align: right;">
                                <div><?php echo wp_kses_post(wc_price( $anomaly['profit'] )); ?></div>
                                <div style="font-size: 12px; color: #666;"><?php echo number_format( $anomaly['margin'], 2 ); ?>% margin</div>
                            </div>
                        </div>
                        <div style="margin-top: 10px;">
                            <span class="z-score <?php echo $is_critical ? 'critical' : ''; ?>">
                                Profit Z-Score: <?php echo esc_html($anomaly['profit_z_score']); ?>
                            </span>
                            <span class="z-score <?php echo $is_critical ? 'critical' : ''; ?>" style="margin-left: 10px;">
                                Margin Z-Score: <?php echo esc_html($anomaly['margin_z_score']); ?>
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>

                <?php if ( count( $data['anomalies'] ) > 5 ) : ?>
                <p style="text-align: center; margin: 15px 0 0 0; color: #666;">
                    +<?php echo count( $data['anomalies'] ) - 5; ?> more anomalies detected
                </p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <div style="background: #f3e5f5; padding: 15px; border-radius: 8px; margin: 20px 0;">
                <h3 style="margin-top: 0;">📚 What is a Z-Score?</h3>
                <p style="margin: 0; font-size: 14px;">
                    A Z-score measures how many standard deviations a value is from the average. 
                    A Z-score above 2.0 or below -2.0 indicates an unusual pattern that may need attention.
                </p>
            </div>

            <div style="background: #fff3cd; padding: 15px; border-radius: 8px; border-left: 4px solid #ffc107;">
                <h3 style="margin-top: 0;">💡 What This Means:</h3>
                <ul style="margin: 10px 0; padding-left: 20px;">
                    <li>These orders have significantly different profit patterns than normal</li>
                    <li>Could indicate data entry errors, unusual costs, or pricing issues</li>
                    <li>May reveal opportunities to optimize pricing or costs</li>
                    <li>Helps identify trends before they become problems</li>
                </ul>
            </div>

            <div style="text-align: center; margin-top: 30px;">
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-order-profitability' ) ); ?>" class="button">
                    View All Orders →
                </a>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-reports' ) ); ?>" class="button" style="background: #6c757d;">
                    View Reports →
                </a>
            </div>
        </div>

        <div class="footer">
            <p><strong>NeuralCommerce AI-Powered Analytics</strong></p>
            <p style="color: #999;">Detection Period: <?php echo esc_html( $data['detection_period'] ?? '90 days' ); ?></p>
            <p><a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-settings&tab=alerts' ) ); ?>">Manage Alert Settings</a></p>
        </div>
    </div>
</body>
</html>
