<?php
/**
 * Shipping Integration
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

namespace QuarkcodeNeuralCommerce\Integrations;

use QuarkcodeNeuralCommerce\Utilities\QCNC_Logger;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Manages shipping cost tracking.
 */
class QCNC_Shipping_Integration {

    /**
     * Logger instance.
     *
     * @var QCNC_Logger
     */
    private $logger;

    /**
     * Constructor.
     *
     * @param QCNC_Logger $logger Logger.
     */
    public function __construct( QCNC_Logger $logger ) {
        $this->logger = $logger;
        $this->init_hooks();
    }

    /**
     * Initialize hooks.
     */
    private function init_hooks() {
        // Future: Hook into shipping methods for cost tracking.
    }

    /**
     * Get shipping cost for order.
     *
     * @param \WC_Order $order Order object.
     * @return float Shipping cost.
     */
    public function get_shipping_cost( $order ) {
        $shipping_total = floatval( $order->get_shipping_total() );
        
        // Future: Add actual carrier cost tracking.
        // For now, return the shipping total as the cost.
        
        return $shipping_total;
    }

    /**
     * Get shipping methods with cost tracking.
     *
     * @return array Shipping methods.
     */
    public function get_shipping_methods() {
        $shipping_methods = WC()->shipping()->get_shipping_methods();
        $methods = [];

        foreach ( $shipping_methods as $method ) {
            $methods[] = [
                'id'    => $method->id,
                'title' => $method->get_method_title(),
            ];
        }

        return $methods;
    }
}
