<?php
/**
 * Plugin Deactivator
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

namespace QuarkcodeNeuralCommerce;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Plugin deactivation handler.
 */
class QCNC_Deactivator {

    /**
     * Run deactivation tasks.
     */
    public static function deactivate() {
        // Clear scheduled cron jobs.
        self::clear_cron_jobs();

        // Clear all transient caches.
        self::clear_transients();

        // Clear CLV cron schedules
        // $cron = new Cron\Cron_Jobs();
        // $cron->clear_clv_schedules();

        // Flush rewrite rules.
        flush_rewrite_rules();

        // Log deactivation.
        // error_log( 'Quarkcode NeuralCommerce deactivated at ' . current_time( 'mysql' ) );
    }

    /**
     * Clear all scheduled cron jobs.
     */
    private static function clear_cron_jobs() {
        $cron_hooks = [
            'qcnc_daily_profit_recalc',
            'qcnc_weekly_report',
            'qcnc_monthly_summary',
            'qcnc_cache_cleanup',
        ];

        foreach ( $cron_hooks as $hook ) {
            $timestamp = wp_next_scheduled( $hook );
            if ( $timestamp ) {
                wp_unschedule_event( $timestamp, $hook );
            }
            wp_clear_scheduled_hook( $hook );
        }
    }

    /**
     * Clear all plugin transients.
     */
    private static function clear_transients() {
        global $wpdb;

        // Delete all transients with qcnc_ prefix.
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery
        $wpdb->query(
            "DELETE FROM {$wpdb->options} 
             WHERE option_name LIKE '_transient_qcnc_%' 
             OR option_name LIKE '_transient_timeout_qcnc_%'"
        );

        // Clear object cache if available.
        if ( function_exists( 'wp_cache_flush' ) ) {
            wp_cache_flush();
        }
    }
}