<?php
/**
 * REST API Base Controller
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

namespace QuarkcodeNeuralCommerce\API;

use QuarkcodeNeuralCommerce\Utilities\QCNC_Security;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Base REST API controller.
 */
class QCNC_Rest_Controller extends \WP_REST_Controller {

    /**
     * Namespace.
     *
     * @var string
     */
    protected $namespace = 'qcnc/v1';

    /**
     * Security instance.
     *
     * @var QCNC_Security
     */
    protected $security;

    /**
     * Constructor.
     *
     * @param QCNC_Security $security Security.
     */
    public function __construct( QCNC_Security $security ) {
        $this->security = $security;
    }

    /**
     * Check if user has permission.
     *
     * @param \WP_REST_Request $request Request object.
     * @return bool Has permission.
     */
    public function check_permission( $request ) {
        return $this->security->check_capability( 'manage_woocommerce' );
    }

    /**
     * Prepare error response.
     *
     * @param string $message Error message.
     * @param int    $code    Error code.
     * @return \WP_Error Error object.
     */
    protected function prepare_error( $message, $code = 400 ) {
        return new \WP_Error( 'qcnc_error', $message, [ 'status' => $code ] );
    }

    /**
     * Prepare success response.
     *
     * @param mixed $data Response data.
     * @return \WP_REST_Response Response object.
     */
    protected function prepare_response( $data ) {
        return new \WP_REST_Response( $data, 200 );
    }
}
