<?php
/**
 * Settings View - Modern & Unified Layout
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

settings_errors( 'qcnc_settings' );
?>

<div class="wrap qcnc-settings">
    
    <!-- Modern Header -->
    <div class="qcnc-dashboard-header">
        <div class="qcnc-header-left">
            <h1>
                <span class="dashicons dashicons-admin-settings"></span>
                <?php esc_html_e( 'NeuralCommerce Settings', 'quarkcode-neuralcommerce-lite' ); ?>
            </h1>
            <p class="qcnc-subtitle">
                <?php esc_html_e( 'Configure your profit protection engine, AI integrations, and automated alerts.', 'quarkcode-neuralcommerce-lite' ); ?>
            </p>
        </div>
        
        <div class="qcnc-header-right">
            <!--
            <button type="submit" form="qcnc-settings-form" class="button button-primary qcnc-save-btn">
                <span class="dashicons dashicons-saved"></span>
                <?php esc_html_e( 'Save All Changes', 'quarkcode-neuralcommerce-lite' ); ?>
            </button>
            -->
        </div>

    </div>

    <form id="qcnc-settings-form" method="post" action="" class="qcnc-settings-main-container">
        <?php wp_nonce_field( 'qcnc_save_settings', 'qcnc_nonce' ); ?>

        <div class="qcnc-settings-grid">
            <!-- COLUMN 1: AI & CORE -->
            <div class="qcnc-settings-column">
                
                <!-- Alert Channels Card -->
                <div class="qcnc-card">
                    <div class="qcnc-card-header">
                        <div class="qcnc-card-icon"><span class="dashicons dashicons-email"></span></div>
                        <h3><?php esc_html_e( 'Notification Channels', 'quarkcode-neuralcommerce-lite' ); ?></h3>
                    </div>
                    <div class="qcnc-card-body">
                        <div class="qcnc-form-group">
                            <label for="qcnc_alert_email"><?php esc_html_e( 'Primary Alert Email', 'quarkcode-neuralcommerce-lite' ); ?></label>
                            <input type="email" id="qcnc_alert_email" name="qcnc_alert_email" 
                                   value="<?php echo esc_attr( get_option( 'qcnc_alert_email', get_option( 'admin_email' ) ) ); ?>">
                        </div>
                        <div class="qcnc-form-group">
                            <label for="qcnc_additional_alert_emails"><?php esc_html_e( 'Additional Recipients', 'quarkcode-neuralcommerce-lite' ); ?></label>
                            <textarea id="qcnc_additional_alert_emails" name="qcnc_additional_alert_emails" rows="2" placeholder="one-per-line@example.com"><?php echo esc_textarea( get_option( 'qcnc_additional_alert_emails', '' ) ); ?></textarea>
                        </div>

                    </div>
                </div>
            </div>

            <!-- COLUMN 2: THRESHOLDS & SMS -->
            <div class="qcnc-settings-column">

                <!-- Alert Thresholds Card -->
                <div class="qcnc-card">
                    <div class="qcnc-card-header">
                        <div class="qcnc-card-icon"><span class="dashicons dashicons-chart-bar"></span></div>
                        <h3><?php esc_html_e( 'Profitability Thresholds', 'quarkcode-neuralcommerce-lite' ); ?></h3>
                    </div>
                    <div class="qcnc-card-body">
                        <div class="qcnc-row">
                            <div class="qcnc-form-group">
                                <label><?php esc_html_e( 'Min Margin (%)', 'quarkcode-neuralcommerce-lite' ); ?></label>
                                <input type="number" name="qcnc_margin_threshold" id="qcnc_margin_threshold" step="0.1" value="<?php echo esc_attr( get_option( 'qcnc_margin_threshold', '20' ) ); ?>">
                            </div>
                            <div class="qcnc-form-group">
                                <label><?php esc_html_e( 'Cost Surge (%)', 'quarkcode-neuralcommerce-lite' ); ?></label>
                                <input type="number" name="qcnc_cost_increase_threshold" id="qcnc_cost_increase_threshold" step="0.1" value="<?php echo esc_attr( get_option( 'qcnc_cost_increase_threshold', '10' ) ); ?>">
                            </div>
                        </div>
                        <div class="qcnc-row">
                            <div class="qcnc-form-group">
                                <label><?php esc_html_e( 'Margin Drop (%)', 'quarkcode-neuralcommerce-lite' ); ?></label>
                                <input type="number" name="qcnc_margin_drop_threshold" id="qcnc_margin_drop_threshold" step="0.1" value="<?php echo esc_attr( get_option( 'qcnc_margin_drop_threshold', '30' ) ); ?>">
                            </div>
                            <div class="qcnc-form-group">
                                <label><?php esc_html_e( 'Summary Time', 'quarkcode-neuralcommerce-lite' ); ?></label>
                                <input type="time" name="qcnc_daily_summary_time" id="qcnc_daily_summary_time" value="<?php echo esc_attr( get_option( 'qcnc_daily_summary_time', '08:00' ) ); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- FULL WIDTH: ALERT TYPES SELECTION -->
        <div class="qcnc-card" style="margin-top: 24px;">
            <div class="qcnc-card-header">
                <div class="qcnc-card-icon"><span class="dashicons dashicons-megaphone"></span></div>
                <h3><?php esc_html_e( 'Active Profit Watchers', 'quarkcode-neuralcommerce-lite' ); ?></h3>
                <p class="qcnc-card-subtitle-inline"><?php esc_html_e( 'Select which specific events trigger a notification.', 'quarkcode-neuralcommerce-lite' ); ?></p>
            </div>
            <div class="qcnc-card-body">
                <div class="qcnc-alert-types-grid">
                    <?php
                    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                    $enabled_alerts = get_option( 'qcnc_enabled_alerts', array('margin_drop', 'cost_increase', 'unprofitable', 'anomaly_detected', 'daily_summary') );
                    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                    $alert_types = array(
                        'margin_drop'      => __( 'Low Margin Drop', 'quarkcode-neuralcommerce-lite' ),
                        'cost_increase'    => __( 'Cost Surge Detection', 'quarkcode-neuralcommerce-lite' ),
                        'unprofitable'     => __( 'Loss-Making Orders', 'quarkcode-neuralcommerce-lite' ),
                        'anomaly_detected' => __( 'AI Anomaly Detection', 'quarkcode-neuralcommerce-lite' ),
                        'daily_summary'    => __( 'Daily Profit Summary', 'quarkcode-neuralcommerce-lite' ),
                    );
                    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                    $test_map = array(
                        'margin_drop' => 'low_margin',
                        'cost_increase' => 'cost_increase',
                        'unprofitable' => 'unprofitable_order',
                        'anomaly_detected' => 'anomaly_detected',
                        'daily_summary' => 'daily_summary'
                    );

                    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                    foreach ( $alert_types as $key => $label ) :
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        $test_type = isset( $test_map[$key] ) ? $test_map[$key] : $key;
                    ?>
                        <div class="qcnc-alert-selector-item">
                            <label class="qcnc-checkbox-label">
                                <input type="checkbox" name="qcnc_enabled_alerts[]" value="<?php echo esc_attr( $key ); ?>" <?php checked( in_array( $key, $enabled_alerts ) ); ?>>
                                <span class="qcnc-checkbox-text"><?php echo esc_html( $label ); ?></span>
                            </label>
                            <button type="button" class="qcnc-test-alert-btn button button-small" data-alert-type="<?php echo esc_attr( $test_type ); ?>">
                                <span class="dashicons dashicons-email"></span> <?php esc_html_e( 'Send Test', 'quarkcode-neuralcommerce-lite' ); ?>
                            </button>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- DIGEST EMAIL SETTINGS -->
        <div class="qcnc-card">
            <div class="qcnc-card-header">
                <h3><?php esc_html_e( '📧 Email Delivery Settings', 'quarkcode-neuralcommerce-lite' ); ?></h3>
                <p class="qcnc-card-subtitle-inline">
                    <?php esc_html_e( 'Control how and when alert emails are sent to prevent spam.', 'quarkcode-neuralcommerce-lite' ); ?>
                </p>
            </div>
            <div class="qcnc-card-body">

                <!-- Alert Delivery Mode -->
                <div class="qcnc-form-row">
                    <div class="qcnc-form-label">
                        <label for="qcnc_alert_digest_mode">
                            <?php esc_html_e( 'Alert Delivery Mode', 'quarkcode-neuralcommerce-lite' ); ?>
                        </label>
                        <p class="description">
                            <?php esc_html_e( 'Choose how alert emails are delivered', 'quarkcode-neuralcommerce-lite' ); ?>
                        </p>
                    </div>
                    <div class="qcnc-form-field">
                        <select name="qcnc_alert_digest_mode" id="qcnc_alert_digest_mode" class="qcnc-select">
                            <option value="immediate" <?php selected( get_option( 'qcnc_alert_digest_mode', 'hourly' ), 'immediate' ); ?>>
                                <?php esc_html_e( '⚡ Immediate - Send each alert as it happens', 'quarkcode-neuralcommerce-lite' ); ?>
                            </option>
                            <option value="hourly" <?php selected( get_option( 'qcnc_alert_digest_mode', 'hourly' ), 'hourly' ); ?>>
                                <?php esc_html_e( '⏰ Hourly Digest - Batch alerts every hour (Recommended)', 'quarkcode-neuralcommerce-lite' ); ?>
                            </option>
                            <option value="daily" <?php selected( get_option( 'qcnc_alert_digest_mode', 'hourly' ), 'daily' ); ?>>
                                <?php esc_html_e( '📅 Daily Digest - One email per day at 9 AM', 'quarkcode-neuralcommerce-lite' ); ?>
                            </option>
                        </select>

                        <div class="qcnc-info-box" style="margin-top: 12px;">
                            <span class="dashicons dashicons-info"></span>
                            <div>
                                <strong><?php esc_html_e( 'Mode Comparison:', 'quarkcode-neuralcommerce-lite' ); ?></strong>
                                <ul style="margin: 8px 0 0 20px; line-height: 1.6;">
                                    <li><strong>Immediate:</strong> <?php esc_html_e( 'Get instant alerts but may trigger spam filters', 'quarkcode-neuralcommerce-lite' ); ?></li>
                                    <li><strong>Hourly:</strong> <?php esc_html_e( 'Perfect balance - stay informed without spam', 'quarkcode-neuralcommerce-lite' ); ?></li>
                                    <li><strong>Daily:</strong> <?php esc_html_e( 'Best for mature stores with stable margins', 'quarkcode-neuralcommerce-lite' ); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="qcnc-success-box" style="margin-top: 12px;">
                            <span class="dashicons dashicons-yes-alt"></span>
                            <div>
                                <strong><?php esc_html_e( '💡 Recommended:', 'quarkcode-neuralcommerce-lite' ); ?></strong>
                                <?php esc_html_e( 'Use "Hourly Digest" to prevent email spam while staying informed about profit issues.', 'quarkcode-neuralcommerce-lite' ); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Rate Limiting -->
                <div class="qcnc-form-row">
                    <div class="qcnc-form-label">
                        <label for="qcnc_max_alerts_per_hour">
                            <?php esc_html_e( 'Rate Limiting', 'quarkcode-neuralcommerce-lite' ); ?>
                        </label>
                        <p class="description">
                            <?php esc_html_e( 'Maximum emails per hour (Immediate mode only)', 'quarkcode-neuralcommerce-lite' ); ?>
                        </p>
                    </div>
                    <div class="qcnc-form-field">
                        <input type="number" 
                               name="qcnc_max_alerts_per_hour" 
                               id="qcnc_max_alerts_per_hour"
                               value="<?php echo esc_attr( get_option( 'qcnc_max_alerts_per_hour', 10 ) ); ?>" 
                               min="1" 
                               max="100" 
                               step="1"
                               class="qcnc-input-small" />
                        <span class="qcnc-input-suffix"><?php esc_html_e( 'emails/hour', 'quarkcode-neuralcommerce-lite' ); ?></span>

                        <p class="description" style="margin-top: 8px;">
                            <?php esc_html_e( 'Prevents email spam by limiting how many alert emails can be sent per hour. Only applies to "Immediate" mode.', 'quarkcode-neuralcommerce-lite' ); ?>
                        </p>
                    </div>
                </div>

                <!-- Manual Digest Send -->
                <div class="qcnc-form-row">
                    <div class="qcnc-form-label">
                        <label><?php esc_html_e( 'Manual Digest', 'quarkcode-neuralcommerce-lite' ); ?></label>
                        <p class="description">
                            <?php 
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            $queue = get_option( 'qcnc_alert_digest_queue', array() );
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            $count = is_array( $queue ) ? count( $queue ) : 0;

                            if ( $count > 0 ) {
                                printf(
                                    /* translators: %d: Number of alerts in the digest */
                                    esc_html__( 'Currently %d alerts queued', 'quarkcode-neuralcommerce-lite' ),
                                    esc_html( $count )
                                );
                            } else {
                                esc_html_e( 'No alerts currently queued', 'quarkcode-neuralcommerce-lite' );
                            }
                            ?>
                        </p>
                    </div>
                    <div class="qcnc-form-field">
                        <button type="button" id="qcnc-send-digest-now" class="button button-secondary">
                            <span class="dashicons dashicons-email-alt"></span>
                            <?php esc_html_e( 'Send Digest Now', 'quarkcode-neuralcommerce-lite' ); ?>
                        </button>

                        <div id="qcnc-digest-result" style="margin-top: 12px;"></div>

                        <p class="description" style="margin-top: 8px;">
                            <?php esc_html_e( 'Manually send all queued alerts immediately as a digest email.', 'quarkcode-neuralcommerce-lite' ); ?>
                        </p>
                    </div>
                </div>

            </div>
        </div>

        <!-- FOOTER ACTIONS -->
        <div class="qcnc-settings-footer">
             <div class="qcnc-maintenance-links">
                <button type="button" id="qcnc-cleanup-duplicates" class="button button-link-delete">
                    <span class="dashicons dashicons-trash"></span> <?php esc_html_e( 'Clean Duplicate Costs', 'quarkcode-neuralcommerce-lite' ); ?>
                </button>
                <label class="qcnc-danger-checkbox">
                    <input type="checkbox" name="qcnc_delete_data_on_uninstall" value="1" <?php checked( get_option( 'qcnc_delete_data_on_uninstall' ), 1 ); ?>>
                    <span><?php esc_html_e( 'Wipe data on uninstall', 'quarkcode-neuralcommerce-lite' ); ?></span>
                </label>
             </div>
             <?php submit_button( __( 'Save Settings', 'quarkcode-neuralcommerce-lite' ), 'primary', 'qcnc_save_settings', false ); ?>
        </div>

    </form>

    <!-- Payment Gateways Section (Outside Form) -->
    <div class="qcnc-gateways-section">
        <div class="qcnc-section-header">
            <div>
                <h2><?php esc_html_e( 'Payment Gateway Fees', 'quarkcode-neuralcommerce-lite' ); ?></h2>
                <p class="description"><?php esc_html_e( 'Configure fees to calculate exact net profit per order.', 'quarkcode-neuralcommerce-lite' ); ?></p>
            </div>
            <button type="button" class="button button-primary" id="qcnc-add-gateway-fee">
                <?php esc_html_e( 'Add Fee', 'quarkcode-neuralcommerce-lite' ); ?>
            </button>
        </div>

        <?php
        global $wpdb;
        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
        $table = $wpdb->prefix . 'qcnc_payment_gateway_fees';
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, PluginCheck.Security.DirectDB.UnescapedDBParameter, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
        $gateways = $wpdb->get_results( "SELECT * FROM {$table} ORDER BY gateway_name ASC", ARRAY_A );
        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
        $wc_gateways = WC()->payment_gateways->payment_gateways();
        ?>

        <div class="qcnc-card" style="margin-top: 20px;">
            <table class="wp-list-table widefat fixed striped qcnc-modern-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Gateway', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Structure', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Fee', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Status', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th style="text-align: right;"><?php esc_html_e( 'Actions', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ( empty( $gateways ) ) : ?>
                        <tr>
                            <td colspan="5" style="text-align: center; padding: 20px; color: #64748b;">
                                <?php esc_html_e( 'No fees configured.', 'quarkcode-neuralcommerce-lite' ); ?>
                            </td>
                        </tr>
                    <?php else : ?>
                        <?php 
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            foreach ( $gateways as $gateway ) : ?>
                            <tr>
                                <td><strong><?php echo esc_html( $gateway['gateway_name'] ); ?></strong></td>
                                <td><?php echo esc_html( ucfirst( $gateway['fee_type'] ) ); ?></td>
                                <td>
                                    <?php 
                                    if($gateway['percentage_fee'] > 0) echo esc_html( $gateway['percentage_fee'] ) . '%';
                                    if($gateway['percentage_fee'] > 0 && $gateway['fixed_fee'] > 0) echo ' + ';
                                    if($gateway['fixed_fee'] > 0) echo esc_html( $gateway['fixed_fee'] ) . ' ' . esc_html($gateway['currency']);
                                    ?>
                                </td>
                                <td>
                                    <?php if($gateway['is_active']): ?>
                                        <span class="qcnc-badge badge-green"><?php esc_html_e( 'Active', 'quarkcode-neuralcommerce-lite' ); ?></span>
                                    <?php else: ?>
                                        <span class="qcnc-badge badge-gray"><?php esc_html_e( 'Inactive', 'quarkcode-neuralcommerce-lite' ); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td style="text-align: right;">
                                    <button type="button" class="button button-small qcnc-edit-gateway" data-id="<?php echo esc_attr( $gateway['id'] ); ?>">
                                        <span class="dashicons dashicons-edit"></span>
                                    </button>
                                    <button type="button" class="button button-small qcnc-delete-gateway" data-id="<?php echo esc_attr( $gateway['id'] ); ?>" style="color: #dc2626;">
                                        <span class="dashicons dashicons-trash"></span>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal for Gateways (Same HTML structure as before but kept for functionality) -->
    <div id="qcnc-gateway-modal" class="qcnc-modal" style="display: none;">
        <div class="qcnc-modal-content">
            <span class="qcnc-modal-close">&times;</span>
            <h2 id="qcnc-gateway-modal-title"><?php esc_html_e( 'Add Gateway Fee', 'quarkcode-neuralcommerce-lite' ); ?></h2>
            <form id="qcnc-gateway-form" class="qcnc-modal-form">
                <input type="hidden" id="qcnc-gateway-id" name="gateway_id">
                
                <div class="qcnc-form-group">
                    <label><?php esc_html_e( 'Gateway', 'quarkcode-neuralcommerce-lite' ); ?></label>
                    <select id="qcnc-gateway-select" name="gateway_id_select" class="regular-text" required>
                        <option value=""><?php esc_html_e( 'Select...', 'quarkcode-neuralcommerce-lite' ); ?></option>
                        <?php 
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                        foreach ( $wc_gateways as $gateway ) : ?>
                            <option value="<?php echo esc_attr( $gateway->id ); ?>"><?php echo esc_html( $gateway->get_title() ); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="qcnc-form-group">
                    <label><?php esc_html_e( 'Name', 'quarkcode-neuralcommerce-lite' ); ?></label>
                    <input type="text" id="qcnc-gateway-name" name="gateway_name" class="regular-text" required>
                </div>

                <div class="qcnc-form-group">
                    <label><?php esc_html_e( 'Fee Structure', 'quarkcode-neuralcommerce-lite' ); ?></label>
                    <select id="qcnc-fee-type" name="fee_type" class="regular-text" required>
                        <option value="mixed"><?php esc_html_e( 'Percentage + Fixed', 'quarkcode-neuralcommerce-lite' ); ?></option>
                        <option value="percentage"><?php esc_html_e( 'Percentage Only', 'quarkcode-neuralcommerce-lite' ); ?></option>
                        <option value="fixed"><?php esc_html_e( 'Fixed Amount Only', 'quarkcode-neuralcommerce-lite' ); ?></option>
                    </select>
                </div>

                <div class="qcnc-row">
                    <div class="qcnc-form-group" id="qcnc-percentage-field">
                        <label><?php esc_html_e( 'Percent (%)', 'quarkcode-neuralcommerce-lite' ); ?></label>
                        <input type="number" id="qcnc-percentage-fee" name="percentage_fee" step="0.01" min="0" value="2.9">
                    </div>
                    <div class="qcnc-form-group" id="qcnc-fixed-field">
                        <label><?php esc_html_e( 'Fixed Amount', 'quarkcode-neuralcommerce-lite' ); ?></label>
                        <input type="number" id="qcnc-fixed-fee" name="fixed_fee" step="0.01" min="0" value="0.30">
                    </div>
                </div>

                <div class="qcnc-form-group">
                    <label><?php esc_html_e( 'Currency', 'quarkcode-neuralcommerce-lite' ); ?></label>
                    <input type="text" id="qcnc-gateway-currency" name="currency" value="<?php echo esc_attr( get_woocommerce_currency() ); ?>" class="small-text">
                </div>

                <div class="qcnc-form-group">
                    <button type="submit" class="button button-primary button-large"><?php esc_html_e( 'Save Fee', 'quarkcode-neuralcommerce-lite' ); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>