<?php
/**
 * Product Report View
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<table class="widefat fixed striped">
    <thead>
        <tr>
            <th><?php esc_html_e( 'Product', 'quarkcode-neuralcommerce-lite' ); ?></th>
            <th><?php esc_html_e( 'SKU', 'quarkcode-neuralcommerce-lite' ); ?></th>
            <th><?php esc_html_e( 'Orders', 'quarkcode-neuralcommerce-lite' ); ?></th>
            <th><?php esc_html_e( 'Quantity Sold', 'quarkcode-neuralcommerce-lite' ); ?></th>
            <th><?php esc_html_e( 'Revenue', 'quarkcode-neuralcommerce-lite' ); ?></th>
            <th><?php esc_html_e( 'COGS', 'quarkcode-neuralcommerce-lite' ); ?></th>
            <th><?php esc_html_e( 'Profit', 'quarkcode-neuralcommerce-lite' ); ?></th>
            <th><?php esc_html_e( 'Margin %', 'quarkcode-neuralcommerce-lite' ); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php if ( ! empty( $data ) ) : ?>
            <?php 
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                foreach ( $data as $row ) : ?>
                <tr>
                    <td>
                        <a href="<?php echo esc_url( $row['product_link'] ?? '#' ); ?>">
                            <?php echo esc_html( $row['product_name'] ?? __( 'Unknown Product', 'quarkcode-neuralcommerce-lite' ) ); ?>
                        </a>
                    </td>
                    <td><?php echo esc_html( $row['sku'] ?? 'N/A' ); ?></td>
                    <td><?php echo esc_html( number_format_i18n( $row['order_count'] ) ); ?></td>
                    <td><?php echo esc_html( number_format_i18n( $row['total_quantity'] ) ); ?></td>
                    <td><?php echo wp_kses_post( wc_price( $row['total_revenue'] ) ); ?></td>
                    <td><?php echo wp_kses_post( wc_price( $row['total_cogs'] ) ); ?></td>
                    <td>
                        <strong style="color: <?php echo floatval( $row['total_profit'] ) >= 0 ? '#28a745' : '#dc3545'; ?>">
                            <?php echo wp_kses_post( wc_price( $row['total_profit'] ) ); ?>
                        </strong>
                    </td>
                    <td><?php echo esc_html( number_format( $row['avg_margin_pct'], 2 ) ); ?>%</td>
                </tr>
            <?php endforeach; ?>
        <?php else : ?>
            <tr>
                <td colspan="8"><?php esc_html_e( 'No data available for the selected period.', 'quarkcode-neuralcommerce-lite' ); ?></td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>
