<?php
/**
 * Reports View
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$report_type = isset( $_GET['report'] ) ? sanitize_text_field( wp_unslash( $_GET['report'] ) ) : 'product';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$date_from = isset( $_GET['date_from'] ) ? sanitize_text_field( wp_unslash( $_GET['date_from'] ) ) : wp_date( 'Y-m-01' );
// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$date_to = isset( $_GET['date_to'] ) ? sanitize_text_field( wp_unslash( $_GET['date_to'] ) ) : wp_date( 'Y-m-d' );

// Helper to keep date params when switching tabs
function qcnc_get_report_url( $type, $from, $to ) {
    return add_query_arg( array(
        'page'      => 'qcnc-reports',
        'report'    => $type,
        'date_from' => $from,
        'date_to'   => $to
    ), admin_url( 'admin.php' ) );
}
?>

<div class="wrap qcnc-reports">
    
    <!-- Modern Header with Integrated Filters -->
    <div class="qcnc-dashboard-header">
        <div class="qcnc-header-left">
            <h1>
                <span class="dashicons dashicons-analytics"></span>
                <?php esc_html_e( 'Profit Reports', 'quarkcode-neuralcommerce-lite' ); ?>
            </h1>
            <p class="qcnc-subtitle">
                <?php esc_html_e( 'Deep dive into profitability by product, customer, or category.', 'quarkcode-neuralcommerce-lite' ); ?>
            </p>
        </div>

        <div class="qcnc-header-right">
            <form method="get" action="" class="qcnc-report-controls">
                <input type="hidden" name="page" value="qcnc-reports">
                <input type="hidden" name="report" value="<?php echo esc_attr( $report_type ); ?>">

                <div class="qcnc-date-group">
                    <span class="dashicons dashicons-calendar-alt"></span>
                    <input type="date" name="date_from" value="<?php echo esc_attr( $date_from ); ?>" class="qcnc-date-input">
                    <span class="separator">-</span>
                    <input type="date" name="date_to" value="<?php echo esc_attr( $date_to ); ?>" class="qcnc-date-input">
                </div>

                <button type="submit" class="button button-primary">
                    <?php esc_html_e( 'Generate', 'quarkcode-neuralcommerce-lite' ); ?>
                </button>

                <button type="button" class="button" id="qcnc-export-report" title="<?php esc_attr_e( 'Export CSV', 'quarkcode-neuralcommerce-lite' ); ?>">
                    <span class="dashicons dashicons-download"></span>
                </button>
            </form>
        </div>
    </div>

    <!-- Modern Tab Navigation -->
    <div class="qcnc-report-tabs-wrapper">
        <a href="<?php echo esc_url( qcnc_get_report_url( 'product', $date_from, $date_to ) ); ?>" 
           class="qcnc-tab-link <?php echo 'product' === $report_type ? 'active' : ''; ?>">
            <span class="dashicons dashicons-products"></span>
            <?php esc_html_e( 'By Product', 'quarkcode-neuralcommerce-lite' ); ?>
        </a>
        
        <a href="<?php echo esc_url( qcnc_get_report_url( 'category', $date_from, $date_to ) ); ?>" 
           class="qcnc-tab-link <?php echo 'category' === $report_type ? 'active' : ''; ?>">
            <span class="dashicons dashicons-category"></span>
            <?php esc_html_e( 'By Category', 'quarkcode-neuralcommerce-lite' ); ?>
        </a>
        
        <a href="<?php echo esc_url( qcnc_get_report_url( 'customer', $date_from, $date_to ) ); ?>" 
           class="qcnc-tab-link <?php echo 'customer' === $report_type ? 'active' : ''; ?>">
            <span class="dashicons dashicons-admin-users"></span>
            <?php esc_html_e( 'By Customer', 'quarkcode-neuralcommerce-lite' ); ?>
        </a>
        
        <a href="<?php echo esc_url( qcnc_get_report_url( 'date', $date_from, $date_to ) ); ?>" 
           class="qcnc-tab-link <?php echo 'date' === $report_type ? 'active' : ''; ?>">
            <span class="dashicons dashicons-calendar"></span>
            <?php esc_html_e( 'By Date', 'quarkcode-neuralcommerce-lite' ); ?>
        </a>
    </div>

    <!-- Report Content Container -->
    <div id="qcnc-report-content" class="qcnc-report-card">
        <?php
        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
        $report_generator = \QuarkcodeNeuralCommerce\QCNC_Core::instance()->report_generator;

        switch ( $report_type ) {
            case 'product':
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                $data = $report_generator->get_profit_by_product( $date_from, $date_to, 100 );
                include __DIR__ . '/reports/product-report.php';
                break;

            case 'category':
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                $data = $report_generator->get_profit_by_category( $date_from, $date_to );
                include __DIR__ . '/reports/category-report.php';
                break;

            case 'customer':
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                $data = $report_generator->get_profit_by_customer( $date_from, $date_to, 100 );
                include __DIR__ . '/reports/customer-report.php';
                break;

            case 'date':
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                $data = $report_generator->get_profit_by_date( $date_from, $date_to, 'day' );
                include __DIR__ . '/reports/date-report.php';
                break;
        }
        ?>
    </div>
</div>
