<?php
/**
 * Product Costs View
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="wrap qcnc-product-costs">
    
    <!-- Modern Header -->
    <div class="qcnc-dashboard-header">
        <div class="qcnc-header-left">
            <h1>
                <span class="dashicons dashicons-money-alt"></span>
                <?php esc_html_e( 'Product Costs', 'quarkcode-neuralcommerce-lite' ); ?>
            </h1>
            <p class="qcnc-subtitle">
                <?php esc_html_e( 'Manage cost of goods (COGS) to calculate accurate profit margins.', 'quarkcode-neuralcommerce-lite' ); ?>
            </p>
        </div>
        <div class="qcnc-header-right">
            <div class="qcnc-quick-actions">
                <button type="button" class="button button-primary" id="qcnc-add-cost">
                    <span class="dashicons dashicons-plus-alt2"></span> <?php esc_html_e( 'Add New Cost', 'quarkcode-neuralcommerce-lite' ); ?>
                </button>
            </div>
        </div>
    </div>

    <div id="qcnc-costs-table-container">
        <table class="wp-list-table widefat fixed striped" id="qcnc-costs-table">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'Product ID', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Product Name', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'SKU', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Price', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Cost', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Packaging', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Handling', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Total Cost', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Margin %', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Actions', 'quarkcode-neuralcommerce-lite' ); ?></th>
                </tr>
            </thead>
            <tbody id="qcnc-costs-tbody">
                <tr>
                    <td colspan="10" class="qcnc-loading">
                        <?php esc_html_e( 'Loading...', 'quarkcode-neuralcommerce-lite' ); ?>
                    </td>
                </tr>
            </tbody>
        </table>

        <div class="qcnc-pagination" id="qcnc-pagination">
            <!-- Pagination will be inserted here by JavaScript -->
        </div>
    </div>

    <!-- Add/Edit Cost Modal -->
    <div id="qcnc-cost-modal" class="qcnc-modal" style="display: none;">
        <div class="qcnc-modal-content-cost">
            <span class="qcnc-modal-close">&times;</span>
            <h2><?php esc_html_e( 'Edit Product Cost', 'quarkcode-neuralcommerce-lite' ); ?></h2>
            
            <form id="qcnc-cost-form">
                <input type="hidden" id="qcnc-product-id" name="product_id">

                <div id="qcnc-product-info" style="display: none; padding: 10px; background: #f0f0f1; border-left: 4px solid #2271b1; margin-bottom: 15px;">
                    <p style="margi`n: 5px 0;">
                        <strong><?php esc_html_e( 'Product:', 'quarkcode-neuralcommerce-lite' ); ?></strong> 
                        <span id="qcnc-info-name"></span>
                    </p>
                    <p style="margin: 5px 0;">
                        <strong><?php esc_html_e( 'SKU:', 'quarkcode-neuralcommerce-lite' ); ?></strong> 
                        <span id="qcnc-info-sku"></span>
                    </p>
                    <p style="margin: 5px 0;">
                        <strong><?php esc_html_e( 'Regular Price:', 'quarkcode-neuralcommerce-lite' ); ?></strong> 
                        <span id="qcnc-info-regular-price" style="color: #666;"></span>
                    </p>
                    <p id="qcnc-info-sale-price-row" style="margin: 5px 0; display: none;">
                        <strong><?php esc_html_e( 'Sale Price:', 'quarkcode-neuralcommerce-lite' ); ?></strong> 
                        <span id="qcnc-info-sale-price" style="color: #d63638; font-weight: bold;"></span>
                    </p>
                    <p style="margin: 5px 0;">
                        <strong><?php esc_html_e( 'Current Price:', 'quarkcode-neuralcommerce-lite' ); ?></strong> 
                        <span id="qcnc-info-current-price" style="color: #2271b1; font-weight: bold; font-size: 1.1em;"></span>
                    </p>
                </div>
                
                <!-- Main Costs -->
                <h3 style="margin-top: 0; border-bottom: 2px solid #ddd; padding-bottom: 5px;">
                    <?php esc_html_e( 'Main Costs', 'quarkcode-neuralcommerce-lite' ); ?>
                </h3>
                
                <p>
                    <label for="qcnc-cost"><?php esc_html_e( 'Product Cost (COGS):', 'quarkcode-neuralcommerce-lite' ); ?> *</label>
                    <input type="number" id="qcnc-cost" name="cost" step="0.01" min="0" required>
                    <span class="description"><?php esc_html_e( 'Base cost of the product', 'quarkcode-neuralcommerce-lite' ); ?></span>
                </p>

                <!-- Additional Costs Fields -->
                <h3 style="margin-top: 20px; border-bottom: 2px solid #ddd; padding-bottom: 5px;">
                    <?php esc_html_e( 'Additional Costs', 'quarkcode-neuralcommerce-lite' ); ?>
                </h3>
                
                <div class="qcnc-cost-grid" style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <p>
                        <label for="qcnc-packaging-cost"><?php esc_html_e( 'Packaging Cost:', 'quarkcode-neuralcommerce-lite' ); ?></label>
                        <input type="number" id="qcnc-packaging-cost" name="packaging_cost" step="0.01" min="0" value="0" class="regular-text">
                        <span class="description"><?php esc_html_e( 'Box, labels, bubble wrap', 'quarkcode-neuralcommerce-lite' ); ?></span>
                    </p>

                    <p>
                        <label for="qcnc-handling-cost"><?php esc_html_e( 'Handling Cost:', 'quarkcode-neuralcommerce-lite' ); ?></label>
                        <input type="number" id="qcnc-handling-cost" name="handling_cost" step="0.01" min="0" value="0" class="regular-text">
                        <span class="description"><?php esc_html_e( 'Processing, picking, packing', 'quarkcode-neuralcommerce-lite' ); ?></span>
                    </p>

                </div>

                <!-- Notes -->
                <p>
                    <label for="qcnc-notes"><?php esc_html_e( 'Notes:', 'quarkcode-neuralcommerce-lite' ); ?></label>
                    <textarea id="qcnc-notes" name="notes" rows="3" style="width: 100%;" placeholder="<?php esc_attr_e( 'Add any notes about these costs...', 'quarkcode-neuralcommerce-lite' ); ?>"></textarea>
                </p>

                <!-- Total Cost Display -->
                <div style="background: #f0f0f1; padding: 15px; margin: 20px 0; border-left: 4px solid #2271b1;">
                    <h4 style="margin-top: 0;"><?php esc_html_e( 'Total Cost Breakdown', 'quarkcode-neuralcommerce-lite' ); ?></h4>
                    <table style="width: 100%;">
                        <tr>
                            <td><?php esc_html_e( 'Product Cost:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                            <td id="qcnc-display-cost" style="text-align: right;">$0.00</td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Additional Costs:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                            <td id="qcnc-display-additional" style="text-align: right;">$0.00</td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Custom Costs:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                            <td id="qcnc-display-custom" style="text-align: right;">$0.00</td>
                        </tr>
                        <tr style="border-top: 2px solid #000; font-weight: bold; font-size: 1.1em;">
                            <td><?php esc_html_e( 'Total Unit Cost:', 'quarkcode-neuralcommerce-lite' ); ?></td>
                            <td id="qcnc-display-total" style="text-align: right; color: #2271b1;">$0.00</td>
                        </tr>
                    </table>
                </div>

                <p>
                    <button type="submit" class="button button-primary">
                        <?php esc_html_e( 'Save Cost', 'quarkcode-neuralcommerce-lite' ); ?>
                    </button>
                    <button type="button" class="button qcnc-modal-close">
                        <?php esc_html_e( 'Cancel', 'quarkcode-neuralcommerce-lite' ); ?>
                    </button>
                </p>
            </form>
        </div>
    </div>

    <!-- CSV Import Modal -->
    <div id="qcnc-import-modal" class="qcnc-modal" style="display: none;">
        <div class="qcnc-modal-content-cost">
            <span class="qcnc-modal-close">&times;</span>
            <h2><?php esc_html_e( 'Import Product Costs from CSV', 'quarkcode-neuralcommerce-lite' ); ?></h2>
            
            <form id="qcnc-import-form" enctype="multipart/form-data">
                <p>
                    <label for="qcnc-csv-file"><?php esc_html_e( 'Select CSV File:', 'quarkcode-neuralcommerce-lite' ); ?></label>
                    <input type="file" id="qcnc-csv-file" name="csv_file" accept=".csv" required>
                </p>

                <p class="description">
                    <?php esc_html_e( 'CSV should have columns: product_id, variation_id (optional), cost, packaging_cost, handling_cost, currency', 'quarkcode-neuralcommerce-lite' ); ?>
                </p>

                <p>
                    <button type="submit" class="button button-primary">
                        <?php esc_html_e( 'Import', 'quarkcode-neuralcommerce-lite' ); ?>
                    </button>
                    <button type="button" class="button qcnc-modal-close">
                        <?php esc_html_e( 'Cancel', 'quarkcode-neuralcommerce-lite' ); ?>
                    </button>
                </p>
            </form>

            <div id="qcnc-import-progress" style="display: none;">
                <p><?php esc_html_e( 'Importing...', 'quarkcode-neuralcommerce-lite' ); ?></p>
                <progress max="100" value="0"></progress>
            </div>
        </div>
    </div>

    <div id="qcnc-history-modal" class="qcnc-modal" style="display: none;">
        <div class="qcnc-modal-content-cost qcnc-modal-large">
            <span class="qcnc-modal-close">&times;</span>
            <h2><?php esc_html_e( 'Cost History', 'quarkcode-neuralcommerce-lite' ); ?></h2>
            <div id="qcnc-history-content">
                <!-- History will be loaded here -->
            </div>
        </div>
    </div>

    <?php
    global $wpdb;

    // Get products in orders without costs
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    $products_without_costs = $wpdb->get_results(
        "SELECT DISTINCT
            oip.product_id,
            p.post_title as product_name,
            COUNT(DISTINCT oip.order_id) as order_count,
            SUM(oip.item_revenue) as total_revenue,
            SUM(oip.item_profit) as total_profit
        FROM {$wpdb->prefix}qcnc_order_items_profit oip
        LEFT JOIN {$wpdb->posts} p ON oip.product_id = p.ID
        LEFT JOIN {$wpdb->prefix}qcnc_product_costs pc ON oip.product_id = pc.product_id AND pc.is_current = 1
        WHERE pc.id IS NULL
        AND oip.item_cogs = 0
        GROUP BY oip.product_id, p.post_title
        ORDER BY order_count DESC
        LIMIT 10",
        ARRAY_A
    );

    if ( ! empty( $products_without_costs ) ) :
    ?>
        <div class="qcnc-warning-box" style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0;">
            <h2 style="margin-top: 0; color: #856404;">
                ⚠️ <?php esc_html_e( 'Products Missing Cost Data', 'quarkcode-neuralcommerce-lite' ); ?>
            </h2>
            <p>
                <?php esc_html_e( 'The following products have orders but no costs set. Set costs to get accurate profit calculations.', 'quarkcode-neuralcommerce-lite' ); ?>
            </p>
            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Product', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Orders', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Revenue', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                    foreach ( $products_without_costs as $product ) : ?>
                        <tr>
                            <td>
                                <a href="<?php echo esc_url( admin_url( 'post.php?post=' . $product['product_id'] . '&action=edit' ) ); ?>" target="_blank">
                                    <?php echo esc_html( $product['product_name'] ?: __( 'Unknown Product', 'quarkcode-neuralcommerce-lite' ) ); ?>
                                </a>
                            </td>
                            <td><?php echo esc_html( number_format_i18n( $product['order_count'] ) ); ?></td>
                            <td><?php echo wp_kses_post( wc_price( $product['total_revenue'] ) ); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>
