<?php
/**
 * Order Profitability View
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>

<div class="wrap qcnc-order-profitability">
    
    <!-- Modern Page Header -->
    <div class="qcnc-dashboard-header">
        <div class="qcnc-header-left">
            <h1>
                <span class="dashicons dashicons-performance"></span>
                <?php esc_html_e( 'Order Profitability', 'quarkcode-neuralcommerce-lite' ); ?>
            </h1>
            <p class="qcnc-subtitle">
                <?php esc_html_e( 'Detailed breakdown of revenue, costs, and net profit for every order.', 'quarkcode-neuralcommerce-lite' ); ?>
            </p>
        </div>
        <div class="qcnc-header-right">
            <button type="button" class="button" onclick="location.reload()">
                <span class="dashicons dashicons-update"></span>
                <?php esc_html_e( 'Refresh Data', 'quarkcode-neuralcommerce-lite' ); ?>
            </button>
            <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-product-costs' ) ); ?>" class="button button-primary">
                <span class="dashicons dashicons-money-alt"></span>
                <?php esc_html_e( 'Manage Product Costs', 'quarkcode-neuralcommerce-lite' ); ?>
            </a>
        </div>
    </div>

    <!-- Improved Bulk Process Panel -->
    <div class="qcnc-bulk-process-panel">
        <div class="panel-icon-area">
            <span class="dashicons dashicons-database-import"></span>
        </div>
        <div class="panel-content-area">
            <h3><?php esc_html_e( 'Data Synchronization', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <p><?php esc_html_e( 'Process orders to calculate profit data. Required when new orders arrive or costs change.', 'quarkcode-neuralcommerce-lite' ); ?></p>
            
            <div class="qcnc-bulk-actions">
                <button type="button" class="button button-primary" id="qcnc-bulk-process-all">
                    <?php esc_html_e( 'Process All Orders', 'quarkcode-neuralcommerce-lite' ); ?>
                </button>
                <button type="button" class="button" id="qcnc-bulk-process-missing">
                    <?php esc_html_e( 'Process Missing Only', 'quarkcode-neuralcommerce-lite' ); ?>
                </button>
                <button type="button" class="button button-link-delete" id="qcnc-reset-all-data">
                    <?php esc_html_e( 'Reset Data', 'quarkcode-neuralcommerce-lite' ); ?>
                </button>
                <span id="qcnc-order-count" class="order-count-badge"></span>
            </div>

            <!-- Progress Bar Area -->
            <div id="qcnc-bulk-progress" class="qcnc-progress-wrapper" style="display: none;">
                <div class="progress-header">
                    <span class="processing-label"><?php esc_html_e( 'Processing...', 'quarkcode-neuralcommerce-lite' ); ?></span>
                    <span id="qcnc-progress-text">0 / 0</span>
                </div>
                <div class="qcnc-progress-track">
                    <div id="qcnc-progress-bar" class="qcnc-progress-fill" style="width: 0%;"></div>
                </div>
                <p id="qcnc-progress-status"></p>
            </div>

            <div id="qcnc-bulk-results" class="qcnc-results-box" style="display: none;">
                <span class="dashicons dashicons-yes-alt"></span>
                <span id="qcnc-results-summary"></span>
            </div>
        </div>
    </div>
    
    <div class="qcnc-toolbar">
        <div class="qcnc-filter-group">
            <label for="qcnc-order-date-from"><?php esc_html_e( 'From:', 'quarkcode-neuralcommerce-lite' ); ?></label>
            <input type="date" id="qcnc-order-date-from">

            <label for="qcnc-order-date-to"><?php esc_html_e( 'To:', 'quarkcode-neuralcommerce-lite' ); ?></label>
            <input type="date" id="qcnc-order-date-to">

            <button type="button" class="button" id="qcnc-filter-orders">
                <?php esc_html_e( 'Filter', 'quarkcode-neuralcommerce-lite' ); ?>
            </button>
        </div>
    </div>

    <div id="qcnc-orders-table-container">
        <table class="wp-list-table widefat fixed striped" id="qcnc-orders-table">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'Order', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Date', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Customer', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Status', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Revenue', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'COGS', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Fees', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Net Profit', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Margin %', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    <th><?php esc_html_e( 'Actions', 'quarkcode-neuralcommerce-lite' ); ?></th>
                </tr>
            </thead>
            <tbody id="qcnc-orders-tbody">
                <tr>
                    <td colspan="10" class="qcnc-loading">
                        <?php esc_html_e( 'Loading...', 'quarkcode-neuralcommerce-lite' ); ?>
                    </td>
                </tr>
            </tbody>
        </table>

        <div class="qcnc-pagination" id="qcnc-orders-pagination">
            <!-- Pagination will be inserted here by JavaScript -->
        </div>
    </div>

    <!-- Order Details Modal -->
    <div id="qcnc-order-details-modal" class="qcnc-modal" style="display: none;">
        <div class="qcnc-modal-content qcnc-modal-large">
            <span class="qcnc-modal-close">&times;</span>
            <h2><?php esc_html_e( 'Order Profit Breakdown', 'quarkcode-neuralcommerce-lite' ); ?></h2>
            <div id="qcnc-order-details-content">
                <!-- Content will be loaded via AJAX -->
            </div>
        </div>
    </div>
</div>