<?php
/**
 * Dashboard View
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

global $wpdb;


// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$date_from = isset( $_GET['date_from'] ) ? sanitize_text_field( wp_unslash( $_GET['date_from'] ) ) : wp_date( 'Y-m-d', strtotime( '-30 days' ) );
// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$date_to = isset( $_GET['date_to'] ) ? sanitize_text_field( wp_unslash( $_GET['date_to'] ) ) : wp_date( 'Y-m-d' );

?>

<div class="wrap qcnc-dashboard">
    <!-- Modern Page Header -->
    <div class="qcnc-dashboard-header">
        <div class="qcnc-header-left">
            <h1>
                <span class="dashicons dashicons-chart-area"></span>
                <?php esc_html_e( 'Neural Commerce Dashboard', 'quarkcode-neuralcommerce-lite' ); ?>
            </h1>
            <p class="qcnc-subtitle">
                <?php esc_html_e( 'Comprehensive breakdown of your store\'s profitability and performance metrics.', 'quarkcode-neuralcommerce-lite' ); ?>
            </p>
        </div>
        <div class="qcnc-header-right">
            <button type="button" class="button button-secondary" id="qcnc-clear-dashboard-cache">
                <span class="dashicons dashicons-update"></span>
                <?php esc_html_e( 'Clear Cache', 'quarkcode-neuralcommerce-lite' ); ?>
            </button>
            <a href="?page=qcnc-order-profitability" class="button button-primary">
                <span class="dashicons dashicons-database-import"></span>
                <?php esc_html_e( 'Process Orders', 'quarkcode-neuralcommerce-lite' ); ?>
            </a>
        </div>
    </div>

    <div style="background: #fff; border-left: 4px solid #2271b1; padding: 10px 15px; margin: 15px 0;">
        <p style="margin: 5px 0;">
            <?php
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
            $processed_orders = $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}qcnc_order_profit" );
            if ( $processed_orders == 0 ) {
                echo '<span style="color: #d63638;">⚠️ ' . esc_html__( 'No profit data found. Please process your orders first from the "Order Profitability" page.', 'quarkcode-neuralcommerce-lite' ) . '</span>';
            } else {
                echo '✅ ' . sprintf( 
                    /* translators: %d: Number of orders */
                    esc_html__( '%d orders have been processed for profit calculation.', 'quarkcode-neuralcommerce-lite' ), esc_attr($processed_orders) );
            }
            ?>
        </p>
        <!--
        <p style="margin: 5px 0;">
            <a href="?page=qcnc-order-profitability" class="button">
                <?php esc_html_e( 'Go to Bulk Process Orders', 'quarkcode-neuralcommerce-lite' ); ?>
            </a>
            <button type="button" class="button" id="qcnc-clear-dashboard-cache">
                <?php esc_html_e( 'Clear Cache & Refresh', 'quarkcode-neuralcommerce-lite' ); ?>
            </button>
        </p>
        -->
    </div>

    <div class="qcnc-date-filter">
        <form method="get" action="">
            <input type="hidden" name="page" value="qcnc-dashboard">
            <label for="date_from"><?php esc_html_e( 'From:', 'quarkcode-neuralcommerce-lite' ); ?></label>
            <input type="date" id="date_from" name="date_from" value="<?php echo esc_attr( $date_from ); ?>">
            
            <label for="date_to"><?php esc_html_e( 'To:', 'quarkcode-neuralcommerce-lite' ); ?></label>
            <input type="date" id="date_to" name="date_to" value="<?php echo esc_attr( $date_to ); ?>">
            
            <button type="submit" class="button button-primary">
                <?php esc_html_e( 'Apply Filter', 'quarkcode-neuralcommerce-lite' ); ?>
            </button>
        </form>
    </div>


    <div class="qcnc-stats-grid">
        <div class="qcnc-stat-box">
            <h3><?php esc_html_e( 'Total Orders', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <div class="qcnc-stat-value">
                <?php echo esc_html( number_format_i18n( $summary['total_orders'] ?? 0 ) ); ?>
            </div>
        </div>

        <div class="qcnc-stat-box">
            <h3><?php esc_html_e( 'Total Revenue', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <div class="qcnc-stat-value">
                <?php echo wp_kses_post( wc_price( $summary['total_revenue'] ?? 0 ) ); ?>
            </div>
        </div>

        <div class="qcnc-stat-box">
            <h3><?php esc_html_e( 'Total COGS', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <div class="qcnc-stat-value">
                <?php echo wp_kses_post( wc_price( $summary['total_cogs'] ?? 0 ) ); ?>
            </div>
        </div>

        <div class="qcnc-stat-box qcnc-highlight">
            <h3><?php esc_html_e( 'Net Profit', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <div class="qcnc-stat-value">
                <?php 
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                $net_profit = floatval( $summary['total_net_profit'] ?? 0 );
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                $color = $net_profit >= 0 ? '#28a745' : '#dc3545';
                ?>
                <span style="color: <?php echo esc_attr( $color ); ?>">
                    <?php echo wp_kses_post( wc_price( $net_profit ) ); ?>
                </span>
            </div>
        </div>

        <div class="qcnc-stat-box">
            <h3><?php esc_html_e( 'Average Margin', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <div class="qcnc-stat-value">
                <?php echo esc_html( number_format( $summary['avg_margin'] ?? 0, 2 ) ); ?>%
            </div>
        </div>

        <div class="qcnc-stat-box qcnc-warning">
            <h3><?php esc_html_e( 'Loss Orders', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <div class="qcnc-stat-value">
                <?php echo esc_html( number_format_i18n( $summary['loss_orders_count'] ?? 0 ) ); ?>
            </div>
        </div>

        <div class="qcnc-stat-box qcnc-warning">
            <h3><?php esc_html_e( 'Low Margin Orders', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <div class="qcnc-stat-value">
                <?php echo esc_html( number_format_i18n( $summary['low_margin_orders_count'] ?? 0 ) ); ?>
            </div>
        </div>

        <div class="qcnc-stat-box">
            <h3><?php esc_html_e( 'Payment Fees', 'quarkcode-neuralcommerce-lite' ); ?></h3>
            <div class="qcnc-stat-value">
                <?php echo wp_kses_post( wc_price( $summary['total_payment_fees'] ?? 0 ) ); ?>
            </div>
        </div>
    </div>

    <div class="qcnc-charts-row">
        <div class="qcnc-chart-box">
            <h2><?php esc_html_e( 'Top 10 Products by Profit', 'quarkcode-neuralcommerce-lite' ); ?></h2>
            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Product', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Orders', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Revenue', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Profit', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Margin %', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ( ! empty( $summary['top_products'] ) ) : ?>
                        <?php 
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            foreach ( $summary['top_products'] as $product ) : ?>
                            <tr>
                                <td>
                                    <a href="<?php echo esc_url( $product['product_link'] ?? '#' ); ?>">
                                        <?php echo esc_html( $product['product_name'] ?? __( 'Unknown Product', 'quarkcode-neuralcommerce-lite' ) ); ?>
                                    </a>
                                </td>
                                <td><?php echo esc_html( number_format_i18n( $product['order_count'] ) ); ?></td>
                                <td><?php echo wp_kses_post( wc_price( $product['total_revenue'] ) ); ?></td>
                                <td>
                                    <strong style="color: #28a745;">
                                        <?php echo wp_kses_post( wc_price( $product['total_profit'] ) ); ?>
                                    </strong>
                                </td>
                                <td><?php echo esc_html( number_format( $product['avg_margin_pct'], 2 ) ); ?>%</td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="5"><?php esc_html_e( 'No data available', 'quarkcode-neuralcommerce-lite' ); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="qcnc-chart-box">
            <h2><?php esc_html_e( 'Worst 10 Products by Profit', 'quarkcode-neuralcommerce-lite' ); ?></h2>
            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Product', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Revenue', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Profit', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ( ! empty( $summary['worst_products'] ) ) : ?>
                        <?php 
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            foreach ( $summary['worst_products'] as $product ) : ?>
                            <tr>
                                <td><?php echo esc_html( $product['product_name'] ?? __( 'Unknown Product', 'quarkcode-neuralcommerce-lite' ) ); ?></td>
                                <td><?php echo wp_kses_post( wc_price( $product['total_revenue'] ) ); ?></td>
                                <td>
                                    <strong style="color: #dc3545;">
                                        <?php echo wp_kses_post( wc_price( $product['total_profit'] ) ); ?>
                                    </strong>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="3"><?php esc_html_e( 'No data available', 'quarkcode-neuralcommerce-lite' ); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    
    <?php
    global $wpdb;

    // Get products in orders without costs
    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    $products_without_costs = $wpdb->get_results(
        "SELECT DISTINCT
            oip.product_id,
            p.post_title as product_name,
            COUNT(DISTINCT oip.order_id) as order_count,
            SUM(oip.item_revenue) as total_revenue,
            SUM(oip.item_profit) as total_profit
        FROM {$wpdb->prefix}qcnc_order_items_profit oip
        LEFT JOIN {$wpdb->posts} p ON oip.product_id = p.ID
        LEFT JOIN {$wpdb->prefix}qcnc_product_costs pc ON oip.product_id = pc.product_id AND pc.is_current = 1
        WHERE pc.id IS NULL
        AND oip.item_cogs = 0
        GROUP BY oip.product_id, p.post_title
        ORDER BY order_count DESC
        LIMIT 10",
        ARRAY_A
    );

    if ( ! empty( $products_without_costs ) ) :
    ?>
        <div class="qcnc-warning-box" style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0;">
            <h2 style="margin-top: 0; color: #856404;">
                ⚠️ <?php esc_html_e( 'Products Missing Cost Data', 'quarkcode-neuralcommerce-lite' ); ?>
            </h2>
            <p>
                <?php esc_html_e( 'The following products have orders but no costs set. Set costs to get accurate profit calculations.', 'quarkcode-neuralcommerce-lite' ); ?>
            </p>
            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Product', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Orders', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Revenue', 'quarkcode-neuralcommerce-lite' ); ?></th>
                        <th><?php esc_html_e( 'Action', 'quarkcode-neuralcommerce-lite' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                    foreach ( $products_without_costs as $product ) : ?>
                        <tr>
                            <td>
                                <a href="<?php echo esc_url( admin_url( 'post.php?post=' . $product['product_id'] . '&action=edit' ) ); ?>" target="_blank">
                                    <?php echo esc_html( $product['product_name'] ?: __( 'Unknown Product', 'quarkcode-neuralcommerce-lite' ) ); ?>
                                </a>
                            </td>
                            <td><?php echo esc_html( number_format_i18n( $product['order_count'] ) ); ?></td>
                            <td><?php echo wp_kses_post( wc_price( $product['total_revenue'] ) ); ?></td>
                            <td>
                                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-product-costs' ) ); ?>" class="button button-small button-primary">
                                    <?php esc_html_e( 'Set Cost', 'quarkcode-neuralcommerce-lite' ); ?>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <p style="margin-bottom: 0;">
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=qcnc-product-costs' ) ); ?>" class="button button-primary">
                    <?php esc_html_e( 'Go to Product Costs Page', 'quarkcode-neuralcommerce-lite' ); ?>
                </a>
            </p>
        </div>
    <?php endif; ?>

</div>