/**
 * Alert Test Handler JavaScript
 * 
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.0
 */

jQuery(document).ready(function($) {

    // Handle test button clicks
    $('.qcnc-test-alert-btn').on('click', function(e) {
        e.preventDefault();

        var $button = $(this);
        var alertType = $button.data('alert-type');
        var $icon = $button.find('.dashicons');
        var originalText = $button.find('.button-text').text();

        // Disable button and show loading state
        $button.prop('disabled', true);
        $icon.removeClass('dashicons-email').addClass('dashicons-update spin');
        $button.find('.button-text').text('Sending...');

        // Send AJAX request
        $.ajax({
            url: qcncAlertTest.ajaxUrl,
            type: 'POST',
            data: {
                action: 'qcnc_test_alert',
                nonce: qcncAlertTest.nonce,
                alert_type: alertType
            },
            success: function(response) {
                if (response.success) {
                    // Show success state
                    $icon.removeClass('dashicons-update spin').addClass('dashicons-yes-alt');
                    $button.find('.button-text').text('Sent!');
                    $button.addClass('button-success');

                    // Show success notice
                    showNotice('success', response.data.message);

                    // Reset button after 3 seconds
                    setTimeout(function() {
                        $button.prop('disabled', false);
                        $icon.removeClass('dashicons-yes-alt').addClass('dashicons-email');
                        $button.find('.button-text').text(originalText);
                        $button.removeClass('button-success');
                    }, 3000);

                } else {
                    // Show error state
                    $icon.removeClass('dashicons-update spin').addClass('dashicons-warning');
                    $button.find('.button-text').text('Failed');

                    // Show error notice
                    showNotice('error', response.data.message || 'Failed to send test email.');

                    // Reset button after 3 seconds
                    setTimeout(function() {
                        $button.prop('disabled', false);
                        $icon.removeClass('dashicons-warning').addClass('dashicons-email');
                        $button.find('.button-text').text(originalText);
                    }, 3000);
                }
            },
            error: function(xhr, status, error) {
                // Show error state
                $icon.removeClass('dashicons-update spin').addClass('dashicons-warning');
                $button.find('.button-text').text('Error');

                // Show error notice
                showNotice('error', 'AJAX error: ' + error);

                // Reset button after 3 seconds
                setTimeout(function() {
                    $button.prop('disabled', false);
                    $icon.removeClass('dashicons-warning').addClass('dashicons-email');
                    $button.find('.button-text').text(originalText);
                }, 3000);
            }
        });
    });

    /**
     * Show notice message
     */
    function showNotice(type, message) {
        var $notice = $('<div>')
            .addClass('notice notice-' + type + ' is-dismissible qcnc-test-notice')
            .html('<p>' + message + '</p>');

        $('.qcnc-settings .qcnc-dashboard-header').after($notice);

        // Auto-dismiss after 5 seconds
        setTimeout(function() {
            $notice.fadeOut(function() {
                $(this).remove();
            });
        }, 5000);

        // Allow manual dismiss
        $notice.on('click', '.notice-dismiss', function() {
            $notice.remove();
        });
    }

    // Add CSS for spin animation
    if (!$('#qcnc-alert-test-css').length) {
        $('<style id="qcnc-alert-test-css">')
            .text(`
                .dashicons.spin {
                    animation: spin 1s linear infinite;
                }
                @keyframes spin {
                    from { transform: rotate(0deg); }
                    to { transform: rotate(360deg); }
                }
                .button-success {
                    border-color: #46b450 !important;
                    background: #46b450 !important;
                    color: #fff !important;
                }
                .qcnc-test-notice {
                    margin: 20px 0 !important;
                }
            `)
            .appendTo('head');
    }
});
