/**
 * Quarkcode NeuralCommerce - Upgrade Page Lightbox Script
 *
 * @package QuarkcodeNeuralCommerce
 * @since 1.0.5
 */

(function() {
    'use strict';

    /**
     * Open lightbox with screenshot
     * 
     * @param {number} index - Screenshot index
     */
    window.qcncOpenLightbox = function(index) {
        if (typeof qcncScreenshots === 'undefined' || !qcncScreenshots[index]) {
            return;
        }

        var lightbox = document.getElementById('qcnc-lightbox');
        var img = document.getElementById('qcnc-lightbox-img');
        var caption = document.getElementById('qcnc-lightbox-caption');
        
        if (!lightbox || !img || !caption) {
            return;
        }
        
        img.src = qcncScreenshots[index].url;
        img.alt = qcncScreenshots[index].caption;
        caption.textContent = qcncScreenshots[index].caption;
        
        lightbox.classList.add('active');
        document.body.style.overflow = 'hidden';
    };

    /**
     * Close lightbox
     */
    window.qcncCloseLightbox = function() {
        var lightbox = document.getElementById('qcnc-lightbox');
        if (lightbox) {
            lightbox.classList.remove('active');
            document.body.style.overflow = 'auto';
        }
    };

    // Close lightbox on ESC key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            window.qcncCloseLightbox();
        }
    });

})();
