<?php
/**
 * QMSpace Business Facts - Uninstall
 * 
 * This file runs when the plugin is deleted from WordPress.
 * It checks the user's preference and either keeps or deletes all plugin data.
 *
 * @package QMSpace_Business_Facts
 */

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Uninstall script variables in isolated scope

// Exit if not called by WordPress
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Get settings to check if user wants data deleted
$settings = get_option('qmsbf_settings', array());

// Only delete data if user opted in
if (!empty($settings['delete_data_on_uninstall'])) {
    
    // Get page ID BEFORE deleting options
    $page_id = get_option('qmsbf_page_id');
    
    // Delete the profile page if it exists
    if ($page_id) {
        wp_delete_post($page_id, true);
    }
    
    // Delete all plugin options
    delete_option('qmsbf_settings');
    delete_option('qmsbf_business');
    delete_option('qmsbf_address');
    delete_option('qmsbf_hours');
    delete_option('qmsbf_social');
    delete_option('qmsbf_display_fields');
    delete_option('qmsbf_page_id');
    delete_option('qmsbf_leads');
    delete_option('qmsbf_wizard_completed');
    delete_option('qmsbf_last_updated');
    delete_option('qmsbf_analytics');
    delete_option('qmsbf_license_key');
    delete_option('qmsbf_license_status');
    delete_option('qmsbf_license_expires');
    delete_option('qmsbf_activation_id');
    delete_option('qmsbf_license_fingerprint');
    
    // Delete any transients
    delete_transient('qmsbf_license_status_cache');
    delete_transient('qmsbf_page_exists_notice');
    
    // Clear any scheduled hooks
    wp_clear_scheduled_hook('qmsbf_deferred_activation');
    
    // Flush rewrite rules
    flush_rewrite_rules();
}
