<?php
/**
 * Business Profile Display Template (Lite)
 * 
 * @package QMSpace_Business_Facts
 */

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables in isolated scope

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get all data
$settings = get_option('qmsbf_settings', array());
$business = get_option('qmsbf_business', array());
$address = get_option('qmsbf_address', array());
$hours = get_option('qmsbf_hours', array());
$display = get_option('qmsbf_display_fields', array());

// Helper function to convert 24-hour to 12-hour format
if (!function_exists('qmsbf_format_time_12hour')) {
    function qmsbf_format_time_12hour($time) {
        if (empty($time)) {
            return $time;
        }
        $timestamp = strtotime($time);
        if ($timestamp === false) {
            return $time;
        }
        return wp_date( 'g:i A', $timestamp );
    }
}

// Set defaults for display fields
$defaults = array(
    'name' => true,
    'description' => true,
    'website' => true,
    'email' => true,
    'phone' => true,
    'address' => true,
    'hours' => true,
    'map' => true
);

$display = wp_parse_args($display, $defaults);
$show_footer = $settings['show_footer'] ?? false; // Credits default to hidden per WordPress.org Guideline 10
?>


<div class="qmsbf-profile">
    <?php if ($display['name'] || $display['description']): ?>
    <div class="qmsbf-profile-header">
        <?php if ($display['name'] && !empty($business['name'])): ?>
        <h1 class="qmsbf-profile-name"><?php echo esc_html($business['name']); ?></h1>
        <?php endif; ?>
        
        <?php if ($display['description'] && !empty($business['description'])): ?>
        <p class="qmsbf-profile-description"><?php echo esc_html($business['description']); ?></p>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    
    <div class="qmsbf-profile-content">
        <?php if ($display['email'] || $display['phone'] || $display['website']): ?>
        <?php 
        $has_contact = (!empty($business['email']) && $display['email']) || 
                      (!empty($business['phone']) && $display['phone']) || 
                      (!empty($business['website']) && $display['website']);
        if ($has_contact): ?>
        <div class="qmsbf-profile-section">
            <h2>Contact Information</h2>
            <div class="qmsbf-profile-info">
                <?php if ($display['website'] && !empty($business['website'])): ?>
                <div class="qmsbf-profile-info-item">
                    <svg class="qmsbf-profile-info-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"></path>
                    </svg>
                    <div class="qmsbf-profile-info-content">
                        <a href="<?php echo esc_url($business['website']); ?>" target="_blank"><?php echo esc_html(str_replace(['http://', 'https://'], '', $business['website'])); ?></a>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($display['email'] && !empty($business['email'])): ?>
                <div class="qmsbf-profile-info-item">
                    <svg class="qmsbf-profile-info-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    <div class="qmsbf-profile-info-content">
                        <a href="mailto:<?php echo esc_attr($business['email']); ?>"><?php echo esc_html($business['email']); ?></a>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($display['phone'] && !empty($business['phone'])): ?>
                <div class="qmsbf-profile-info-item">
                    <svg class="qmsbf-profile-info-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                    </svg>
                    <div class="qmsbf-profile-info-content">
                        <a href="tel:<?php echo esc_attr(preg_replace('/[^0-9+]/', '', $business['phone'])); ?>"><?php echo esc_html($business['phone']); ?></a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        
        <?php if ($display['address']): ?>
        <?php 
        $has_address = !empty($address['street']) || !empty($address['city']) || !empty($address['state']) || !empty($address['postal']);
        if ($has_address): ?>
        <div class="qmsbf-profile-section">
            <h2>Address</h2>
            <div class="qmsbf-profile-info">
                <div class="qmsbf-profile-info-item">
                    <svg class="qmsbf-profile-info-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    <div class="qmsbf-profile-info-content">
                        <?php if (!empty($address['street'])): ?><?php echo esc_html($address['street']); ?><br><?php endif; ?>
                        <?php if (!empty($address['city'])): ?><?php echo esc_html($address['city']); ?><?php endif; ?>
                        <?php if (!empty($address['state'])): ?>, <?php echo esc_html($address['state']); ?><?php endif; ?>
                        <?php if (!empty($address['postal'])): ?> <?php echo esc_html($address['postal']); ?><?php endif; ?>
                        <?php if (!empty($address['country'])): ?><br><?php echo esc_html($address['country']); ?><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        
        <?php if ($display['hours']): ?>
        <?php 
        // Check if open 24/7
        $is_24_7 = !empty($hours['is_24_7']);
        
        // Check if we have any hours data at all
        $has_hours = $is_24_7;
        if (!$has_hours) {
            $days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
            foreach ($days as $day) {
                if (isset($hours[$day])) {
                    $has_hours = true;
                    break;
                }
            }
        }
        if ($has_hours): ?>
        <div class="qmsbf-profile-section">
            <h2>Business Hours</h2>
            <div class="qmsbf-profile-hours">
                <?php if ($is_24_7): ?>
                <div class="qmsbf-profile-hours-row" style="justify-content: center;">
                    <span class="qmsbf-profile-hours-time" style="font-size: 18px; font-weight: 600; color: #166534; background: #dcfce7; padding: 12px 24px; border-radius: 8px;">
                        🕐 Open 24 Hours, 7 Days a Week
                    </span>
                </div>
                <?php else: ?>
                <?php 
                $day_names = ['monday' => 'Monday', 'tuesday' => 'Tuesday', 'wednesday' => 'Wednesday', 
                              'thursday' => 'Thursday', 'friday' => 'Friday', 'saturday' => 'Saturday', 'sunday' => 'Sunday'];
                foreach ($day_names as $key => $name): 
                    if (isset($hours[$key])):
                ?>
                <div class="qmsbf-profile-hours-row">
                    <span class="qmsbf-profile-hours-day"><?php echo esc_html($name); ?></span>
                    <?php if (!empty($hours[$key]['closed'])): ?>
                        <span class="qmsbf-profile-hours-closed">Closed</span>
                    <?php else: ?>
                        <span class="qmsbf-profile-hours-time">
                            <?php 
                            $open_time = qmsbf_format_time_12hour($hours[$key]['open'] ?? '09:00');
                            $close_time = qmsbf_format_time_12hour($hours[$key]['close'] ?? '17:00');
                            echo esc_html($open_time) . ' - ' . esc_html($close_time); 
                            ?>
                        </span>
                    <?php endif; ?>
                </div>
                <?php 
                    endif;
                endforeach; 
                ?>
                <?php endif; ?>
                
                <?php if (!empty($hours['special'])): ?>
                <div style="margin-top: 16px; padding: 12px 16px; background: #fef3c7; border-radius: 8px; font-size: 14px; color: #92400e;">
                    <strong>Note:</strong> <?php echo esc_html($hours['special']); ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        
        <?php if ($display['map'] && !empty($address['map_url'])): ?>
        <div class="qmsbf-profile-map">
            <iframe src="<?php echo esc_url($address['map_url']); ?>" allowfullscreen="" loading="lazy"></iframe>
        </div>
        <?php endif; ?>
    </div>
    
    <div class="qmsbf-profile-footer">
        <div class="qmsbf-profile-endpoints">
            <p style="margin-bottom: 12px; font-weight: 500; color: #374151;">AI Discovery Endpoints</p>
            <div style="display: flex; flex-wrap: wrap; gap: 8px; justify-content: center; margin-bottom: 20px;">
                <a href="<?php echo esc_url(home_url('/.well-known/ai-business.json')); ?>" target="_blank" class="qmsbf-endpoint-link">
                    <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="margin-right: 4px;"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4"></path></svg>
                    JSON-LD
                </a>
                <a href="<?php echo esc_url(home_url('/.well-known/llms.txt')); ?>" target="_blank" class="qmsbf-endpoint-link">
                    <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="margin-right: 4px;"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                    llms.txt
                </a>
                <a href="<?php echo esc_url(home_url('/.well-known/ai-plugin.json')); ?>" target="_blank" class="qmsbf-endpoint-link">
                    <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="margin-right: 4px;"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                    AI Plugin
                </a>
                <a href="<?php echo esc_url(home_url('/.well-known/qmsbf-openapi.json')); ?>" target="_blank" class="qmsbf-endpoint-link">
                    <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="margin-right: 4px;"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                    OpenAPI
                </a>
                <a href="<?php echo esc_url(rest_url('qmsbf/v1/business')); ?>" target="_blank" class="qmsbf-endpoint-link">
                    <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="margin-right: 4px;"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                    REST API
                </a>
            </div>
        </div>
        <?php if ($show_footer): ?>
        <p>Business information powered by <a href="https://qmspace.com" target="_blank" rel="noopener">AI Business Facts</a></p>
        <?php endif; ?>
    </div>
</div>
