<?php
/**
 * Admin Page Template
 * 
 * @package QMSpace_Business_Facts
 */

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables in isolated scope

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get saved data with defaults
$settings = get_option('qmsbf_settings', array(
    'data_mode' => 'manual',
    'business_type' => 'LocalBusiness',
    'show_footer' => false,
    'logo_position' => 'side',
    'enable_analytics' => false
));

$business = get_option('qmsbf_business', array());
$address = get_option('qmsbf_address', array());
$hours = get_option('qmsbf_hours', array());
$social = get_option('qmsbf_social', array());
$display_fields = get_option('qmsbf_display_fields', array());
$page_id = get_option('qmsbf_page_id');

// Analytics data
$analytics = get_option('qmsbf_analytics', array(
    'page_views' => 0,
    'json_requests' => 0,
    'daily_stats' => array(),
    'ai_services' => array(),
    'recent_requests' => array()
));

// Default display fields
$display_defaults = array(
    'name' => true,
    'description' => true,
    'logo' => true,
    'website' => true,
    'email' => true,
    'phone' => true,
    'fax' => false,
    'address' => true,
    'hours' => true,
    'price_range' => true,
    'map' => true,
    'special_hours' => true
);

$display_fields = wp_parse_args($display_fields, $display_defaults);

// Check if wizard should be shown
$plugin = QMSpace_Business_Facts::getInstance();
$show_wizard = $plugin->should_show_wizard();
?>

<?php if ($show_wizard): ?>
<!-- Full Page Multi-Step Setup Screen -->
<div class="qmsbf-setup-screen" id="qmsbf-setup-screen">
    <div class="qmsbf-setup-container">
        
        <!-- Left Side - Branding -->
        <div class="qmsbf-setup-left">
            <div class="qmsbf-setup-brand">
                <img src="<?php echo esc_url(QMSBF_PLUGIN_URL . 'qms-logo-white.png'); ?>" alt="QMSpace" class="qmsbf-setup-logo">
                <h1>QMSpace Business Facts</h1>
            </div>
            
            <div class="qmsbf-setup-features">
                <div class="qmsbf-setup-feature">
                    <div class="qmsbf-setup-feature-icon">
                        <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9"/>
                        </svg>
                    </div>
                    <div>
                        <h4>AI-Ready Data</h4>
                        <p>Structured JSON-LD that ChatGPT, Claude & Gemini understand</p>
                    </div>
                </div>
                
                <div class="qmsbf-setup-feature">
                    <div class="qmsbf-setup-feature-icon">
                        <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div>
                        <h4>Accurate Answers</h4>
                        <p>Stop AI from giving wrong info about your hours & location</p>
                    </div>
                </div>
                
                <div class="qmsbf-setup-feature">
                    <div class="qmsbf-setup-feature-icon">
                        <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                    </div>
                    <div>
                        <h4>2-Minute Setup</h4>
                        <p>Enter your info once, visible to all AI assistants</p>
                    </div>
                </div>
            </div>
            
            <!-- Progress indicator -->
            <div class="qmsbf-setup-progress" id="qmsbf-setup-progress">
                <div class="qmsbf-progress-step active" data-step="1">
                    <div class="qmsbf-progress-dot">1</div>
                    <span>Account</span>
                </div>
                <div class="qmsbf-progress-line"></div>
                <div class="qmsbf-progress-step" data-step="2">
                    <div class="qmsbf-progress-dot">2</div>
                    <span>Business</span>
                </div>
                <div class="qmsbf-progress-line"></div>
                <div class="qmsbf-progress-step" data-step="3">
                    <div class="qmsbf-progress-dot">3</div>
                    <span>Contact</span>
                </div>
            </div>
        </div>
        
        <!-- Right Side - Form Steps -->
        <div class="qmsbf-setup-right">
            <div class="qmsbf-setup-card">
                
                <!-- Step 1: Email -->
                <div class="qmsbf-setup-step active" id="wizard-step-1">
                    <div class="qmsbf-setup-card-header">
                        <h2>Welcome!</h2>
                        <p>Let's get your business visible to AI assistants. Optionally sign up for product updates below.</p>
                    </div>
                    
                    <form class="qmsbf-setup-form" id="qmsbf-wizard-step1-form">
                        <div class="qmsbf-setup-field">
                            <label for="wizard-email">Email Address <span style="font-weight: normal; color: #9ca3af;">(optional)</span></label>
                            <input type="email" 
                                   id="wizard-email" 
                                   placeholder="you@example.com" 
                                   autocomplete="email">
                        </div>
                        
                        <div class="qmsbf-setup-field" style="margin-top: 12px;">
                            <label class="qmsbf-checkbox-label" style="display: flex; align-items: flex-start; gap: 10px; font-size: 13px; color: #6b7280; cursor: pointer;">
                                <input type="checkbox" id="wizard-consent" style="margin-top: 3px; width: 16px; height: 16px;">
                                <span>I agree to receive product updates and tips from QMSpace. You can unsubscribe anytime. <a href="https://qmspace.com/privacy" target="_blank" style="color: #8b5cf6;">Privacy Policy</a></span>
                            </label>
                        </div>
                        
                        <button type="submit" class="qmsbf-setup-submit">
                            <span class="btn-text">Continue</span>
                            <svg class="qmsbf-arrow" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                            </svg>
                        </button>
                    </form>
                    
                    <div class="qmsbf-setup-divider"><span>or</span></div>
                    
                    <button type="button" class="qmsbf-setup-skip" id="qmsbf-wizard-skip">
                        Skip setup wizard
                    </button>
                </div>
                
                <!-- Step 2: Business Info -->
                <div class="qmsbf-setup-step" id="wizard-step-2">
                    <div class="qmsbf-setup-card-header">
                        <h2>Your Business</h2>
                        <p>Tell us about your business so AI assistants can provide accurate information.</p>
                    </div>
                    
                    <form class="qmsbf-setup-form" id="qmsbf-wizard-step2-form">
                        <div class="qmsbf-setup-field">
                            <label for="wizard-business-name">Business Name *</label>
                            <input type="text" 
                                   id="wizard-business-name" 
                                   placeholder="Acme Corporation" 
                                   required>
                        </div>
                        
                        <div class="qmsbf-setup-field">
                            <label for="wizard-description">Short Description</label>
                            <textarea id="wizard-description" 
                                      placeholder="We help businesses..." 
                                      rows="3"></textarea>
                        </div>
                        
                        <div class="qmsbf-setup-field">
                            <label for="wizard-business-type">Business Type</label>
                            <select id="wizard-business-type">
                                <option value="LocalBusiness">Local Business</option>
                                <option value="Store">Store / Retail</option>
                                <option value="Restaurant">Restaurant</option>
                                <option value="Service">Service Provider</option>
                                <option value="Organization">Organization</option>
                                <option value="Corporation">Corporation</option>
                            </select>
                        </div>
                        
                        <div class="qmsbf-setup-buttons">
                            <button type="button" class="qmsbf-setup-back" id="back-to-step-1">
                                <svg width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                                </svg>
                                Back
                            </button>
                            <button type="submit" class="qmsbf-setup-submit">
                                <span class="btn-text">Continue</span>
                                <svg class="qmsbf-arrow" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                                </svg>
                            </button>
                        </div>
                    </form>
                </div>
                
                <!-- Step 3: Contact Info -->
                <div class="qmsbf-setup-step" id="wizard-step-3">
                    <div class="qmsbf-setup-card-header">
                        <h2>Contact Details</h2>
                        <p>How can customers reach you? This info will be public.</p>
                    </div>
                    
                    <form class="qmsbf-setup-form" id="qmsbf-wizard-step3-form">
                        <div class="qmsbf-setup-row">
                            <div class="qmsbf-setup-field">
                                <label for="wizard-phone">Phone Number</label>
                                <input type="tel" 
                                       id="wizard-phone" 
                                       placeholder="(555) 123-4567">
                            </div>
                            
                            <div class="qmsbf-setup-field">
                                <label for="wizard-business-email">Public Email</label>
                                <input type="email" 
                                       id="wizard-business-email" 
                                       placeholder="info@example.com">
                            </div>
                        </div>
                        
                        <div class="qmsbf-setup-field">
                            <label for="wizard-website">Website</label>
                            <input type="text" 
                                   id="wizard-website" 
                                   placeholder="example.com">
                            <span class="qmsbf-field-hint" style="font-size: 11px; color: #9ca3af; margin-top: 4px; display: block;">We'll add https:// automatically</span>
                        </div>
                        
                        <div class="qmsbf-setup-field">
                            <label for="wizard-address">Street Address</label>
                            <input type="text" 
                                   id="wizard-address" 
                                   placeholder="123 Main Street">
                        </div>
                        
                        <div class="qmsbf-setup-row">
                            <div class="qmsbf-setup-field">
                                <label for="wizard-city">City</label>
                                <input type="text" id="wizard-city" placeholder="New York">
                            </div>
                            <div class="qmsbf-setup-field qmsbf-setup-field-small">
                                <label for="wizard-state">State</label>
                                <input type="text" id="wizard-state" placeholder="NY">
                            </div>
                            <div class="qmsbf-setup-field qmsbf-setup-field-small">
                                <label for="wizard-zip">ZIP</label>
                                <input type="text" id="wizard-zip" placeholder="10001">
                            </div>
                        </div>
                        
                        <div class="qmsbf-setup-buttons">
                            <button type="button" class="qmsbf-setup-back" id="back-to-step-2">
                                <svg width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                                </svg>
                                Back
                            </button>
                            <button type="submit" class="qmsbf-setup-submit qmsbf-setup-finish">
                                <span class="btn-text">Finish Setup</span>
                                <span class="btn-loading" style="display:none;">
                                    <svg class="qmsbf-spinner" width="20" height="20" viewBox="0 0 24 24">
                                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="3" fill="none" opacity="0.25"/>
                                        <path d="M12 2a10 10 0 0110 10" stroke="currentColor" stroke-width="3" fill="none" stroke-linecap="round"/>
                                    </svg>
                                    Saving...
                                </span>
                                <svg class="qmsbf-check" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path d="M5 13l4 4L19 7"/>
                                </svg>
                            </button>
                        </div>
                    </form>
                </div>
                
            </div>
            
            <p class="qmsbf-setup-footer-text">
                By continuing, you agree to receive product updates.<br>
                <a href="https://qmspace.com/privacy" target="_blank">Privacy Policy</a>
            </p>
        </div>
        
    </div>
</div>

<?php endif; ?>

<div class="qmsbf-admin-wrapper">
    <div class="qmsbf-admin-header">
        <div class="qmsbf-header-content">
            <div class="qmsbf-logo-section">
                <img src="<?php echo esc_url(QMSBF_PLUGIN_URL . 'qm-logo.png'); ?>" alt="QM" class="qmsbf-logo">
            </div>
            <div class="qmsbf-title-section">
                <h1>QMSpace Business Facts <span class="qmsbf-lite-badge">LITE</span></h1>
                <p>Make Your Business Visible to AI Assistants</p>
            </div>
            <div class="qmsbf-header-actions">
                <?php 
                $custom_profile_url = $settings['custom_profile_url'] ?? '';
                $profile_url = '';
                if (!empty($custom_profile_url)) {
                    $profile_url = $custom_profile_url;
                } elseif ($page_id) {
                    $page = get_post($page_id);
                    if ($page && $page->post_status === 'publish') {
                        $profile_url = get_permalink($page_id);
                    }
                }
                ?>
                <?php if ($profile_url): ?>
                    <a href="<?php echo esc_url($profile_url); ?>" target="_blank" class="qmsbf-button secondary" title="View Page">
                        <span class="dashicons dashicons-visibility"></span> <span>View Page</span>
                    </a>
                <?php else: ?>
                    <button id="create-page-btn" class="qmsbf-button secondary" title="Create Page">
                        <span class="dashicons dashicons-admin-page"></span> <span>Create Page</span>
                    </button>
                <?php endif; ?>
                <a href="<?php echo esc_url( home_url( '/.well-known/ai-business.json' ) ); ?>" target="_blank" class="qmsbf-button secondary" title="View JSON">
                    <span class="dashicons dashicons-media-code"></span> <span>View JSON</span>
                </a>
                <button id="flush-cache-btn" class="qmsbf-button secondary" title="Clears WordPress object cache, rewrite rules, and popular caching plugins">
                    <span class="dashicons dashicons-update"></span> <span>Flush All Caches</span>
                </button>
                <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button primary qmsbf-upgrade-btn" title="Upgrade to Pro">
                    <span class="dashicons dashicons-star-filled"></span> <span>Upgrade to Pro</span>
                </a>
            </div>
        </div>
    </div>
    
    <div class="qmsbf-admin-body">
        <div class="qmsbf-tabs">
            <button class="qmsbf-tab active" data-tab="settings">
                <span class="dashicons dashicons-admin-settings"></span> Settings
            </button>
            <button class="qmsbf-tab" data-tab="display">
                <span class="dashicons dashicons-visibility"></span> Display Settings
            </button>
            <button class="qmsbf-tab" data-tab="business">
                <span class="dashicons dashicons-building"></span> Business Info
            </button>
            <button class="qmsbf-tab" data-tab="contact">
                <span class="dashicons dashicons-phone"></span> Contact
            </button>
            <button class="qmsbf-tab" data-tab="address">
                <span class="dashicons dashicons-location"></span> Address
            </button>
            <button class="qmsbf-tab" data-tab="hours">
                <span class="dashicons dashicons-clock"></span> Hours
            </button>
            <button class="qmsbf-tab qmsbf-pro-tab" data-tab="social">
                <span class="dashicons dashicons-share"></span> Social <span class="qmsbf-pro-badge">PRO</span>
            </button>
            <button class="qmsbf-tab qmsbf-pro-tab" data-tab="ai-score">
                <span class="dashicons dashicons-chart-bar"></span> AI Score <span class="qmsbf-pro-badge">PRO</span>
            </button>
            <button class="qmsbf-tab qmsbf-pro-tab" data-tab="ai-test">
                <span class="dashicons dashicons-format-chat"></span> Test AI <span class="qmsbf-pro-badge">PRO</span>
            </button>
            <button class="qmsbf-tab qmsbf-pro-tab" data-tab="insights">
                <span class="dashicons dashicons-chart-area"></span> Insights <span class="qmsbf-pro-badge">PRO</span>
            </button>
            <button class="qmsbf-tab qmsbf-pro-tab" data-tab="analytics">
                <span class="dashicons dashicons-analytics"></span> Analytics <span class="qmsbf-pro-badge">PRO</span>
            </button>
            <button class="qmsbf-tab qmsbf-pro-tab" data-tab="bot-blocking">
                <span class="dashicons dashicons-shield"></span> Bot Blocking <span class="qmsbf-pro-badge">PRO</span>
            </button>
            <button class="qmsbf-tab" data-tab="help">
                <span class="dashicons dashicons-editor-help"></span> Help
            </button>
        </div>
        
        <div class="qmsbf-content">
            <!-- Settings Tab -->
            <div class="qmsbf-tab-content active" id="settings-tab">
                <div class="qmsbf-card">
                    <h2>General Settings</h2>
                    
                    <div class="qmsbf-field">
                        <label for="business_type">Business Type</label>
                        <select id="business_type" name="business_type">
                            <option value="LocalBusiness" <?php selected($settings['business_type'] ?? 'LocalBusiness', 'LocalBusiness'); ?>>Local Business</option>
                            <option value="OnlineBusiness" <?php selected($settings['business_type'] ?? 'LocalBusiness', 'OnlineBusiness'); ?>>Online Business</option>
                            <option value="Store" <?php selected($settings['business_type'] ?? 'LocalBusiness', 'Store'); ?>>Store</option>
                            <option value="Restaurant" <?php selected($settings['business_type'] ?? 'LocalBusiness', 'Restaurant'); ?>>Restaurant</option>
                            <option value="Service" <?php selected($settings['business_type'] ?? 'LocalBusiness', 'Service'); ?>>Service Provider</option>
                            <option value="Organization" <?php selected($settings['business_type'] ?? 'LocalBusiness', 'Organization'); ?>>Organization</option>
                            <option value="Corporation" <?php selected($settings['business_type'] ?? 'LocalBusiness', 'Corporation'); ?>>Corporation</option>
                        </select>
                    </div>
                    
                    <div class="qmsbf-field">
                        <label class="qmsbf-checkbox">
                            <input type="checkbox" name="show_footer" <?php checked($settings['show_footer'] ?? false); ?>>
                            <span>Show "Powered by QMSpace Business Facts" credit on profile page</span>
                        </label>
                    </div>
                    
                    <div class="qmsbf-field" style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #e5e7eb;">
                        <label class="qmsbf-checkbox">
                            <input type="checkbox" name="allow_cross_origin" <?php checked($settings['allow_cross_origin'] ?? true); ?>>
                            <span>Allow Cross-Origin Access (CORS)</span>
                        </label>
                        <p class="qmsbf-field-hint" style="margin-top: 8px; margin-left: 28px;">
                            Allow AI services and external applications to access your JSON endpoints from other domains. 
                            <strong>Recommended:</strong> Keep enabled for AI discovery.
                        </p>
                    </div>
                    
                    <div class="qmsbf-field" style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #e5e7eb;">
                        <label for="data_reminder">Data Update Reminder</label>
                        <?php $current_reminder = isset($settings['data_reminder']) ? intval($settings['data_reminder']) : 30; ?>
                        <select id="data_reminder" name="data_reminder">
                            <option value="0" <?php selected($current_reminder, 0); ?>>Disabled</option>
                            <option value="7" <?php selected($current_reminder, 7); ?>>Every 7 days</option>
                            <option value="14" <?php selected($current_reminder, 14); ?>>Every 14 days</option>
                            <option value="30" <?php selected($current_reminder, 30); ?>>Every 30 days</option>
                            <option value="60" <?php selected($current_reminder, 60); ?>>Every 60 days</option>
                            <option value="90" <?php selected($current_reminder, 90); ?>>Every 90 days</option>
                        </select>
                        <p class="qmsbf-field-hint">
                            Get a dashboard notification reminding you to review and update your business information.
                        </p>
                    </div>
                    
                    <!-- Pro Features Upsell -->
                    <div class="qmsbf-pro-teaser" style="margin-top: 30px;">
                        <h3><span class="dashicons dashicons-star-filled"></span> Unlock More Settings with Pro</h3>
                        <p>Pro version includes analytics tracking, dashboard widgets, custom timezones, and advanced configuration options.</p>
                        <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button">
                            <span class="dashicons dashicons-star-filled"></span> Upgrade to Pro
                        </a>
                    </div>
                    
                    <div class="qmsbf-field" style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #e5e7eb;">
                        <button type="button" class="qmsbf-button secondary" id="auto-populate-btn">
                            <span class="dashicons dashicons-update"></span> Auto-Populate from WordPress
                        </button>
                    </div>
                    
                    <!-- Data Management -->
                    <div class="qmsbf-field" style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #e5e7eb;">
                        <h3 style="margin: 0 0 15px 0; font-size: 16px; color: #374151;">Data Management</h3>
                        
                        <div style="padding: 20px; background: #fef2f2; border: 1px solid #fecaca; border-radius: 8px;">
                            <p style="margin: 0 0 15px 0; color: #991b1b; font-size: 14px;">
                                <strong>⚠️ Danger Zone</strong><br>
                                Reset all plugin data to start fresh. This cannot be undone.
                            </p>
                            <button type="button" id="qmsbf-reset-all-data" class="qmsbf-button" style="background: #dc2626; border-color: #dc2626;">
                                <span class="dashicons dashicons-trash"></span> Reset All Data
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Display Settings Tab -->
            <div class="qmsbf-tab-content" id="display-tab">
                <div class="qmsbf-card">
                    <h2>Display Settings</h2>
                    <p class="qmsbf-description">Choose which fields to display on your public profile page and in the JSON output.</p>
                    
                    <div class="qmsbf-display-grid">
                        <div class="qmsbf-display-section">
                            <h3>Basic Information</h3>
                            
                            <div class="qmsbf-field">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" name="display_name" <?php checked($display_fields['name']); ?>>
                                    <span>Business Name</span>
                                </label>
                            </div>
                            
                            <div class="qmsbf-field">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" name="display_description" <?php checked($display_fields['description']); ?>>
                                    <span>Description</span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="qmsbf-display-section">
                            <h3>Contact Information</h3>
                            
                            <div class="qmsbf-field">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" name="display_website" <?php checked($display_fields['website']); ?>>
                                    <span>Website</span>
                                </label>
                            </div>
                            
                            <div class="qmsbf-field">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" name="display_email" <?php checked($display_fields['email']); ?>>
                                    <span>Email</span>
                                </label>
                            </div>
                            
                            <div class="qmsbf-field">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" name="display_phone" <?php checked($display_fields['phone']); ?>>
                                    <span>Phone</span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="qmsbf-display-section">
                            <h3>Location & Hours</h3>
                            
                            <div class="qmsbf-field">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" name="display_address" <?php checked($display_fields['address']); ?>>
                                    <span>Address</span>
                                </label>
                            </div>
                            
                            <div class="qmsbf-field">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" name="display_map" <?php checked($display_fields['map']); ?>>
                                    <span>Map Link</span>
                                </label>
                            </div>
                            
                            <div class="qmsbf-field">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" name="display_hours" <?php checked($display_fields['hours']); ?>>
                                    <span>Business Hours</span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="qmsbf-display-section">
                            <h3 style="color: #8b5cf6;">Pro Display Options</h3>
                            
                            <div class="qmsbf-field" style="opacity: 0.6;">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" disabled>
                                    <span>Logo <span class="qmsbf-pro-badge">PRO</span></span>
                                </label>
                            </div>
                            
                            <div class="qmsbf-field" style="opacity: 0.6;">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" disabled>
                                    <span>Legal Name <span class="qmsbf-pro-badge">PRO</span></span>
                                </label>
                            </div>
                            
                            <div class="qmsbf-field" style="opacity: 0.6;">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" disabled>
                                    <span>Price Range <span class="qmsbf-pro-badge">PRO</span></span>
                                </label>
                            </div>
                            
                            <div class="qmsbf-field" style="opacity: 0.6;">
                                <label class="qmsbf-checkbox">
                                    <input type="checkbox" disabled>
                                    <span>Social Links <span class="qmsbf-pro-badge">PRO</span></span>
                                </label>
                            </div>
                            
                            <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" style="display: inline-flex; align-items: center; gap: 6px; margin-top: 10px; color: #8b5cf6; font-size: 13px; text-decoration: none;">
                                <span class="dashicons dashicons-star-filled"></span> Unlock all display options →
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Business Info Tab -->
            <div class="qmsbf-tab-content" id="business-tab">
                <div class="qmsbf-card">
                    <h2>Business Information</h2>
                    
                    <div class="qmsbf-field">
                        <label for="business_name">Business Name *</label>
                        <input type="text" id="business_name" name="business_name" value="<?php echo esc_attr($business['name'] ?? ''); ?>" placeholder="Your Business Name">
                    </div>
                    
                    <div class="qmsbf-field">
                        <label for="business_description">Description</label>
                        <textarea id="business_description" name="business_description" rows="4" placeholder="Brief description of your business"><?php echo esc_textarea($business['description'] ?? ''); ?></textarea>
                    </div>
                    
                    <!-- Pro Features -->
                    <div class="qmsbf-pro-fields-section" style="margin-top: 30px; padding: 20px; background: linear-gradient(135deg, #f5f3ff 0%, #ede9fe 100%); border: 2px solid #c4b5fd; border-radius: 12px;">
                        <h3 style="margin: 0 0 15px 0; color: #5b21b6; display: flex; align-items: center; gap: 8px;">
                            <span class="dashicons dashicons-star-filled" style="color: #8b5cf6;"></span> Pro Features
                        </h3>
                        
                        <div class="qmsbf-field" style="opacity: 0.6; pointer-events: none;">
                            <label for="legal_name">Legal Name <span class="qmsbf-pro-badge">PRO</span></label>
                            <input type="text" id="legal_name" name="legal_name" value="" placeholder="Legal Business Entity Name" disabled>
                        </div>
                        
                        <div class="qmsbf-field" style="opacity: 0.6; pointer-events: none;">
                            <label for="business_logo">Logo <span class="qmsbf-pro-badge">PRO</span></label>
                            <div style="display: flex; gap: 10px;">
                                <button type="button" class="qmsbf-button secondary" disabled>
                                    <span class="dashicons dashicons-upload"></span> Select Logo
                                </button>
                            </div>
                            <p class="qmsbf-field-hint" style="margin-top: 8px;">Upload your business logo for AI visibility</p>
                        </div>
                        
                        <div class="qmsbf-field" style="opacity: 0.6; pointer-events: none;">
                            <label for="price_range">Price Range <span class="qmsbf-pro-badge">PRO</span></label>
                            <select id="price_range" name="price_range" disabled>
                                <option value="">Select...</option>
                            </select>
                        </div>
                        
                        <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button" style="margin-top: 15px; background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); color: white;">
                            <span class="dashicons dashicons-star-filled"></span> Unlock with Pro
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Contact Tab -->
            <div class="qmsbf-tab-content" id="contact-tab">
                <div class="qmsbf-card">
                    <h2>Contact Information</h2>
                    
                    <div class="qmsbf-field">
                        <label for="business_website">Website</label>
                        <input type="url" id="business_website" name="business_website" value="<?php echo esc_url($business['website'] ?? ''); ?>" placeholder="https://example.com">
                    </div>
                    
                    <div class="qmsbf-field">
                        <label for="business_email">Email</label>
                        <input type="email" id="business_email" name="business_email" value="<?php echo esc_attr($business['email'] ?? ''); ?>" placeholder="contact@example.com">
                    </div>
                    
                    <div class="qmsbf-field">
                        <label for="business_phone">Phone</label>
                        <input type="tel" id="business_phone" name="business_phone" value="<?php echo esc_attr($business['phone'] ?? ''); ?>" placeholder="+1 (555) 123-4567">
                    </div>
                </div>
            </div>
            
            <!-- Address Tab -->
            <div class="qmsbf-tab-content" id="address-tab">
                <div class="qmsbf-card">
                    <h2>Address</h2>
                    
                    <div class="qmsbf-field">
                        <label for="address_street">Street Address</label>
                        <input type="text" id="address_street" name="address_street" value="<?php echo esc_attr($address['street'] ?? ''); ?>" placeholder="123 Main Street">
                    </div>
                    
                    <div class="qmsbf-field">
                        <label for="address_city">City</label>
                        <input type="text" id="address_city" name="address_city" value="<?php echo esc_attr($address['city'] ?? ''); ?>" placeholder="New York">
                    </div>
                    
                    <div class="qmsbf-field">
                        <label for="address_state">State/Province</label>
                        <input type="text" id="address_state" name="address_state" value="<?php echo esc_attr($address['state'] ?? ''); ?>" placeholder="NY">
                    </div>
                    
                    <div class="qmsbf-field">
                        <label for="address_postal">Postal Code</label>
                        <input type="text" id="address_postal" name="address_postal" value="<?php echo esc_attr($address['postal'] ?? ''); ?>" placeholder="10001">
                    </div>
                    
                    <div class="qmsbf-field">
                        <label for="address_country">Country</label>
                        <input type="text" id="address_country" name="address_country" value="<?php echo esc_attr($address['country'] ?? ''); ?>" placeholder="United States">
                    </div>
                    
                    <div class="qmsbf-field">
                        <label>Google Maps</label>
                        <div class="qmsbf-map-tool" style="background: #f9fafb; border: 1px solid #e5e7eb; border-radius: 8px; padding: 20px;">
                            
                            <!-- Map Preview -->
                            <div id="map-preview-container" style="margin-bottom: 15px; <?php echo empty($address['map_url']) ? 'display:none;' : ''; ?>">
                                <label style="font-size: 12px; color: #6b7280; margin-bottom: 8px; display: block;">Map Preview</label>
                                <div style="border-radius: 8px; overflow: hidden; border: 1px solid #e5e7eb;">
                                    <iframe id="map-preview" src="<?php echo esc_url($address['map_url'] ?? ''); ?>" width="100%" height="250" style="border:0; display: block;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                </div>
                            </div>
                            
                            <!-- Generate from Address -->
                            <div style="margin-bottom: 15px;">
                                <button type="button" id="generate-map-btn" class="qmsbf-button secondary" style="width: 100%;">
                                    <span class="dashicons dashicons-location"></span> Generate Map from Address Above
                                </button>
                                <p class="qmsbf-field-hint" style="margin-top: 5px; text-align: center;">Uses the address fields you've entered above</p>
                            </div>
                            
                            <!-- Or Search -->
                            <div style="margin-bottom: 15px;">
                                <label style="font-size: 12px; color: #6b7280; margin-bottom: 8px; display: block;">Or search for a location:</label>
                                <div style="display: flex; gap: 10px;">
                                    <input type="text" id="map-search" placeholder="e.g., Empire State Building, NYC" style="flex: 1;">
                                    <button type="button" id="search-map-btn" class="qmsbf-button secondary">
                                        <span class="dashicons dashicons-search"></span> Search
                                    </button>
                                </div>
                            </div>
                            
                            <!-- Manual URL (collapsible) -->
                            <div style="border-top: 1px solid #e5e7eb; padding-top: 15px;">
                                <button type="button" id="toggle-manual-url" style="background: none; border: none; color: #6b7280; cursor: pointer; font-size: 12px; display: flex; align-items: center; gap: 5px;">
                                    <span class="dashicons dashicons-arrow-down-alt2" id="manual-url-arrow"></span> Advanced: Enter embed URL manually
                                </button>
                                <div id="manual-url-section" style="display: none; margin-top: 10px;">
                                    <input type="url" id="map_url" name="map_url" value="<?php echo esc_url($address['map_url'] ?? ''); ?>" placeholder="https://www.google.com/maps/embed?...">
                                    <p class="qmsbf-field-hint">Paste a Google Maps embed URL directly</p>
                                </div>
                            </div>
                            
                            <!-- Clear Map -->
                            <div style="margin-top: 15px; text-align: center; <?php echo empty($address['map_url']) ? 'display:none;' : ''; ?>" id="clear-map-container">
                                <button type="button" id="clear-map-btn" class="qmsbf-button secondary" style="color: #dc2626;">
                                    <span class="dashicons dashicons-trash"></span> Remove Map
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Hours Tab -->
            <div class="qmsbf-tab-content" id="hours-tab">
                <div class="qmsbf-card">
                    <h2>Business Hours</h2>
                    
                    <div class="qmsbf-field" style="margin-bottom: 20px; padding: 15px; background: #f0fdf4; border-radius: 8px; border: 1px solid #86efac;">
                        <label class="qmsbf-checkbox" style="font-size: 16px;">
                            <input type="checkbox" 
                                   id="open_24_7" 
                                   name="hours[is_24_7]" 
                                   <?php checked($hours['is_24_7'] ?? false); ?>>
                            <span style="font-weight: 600; color: #166534;">Open 24/7</span>
                        </label>
                        <p class="qmsbf-field-hint" style="margin-top: 8px; margin-bottom: 0;">Check this if your business is open 24 hours a day, 7 days a week.</p>
                    </div>
                    
                    <div id="daily-hours-wrapper" style="<?php echo ($hours['is_24_7'] ?? false) ? 'opacity: 0.5; pointer-events: none;' : ''; ?>">
                    <?php
                    $days = array(
                        'monday' => 'Monday',
                        'tuesday' => 'Tuesday',
                        'wednesday' => 'Wednesday',
                        'thursday' => 'Thursday',
                        'friday' => 'Friday',
                        'saturday' => 'Saturday',
                        'sunday' => 'Sunday'
                    );
                    
                    foreach ($days as $key => $label):
                        $day_hours = $hours[$key] ?? array('open' => '09:00', 'close' => '17:00', 'closed' => false);
                    ?>
                    <div class="qmsbf-hours-row">
                        <div class="qmsbf-hours-day"><?php echo esc_html( $label ); ?></div>
                        <div class="qmsbf-hours-controls">
                            <input type="time" 
                                   name="hours_<?php echo esc_attr( $key ); ?>_open" 
                                   value="<?php echo esc_attr($day_hours['open']); ?>"
                                   <?php echo $day_hours['closed'] ? 'disabled' : ''; ?>>
                            <span>to</span>
                            <input type="time" 
                                   name="hours_<?php echo esc_attr( $key ); ?>_close" 
                                   value="<?php echo esc_attr($day_hours['close']); ?>"
                                   <?php echo $day_hours['closed'] ? 'disabled' : ''; ?>>
                            <label class="qmsbf-checkbox">
                                <input type="checkbox" 
                                       name="hours_<?php echo esc_attr( $key ); ?>_closed" 
                                       class="closed-checkbox"
                                       <?php checked($day_hours['closed']); ?>>
                                <span>Closed</span>
                            </label>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    </div>
                    
                    <div class="qmsbf-field" style="margin-top: 20px;">
                        <label for="special_hours">Special Hours Note</label>
                        <textarea id="special_hours" name="special_hours" rows="3" placeholder="e.g., Closed on public holidays"><?php echo esc_textarea($hours['special'] ?? ''); ?></textarea>
                    </div>
                </div>
            </div>
            
            <!-- Social Links Tab -->
            <div class="qmsbf-tab-content" id="social-tab">
                <div class="qmsbf-paywall">
                    <div class="qmsbf-paywall-icon">
                        <span class="dashicons dashicons-share"></span>
                    </div>
                    <h2>Social Media Profiles</h2>
                    <p>Connect your social profiles so AI assistants can direct customers to your Facebook, Instagram, Twitter, LinkedIn, YouTube, and more.</p>
                    <ul class="qmsbf-paywall-features">
                        <li><span class="dashicons dashicons-yes"></span> Link 5+ social platforms</li>
                        <li><span class="dashicons dashicons-yes"></span> Automatic Schema.org sameAs markup</li>
                        <li><span class="dashicons dashicons-yes"></span> Domain validation for security</li>
                        <li><span class="dashicons dashicons-yes"></span> Appear in AI knowledge panels</li>
                    </ul>
                    <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button primary">
                        <span class="dashicons dashicons-star-filled"></span> Upgrade to Pro
                    </a>
                </div>
            </div>
            
            <!-- AI Score Tab -->
            <div class="qmsbf-tab-content" id="ai-score-tab">
                <div class="qmsbf-paywall">
                    <div class="qmsbf-paywall-icon">
                        <span class="dashicons dashicons-chart-bar"></span>
                    </div>
                    <h2>AI Visibility Score</h2>
                    <p>See how well AI assistants can represent your business. Get a detailed breakdown of what's helping and what's missing from your AI profile.</p>
                    <ul class="qmsbf-paywall-features">
                        <li><span class="dashicons dashicons-yes"></span> Visual score ring with real-time calculation</li>
                        <li><span class="dashicons dashicons-yes"></span> Detailed data points breakdown</li>
                        <li><span class="dashicons dashicons-yes"></span> Actionable improvement suggestions</li>
                        <li><span class="dashicons dashicons-yes"></span> Track your score over time</li>
                    </ul>
                    <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button primary">
                        <span class="dashicons dashicons-star-filled"></span> Upgrade to Pro
                    </a>
                </div>
            </div>
            
            <!-- AI Test Tab -->
            <div class="qmsbf-tab-content" id="ai-test-tab">
                <div class="qmsbf-paywall">
                    <div class="qmsbf-paywall-icon">
                        <span class="dashicons dashicons-format-chat"></span>
                    </div>
                    <h2>Test AI Responses</h2>
                    <p>Ask ChatGPT, Claude, and other AI assistants about your business directly from WordPress. See exactly what customers are being told.</p>
                    <ul class="qmsbf-paywall-features">
                        <li><span class="dashicons dashicons-yes"></span> Interactive AI chat simulation</li>
                        <li><span class="dashicons dashicons-yes"></span> Quick question templates</li>
                        <li><span class="dashicons dashicons-yes"></span> Compare before/after responses</li>
                        <li><span class="dashicons dashicons-yes"></span> Identify incorrect information</li>
                    </ul>
                    <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button primary">
                        <span class="dashicons dashicons-star-filled"></span> Upgrade to Pro
                    </a>
                </div>
            </div>
            
            <!-- Insights Tab -->
            <div class="qmsbf-tab-content" id="insights-tab">
                <div class="qmsbf-paywall">
                    <div class="qmsbf-paywall-icon">
                        <span class="dashicons dashicons-chart-area"></span>
                    </div>
                    <h2>AI Activity Insights</h2>
                    <p>Get comprehensive insights into how AI services are interacting with your business data. See trends, traffic patterns, and detailed analytics.</p>
                    <ul class="qmsbf-paywall-features">
                        <li><span class="dashicons dashicons-yes"></span> 30-day activity timeline</li>
                        <li><span class="dashicons dashicons-yes"></span> Traffic breakdown by AI service</li>
                        <li><span class="dashicons dashicons-yes"></span> Request type analysis</li>
                        <li><span class="dashicons dashicons-yes"></span> Export to PDF reports</li>
                    </ul>
                    <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button primary">
                        <span class="dashicons dashicons-star-filled"></span> Upgrade to Pro
                    </a>
                </div>
            </div>
            
            <!-- Analytics Tab -->
                        <div class="qmsbf-tab-content" id="analytics-tab">
                <div class="qmsbf-paywall">
                    <div class="qmsbf-paywall-icon">
                        <span class="dashicons dashicons-analytics"></span>
                    </div>
                    <h2>AI Analytics Dashboard</h2>
                    <p>Track which AI services are accessing your business data. See when ChatGPT, Claude, Perplexity, and other AI crawlers visit your site.</p>
                    <ul class="qmsbf-paywall-features">
                        <li><span class="dashicons dashicons-yes"></span> Real-time AI crawler detection</li>
                        <li><span class="dashicons dashicons-yes"></span> Daily/weekly/monthly reports</li>
                        <li><span class="dashicons dashicons-yes"></span> JSON endpoint request tracking</li>
                        <li><span class="dashicons dashicons-yes"></span> Dashboard widget</li>
                        <li><span class="dashicons dashicons-yes"></span> Export analytics data</li>
                    </ul>
                    <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button primary">
                        <span class="dashicons dashicons-star-filled"></span> Upgrade to Pro
                    </a>
                </div>
            </div>
            
            <!-- Bot Blocking Tab -->
                        <div class="qmsbf-tab-content" id="bot-blocking-tab">
                <div class="qmsbf-paywall">
                    <div class="qmsbf-paywall-icon">
                        <span class="dashicons dashicons-shield"></span>
                    </div>
                    <h2>AI Bot Blocking</h2>
                    <p>Control which AI services can access your data. Block specific crawlers or allow only the ones you want.</p>
                    <ul class="qmsbf-paywall-features">
                        <li><span class="dashicons dashicons-yes"></span> Block/allow specific AI crawlers</li>
                        <li><span class="dashicons dashicons-yes"></span> Custom user agent rules</li>
                        <li><span class="dashicons dashicons-yes"></span> Robots.txt integration</li>
                        <li><span class="dashicons dashicons-yes"></span> Access logging</li>
                    </ul>
                    <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button primary">
                        <span class="dashicons dashicons-star-filled"></span> Upgrade to Pro
                    </a>
                </div>
            </div>
            
            <!-- Help Tab -->
            <div class="qmsbf-tab-content" id="help-tab">
                <div class="qmsbf-card">
                    <h2>Getting Started</h2>
                    
                    <h3>Quick Setup Guide</h3>
                    <ol>
                        <li>Enter your business information in the tabs above</li>
                        <li>Click "Save All Settings" at the bottom</li>
                        <li>Use shortcode <code>[qmsbf_business_profile]</code> or click "Create Page"</li>
                        <li>View your data at the AI Discovery endpoints below</li>
                    </ol>
                    
                    <h3>AI Discovery Endpoints</h3>
                    <p style="margin-bottom: 10px;">These endpoints allow AI assistants to discover and understand your business:</p>
                    <ul>
                        <li><strong>JSON-LD (Schema.org):</strong> <code><?php echo esc_html( home_url( '/.well-known/ai-business.json' ) ); ?></code></li>
                        <li><strong>AI Plugin Manifest:</strong> <code><?php echo esc_html( home_url( '/.well-known/ai-plugin.json' ) ); ?></code></li>
                        <li><strong>OpenAPI Spec:</strong> <code><?php echo esc_html( home_url( '/.well-known/qmsbf-openapi.json' ) ); ?></code></li>
                        <li><strong>LLM Summary:</strong> <code><?php echo esc_html( home_url( '/.well-known/llms.txt' ) ); ?></code></li>
                        <li><strong>REST API:</strong> <code><?php echo esc_html( rest_url( 'qmsbf/v1/business' ) ); ?></code></li>
                    </ul>
                    
                    <h3>Free Features</h3>
                    <ul>
                        <li>✓ Schema.org JSON-LD structured data</li>
                        <li>✓ llms.txt for LLM discovery (ChatGPT, Claude, etc.)</li>
                        <li>✓ AI agent compatible endpoints</li>
                        <li>✓ Beautiful public profile page</li>
                        <li>✓ REST API support</li>
                        <li>✓ Business name, description, contact info</li>
                        <li>✓ Address and business hours</li>
                    </ul>
                    
                    <h3>Support</h3>
                    <p>For help and documentation, visit <a href="https://qmspace.com" target="_blank">QMSpace.com</a></p>
                </div>
                
                <div class="qmsbf-card">
                    <h2><span class="dashicons dashicons-admin-tools"></span> Diagnostics</h2>
                    <p>Check if your AI discovery endpoints are working correctly:</p>
                    
                    <button type="button" class="qmsbf-button secondary" id="run-diagnostics-btn" style="margin: 15px 0;">
                        <span class="dashicons dashicons-search"></span> Run Diagnostics
                    </button>
                    
                    <div id="diagnostics-results" style="display: none; margin-top: 20px;">
                        <div id="diagnostics-content"></div>
                    </div>
                </div>
                
                <div class="qmsbf-card" style="background: linear-gradient(135deg, #f5f3ff 0%, #ede9fe 100%); border: 2px solid #c4b5fd;">
                    <h2 style="color: #5b21b6;"><span class="dashicons dashicons-star-filled" style="color: #8b5cf6;"></span> Upgrade to Pro</h2>
                    <p>Unlock the full power of QMSpace Business Facts:</p>
                    <ul>
                        <li><strong>Social Links</strong> - Connect 5+ social platforms</li>
                        <li><strong>AI Score</strong> - See how AI-ready your business is</li>
                        <li><strong>Analytics</strong> - Track AI crawler visits</li>
                        <li><strong>Test AI</strong> - See what AI says about you</li>
                        <li><strong>Bot Blocking</strong> - Control AI access</li>
                        <li><strong>Logo & Branding</strong> - Full visual identity</li>
                        <li><strong>Priority Support</strong></li>
                    </ul>
                    <a href="https://qmspace.com/buy/a-i-business-facts-pro" target="_blank" class="qmsbf-button primary" style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); margin-top: 15px;">
                        <span class="dashicons dashicons-star-filled"></span> Upgrade to Pro - $79/year
                    </a>
                </div>
            </div>
        </div>
        
        <div class="qmsbf-footer">
            <button type="button" class="qmsbf-button primary" id="save-settings">
                Save All Settings
            </button>
            <span class="qmsbf-save-status"></span>
        </div>
    </div>
</div>
