jQuery(document).ready(function($) {
    var setupScreen = $('#qmsbf-setup-screen');
    var currentStep = 1;
    var wizardData = {
        email: '',
        business_name: '',
        description: '',
        business_type: 'LocalBusiness',
        phone: '',
        business_email: '',
        website: '',
        address: '',
        city: '',
        state: '',
        zip: ''
    };
    
    // Auto-format URL (add https:// if missing)
    function formatUrl(url) {
        if (!url) return '';
        url = url.trim();
        if (url && !url.match(/^https?:\/\//i)) {
            url = 'https://' + url;
        }
        return url;
    }
    
    // Update progress indicator
    function updateProgress(step) {
        $('.qmsbf-progress-step').each(function() {
            var stepNum = $(this).data('step');
            $(this).removeClass('active completed');
            if (stepNum < step) {
                $(this).addClass('completed');
            } else if (stepNum === step) {
                $(this).addClass('active');
            }
        });
    }
    
    // Show step
    function showStep(step) {
        $('.qmsbf-setup-step').removeClass('active');
        $('#wizard-step-' + step).addClass('active');
        updateProgress(step);
        currentStep = step;
    }
    
    // Step 1: Email
    $('#qmsbf-wizard-step1-form').on('submit', function(e) {
        e.preventDefault();
        
        var email = $('#wizard-email').val().trim();
        var consent = $('#wizard-consent').is(':checked');
        
        // Only require email if consent is checked
        if (consent) {
            if (!email) {
                alert('Please enter your email address to receive updates.');
                $('#wizard-email').focus();
                return;
            }
            
            // Basic email format validation
            if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
                alert('Please enter a valid email address.');
                $('#wizard-email').focus();
                return;
            }
        }
        
        wizardData.email = email;
        wizardData.consent = consent ? 1 : 0;
        showStep(2);
    });
    
    // Step 2: Business Info
    $('#qmsbf-wizard-step2-form').on('submit', function(e) {
        e.preventDefault();
        wizardData.business_name = $('#wizard-business-name').val();
        wizardData.description = $('#wizard-description').val();
        wizardData.business_type = $('#wizard-business-type').val();
        showStep(3);
    });
    
    // Back buttons
    $('#back-to-step-1').on('click', function() {
        showStep(1);
    });
    
    $('#back-to-step-2').on('click', function() {
        showStep(2);
    });
    
    // Step 3: Contact & Finish
    $('#qmsbf-wizard-step3-form').on('submit', function(e) {
        e.preventDefault();
        
        wizardData.phone = $('#wizard-phone').val();
        wizardData.business_email = $('#wizard-business-email').val();
        
        var websiteVal = $('#wizard-website').val();
        wizardData.website = websiteVal ? formatUrl(websiteVal) : (typeof qmsbf_ajax !== 'undefined' ? qmsbf_ajax.home_url : '');
        
        wizardData.address = $('#wizard-address').val();
        wizardData.city = $('#wizard-city').val();
        wizardData.state = $('#wizard-state').val();
        wizardData.zip = $('#wizard-zip').val();
        
        var $btn = $(this).find('.qmsbf-setup-submit');
        $btn.prop('disabled', true);
        $btn.find('.btn-text, .qmsbf-check').hide();
        $btn.find('.btn-loading').show();
        
        // Submit all data
        $.ajax({
            url: qmsbf_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'qmsbf_wizard_complete',
                nonce: qmsbf_ajax.nonce,
                wizard_data: wizardData
            },
            success: function(response) {
                if (response.success) {
                    setupScreen.fadeOut(300, function() {
                        $(this).remove();
                        // Reload to show filled-in data
                        window.location.reload();
                    });
                } else {
                    alert(response.data || 'Something went wrong. Please try again.');
                    $btn.prop('disabled', false);
                    $btn.find('.btn-text, .qmsbf-check').show();
                    $btn.find('.btn-loading').hide();
                }
            },
            error: function() {
                alert('Connection error. Please try again.');
                $btn.prop('disabled', false);
                $btn.find('.btn-text, .qmsbf-check').show();
                $btn.find('.btn-loading').hide();
            }
        });
    });
    
    // Skip wizard
    $('#qmsbf-wizard-skip').on('click', function() {
        $.ajax({
            url: qmsbf_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'qmsbf_wizard_skip',
                nonce: qmsbf_ajax.nonce
            },
            success: function() {
                setupScreen.fadeOut(300, function() {
                    $(this).remove();
                });
            }
        });
    });
});
