<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       qanuk.io
 * @since      1.0.0
 *
 * @package    Events
 * @subpackage Events/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Events
 * @subpackage Events/public
 * @author     qanuk.io <support@qanuk.io> - in cooperation with <deftcoders@gmail.com>
 */

require_once plugin_dir_path(__FILE__) . '../includes/class-constants.php';

if ( ! class_exists( 'QELI_Events_Public' ) ) { 
	class QELI_Events_Public
	{

		/**
		 * The ID of this plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 * @var      string    $plugin_name    The ID of this plugin.
		 */
		private $plugin_name;

		/**
		 * The version of this plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 * @var      string    $version    The current version of this plugin.
		 */
		private $version;

		/**
		 * Initialize the class and set its properties.
		 *
		 * @since    1.0.0
		 * @param      string    $plugin_name       The name of the plugin.
		 * @param      string    $version    The version of this plugin.
		 */
		public function __construct($plugin_name, $version)
		{

			$this->plugin_name = $plugin_name;
			$this->version = $version;
		}

		/**
		 * Register the stylesheets for the public-facing side of the site.
		 *
		 * @since    1.0.0
		 */
		public function enqueue_styles()
		{

			/**
			 * This function is provided for demonstration purposes only.
			 *
			 * An instance of this class should be passed to the run() function
			 * defined in QELI_Events_Loader as all of the hooks are defined
			 * in that particular class.
			 *
			 * The QELI_Events_Loader will then create the relationship
			 * between the defined hooks and the functions defined in this
			 * class.
			 */

			wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/events-public.css', array(), $this->version, 'all');
			wp_enqueue_style($this->plugin_name . '-font-awesome', plugin_dir_url(__FILE__) . '../admin/css/font-awesome/css/all.css');
			wp_enqueue_style('dashicons');
		}

		/**
		 * Register the JavaScript for the public-facing side of the site.
		 *
		 * @since    1.0.0
		 */
		public function enqueue_scripts()
		{

			/**
			 * This function is provided for demonstration purposes only.
			 *
			 * An instance of this class should be passed to the run() function
			 * defined in QELI_Events_Loader as all of the hooks are defined
			 * in that particular class.
			 *
			 * The QELI_Events_Loader will then create the relationship
			 * between the defined hooks and the functions defined in this
			 * class.
			 */

			wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/events-public.js', array('jquery'), $this->version, false);
		}

		public function add_q_events_shortcode($atts)
		{
			ob_start();

			global $wpdb;
			$table_name = $wpdb->prefix . QELI_Events_Constants::table_event;
			$events = $wpdb->get_results("SELECT * 
			FROM $table_name 
			WHERE status=1 AND DATE(event_date) >= CURDATE() 
			ORDER BY STR_TO_DATE(event_date, '%Y-%m-%d') ASC");
			$rowcount = $wpdb->num_rows;
		?>
			<div class="q_events_wrapper">
			<?php
			if ($rowcount == 0) {?>
				<h2><?php _e('No events are planned', 'Ev');?></h2>
			<?php } else {
				setlocale(LC_TIME, "de_DE");
				foreach ($events as $event) {
				?>

					<div class="q_event_single">
					<div class="q_event_picture_details">
						<div class="q_event_picture">
							<?php // Daniel: includes -> Grafik einbauen; ?>
						<?php $image_url = wp_get_attachment_url($event->picture); 
							if (!empty($image_url)) {?>
							<img src="<?php echo esc_url($image_url); ?>">
							<?php } else { ?>
							<div class="q_event_picture_empty"></div>	
							<?php } ?>
						</div>
						<div class="q_event_details">
						<div class="q_event_info">
							<p class="mb-1 mt-0 q_event_name"><?php echo esc_html($event->show); ?></p>
							<?php if ($event->untertitel) { ?>
							<p class="mb-1 mt-0 q_event_subtitle"><?php echo esc_html($event->untertitel); ?></p>
							<?php }
							if ($event->comment) { ?>
							<p class="mb-0 mt-0 q_event_comment"><?php echo esc_html($event->comment); ?></p>
							<?php } ?>
						</div>
						<div class=" q_mbl_hide q_event_schedule">
							<p class="mb-0 mt-0 q_event_date">
							<i class="far fa-calendar-alt"></i>
							<span><?php $date = date_create($event->event_date);
									echo strftime('%a', strtotime($event->event_date)) . ', ';
									echo date_format($date, "d.m.Y"); ?></span>
							</p>
							<p class="mb-0 mt-0 q_event_time ">
							<i class="far fa-clock"></i>
							<span><?php echo esc_html($event->event_time); ?> Uhr</span>
							</p>
						</div>
						<div class="q_event_details_bottom q_desktop_hide">
							<div class="q_event_schedule_location row_q_event_details_bottom">
							<div class="col_q_event_details_bottom q_event_schedule_location_left">
								<p class="mb-0 mt-0 q_event_date">
								<span class="icon-container"><i class="far fa-calendar-alt"></i></span>
								<span><?php $date = date_create($event->event_date);
										echo strftime('%a', strtotime($event->event_date)) . ', ';
										echo date_format($date, "d.m.Y"); ?></span>
								</p>
								<p class="mb-0 mt-0 q_event_time">
								<span class="icon-container"><i class="far fa-clock"></i></span>
								<span><?php echo esc_html($event->event_time); ?> Uhr</span>
								</p>
							</div>
							<div class="col_q_event_details_bottom col_event_location">
								<p class="col_event_location_top mb-0 mt-0">
								<span class="icon-container"><i class="fas fa-map-marker-alt"></i></span>
								<span class="col_event_location_right mb-0 mt-0"><?php echo esc_html($event->location) . ', ' . esc_html($event->city); ?></span>
								</p>
								<p class="col_event_location_bottom mb-0">
								<span class="icon-container"><span style="line-height: 32px;" class="dashicons dashicons-tickets-alt"></span></span>
								<span class="q_event_price mb-0 mt-0"><?php echo esc_html($event->vvk_preis); ?> €</span>
								</p>
							</div>
							</div>
							<div class="q_event_systems q_event_systems_mbl">
							<?php if ($event->vvk_sys1 && $event->vvk_sys1_link) { ?>
								<a class="button button-primary" href="<?php echo esc_url($event->vvk_sys1_link); ?>"><?php echo esc_html($event->vvk_sys1); ?></a>
							<?php }
							if ($event->vvk_sys2 && $event->vvk_sys2_link) { ?>
								<a class="button button-primary" href="<?php echo esc_url($event->vvk_sys2_link); ?>"><?php echo esc_html($event->vvk_sys2); ?></a>
							<?php } ?>
							</div>
						</div>
						</div>
					</div>
					<div class="q_mbl_hide q_event_location">
						<i class="fas fa-map-marker-alt"></i>
						<p class="mb-0 mt-0 q_event_location_name"><?php echo esc_html($event->location); ?>,</p>
						<p class="mb-0 mt-0 q_event_city"><?php echo esc_html($event->city); ?></p>
					</div>
					<div class="q_mbl_hide q_event_ticket">
						<span class="dashicons dashicons-tickets-alt"></span>
						<p class="q_event_price mb-0"><?php echo esc_html($event->vvk_preis); ?> €</p>
						<div class="q_event_systems">

						<?php if ($event->vvk_sys1 && $event->vvk_sys1_link) { ?>
							<a class="button button-primary" href="<?php echo esc_url($event->vvk_sys1_link); ?>"><?php echo esc_html($event->vvk_sys1); ?></a>
						<?php }
						if ($event->vvk_sys2 && $event->vvk_sys2_link) { ?>
							<a class="button button-primary" href="<?php echo esc_url($event->vvk_sys2_link); ?>"><?php echo esc_html($event->vvk_sys2); ?></a>
						<?php } ?>
						</div>
					</div>
					</div>

				<?php
				}
			}
			?>
			</div>
		<?php
			return ob_get_clean();
		}
	} // end class
}  // endif class exists