<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       qanuk.io
 * @since      1.0.0
 *
 * @package    Events
 * @subpackage Events/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Events
 * @subpackage Events/includes
 * @author     qanuk.io <support@qanuk.io> - in cooperation with <deftcoders@gmail.com>
 */

if ( ! class_exists( 'QELI_Events_i18n' ) ) {  
	class QELI_Events_i18n {


		/**
		 * Load the plugin text domain for translation.
		 *
		 * @since    1.0.0
		 */
		public function load_plugin_textdomain() {

			load_plugin_textdomain(
				'Ev',
				false,
				dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages'
			);

		}



	} // end class
} // endif class exists