<?php

/**
 * Fired during plugin activation
 *
 * @link       qanuk.io
 * @since      1.0.0
 *
 * @package    Events
 * @subpackage Events/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Events
 * @subpackage Events/includes
 * @author     qanuk.io <support@qanuk.io> - in cooperation with <deftcoders@gmail.com>
 */

if ( ! class_exists( 'QELI_Events_Activator' ) ) {  
  class QELI_Events_Activator
  {

    private $table_event;

    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.0.0
     */
    public static function activate()
    {
      $this_object = new self;

      $this_object->define_table_names();
      $this_object->events_create_db_event();
    }

    private function define_table_names()
    {
      require_once plugin_dir_path(__FILE__) . 'class-constants.php';
      global $wpdb;

      $this->table_event = $wpdb->prefix . QELI_Events_Constants::table_event;
    }

    /**
     * Creates Event database table
     */
    private function events_create_db_event()
    {
      global $wpdb;
      $charset_collate = $wpdb->get_charset_collate();
      $table_name = $this->table_event;

      $sql = "CREATE TABLE $table_name (
        id int(12) NOT NULL AUTO_INCREMENT,
        `show` varchar(256) NOT NULL,
        untertitel varchar(256) NOT NULL,
        comment text,
        location varchar(256) NOT NULL,
        city varchar(64) NOT NULL,
        fb_link varchar(256),
        event_date varchar(10),
        event_time varchar(12),
        picture int(12),
        vvk_preis varchar(16),
        vvk_sys1 varchar(12),
        vvk_sys1_link varchar(256),
        vvk_sys2 varchar(12),
        vvk_sys2_link varchar(256),
        verlegen int(1),
        new_date varchar(10),
        status int(1),
        PRIMARY KEY  (id)
      ) $charset_collate;";

      require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
      dbDelta($sql);
    }
  } // end class
} // endif class exists