<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              qanuk.io
 * @since             1.0.0
 * @package           Events
 *
 * @wordpress-plugin
 * Plugin Name:       Q Events Light
 * Plugin URI:        qanuk.io
 * Description:       The Light Version of Q Events - simple publishing of events. More features on www.qanuk.io
 * Version:           1.0.1
 * Author:            qanuk.io
 * Author URI:        qanuk.io
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       q-events-light
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
  die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('EVENTS_VERSION', '1.0.1');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-events-activator.php
 */
if ( ! function_exists( 'qeli_activate_events_light' ) ) {
  function qeli_activate_events_light()
  {
    require_once plugin_dir_path(__FILE__) . 'includes/class-events-activator.php';
    if ( class_exists( 'QELI_Events_Activator' ) ) { 
      QELI_Events_Activator::activate();
    }
  }
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-events-deactivator.php
 */
if ( ! function_exists( 'qeli_deactivate_events_light' ) ) {
  function qeli_deactivate_events_light()
  {
    require_once plugin_dir_path(__FILE__) . 'includes/class-events-deactivator.php';
    if ( class_exists( 'QELI_Events_Deactivator' ) ) { 
      QELI_Events_Deactivator::deactivate();
    }
  }
}

register_activation_hook(__FILE__, 'qeli_activate_events_light');
register_deactivation_hook(__FILE__, 'qeli_deactivate_events_light');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-events.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
if ( ! function_exists( 'qeli_run_events_light' ) ) {
  function qeli_run_events_light()
  {
    if ( class_exists( 'QELI_Events' ) ) { 
      $plugin = new QELI_Events();
      $plugin->run();
    }
  }
}

if ( function_exists( 'qeli_run_events_light' ) ) {
  qeli_run_events_light();
}