<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       qanuk.io
 * @since      1.0.0
 *
 * @package    Events
 * @subpackage Events/admin/partials
 */

require_once plugin_dir_path(__FILE__) . '../../includes/class-constants.php';
?>

<div class="milan-events-page events-page">
  <!-- This file should primarily consist of HTML with a little bit of PHP. -->
  <h1 class="headerline">
	<img id="img_snowflake" src="<?php echo esc_url(plugins_url( '../img/qanuk_snowflake.png', __FILE__)); ?>">   
	<span class="page_title"><?php _e('Upgrade to Q Events Pro', 'Ev'); ?></span>  
  </h1>
  <div class="page_content">  
    <div class="content_wrapper_upgrade">
		<h1><?php _e('Unlock more features!', 'Ev'); ?></h1>
		<span><?php _e('You can get more possibilities with our <em><a href="https://www.qanuk.io/plugins/" target="_blanket">Pro-Version</a></em> to plan, organize and track your events!', 'Ev'); ?></span>
		  
		<!-- Zeile 1 -->
		
		<div class="qanuk_spacer"></div>
		<div id="qanuk_upgrade_to_pro_page_wrapper">
			
			<div class="wp-block-column upsell">
				<!--<div class="header_image_loc"></div>-->
				<div class="qanuk-block-title">
					<img src="<?php _e(plugins_url( '../icons/q_events.svg', __FILE__), 'Ev'); ?>" alt="Events" class="q_icon"> 
					<div class="qanuk-block-title-header">
						<h2><?php _e('Event- & Time Planning', 'Ev'); ?></h2>
					</div>
				</div>
				
				<div class="q_list">
					<?php _e('
					<ul>
						<li>Detailled planning of all dates</li>
						<li>Optimized creation and simple cloning of dates</li>
						<li>Three different layouts for your website</li>
						<li>Eye-catching presentation of events when moved and changed</li>
						<li>More Detail Settings per event</li>
					</ul>', 'Ev'); ?>
				</div>
				<div class="q_upsell_button">
					<a class="wp-block-column button-upgrade" href="https://www.qanuk.io/plugins" target="_blank"><span><?php _e('Upgrade', 'Ev'); ?></span></a>
				</div>
			</div>
			
			<div class="wp-block-column upsell">
				<!--<div class="header_image_em"></div>-->
				<div class="qanuk-block-title">
					<img src="<?php _e(plugins_url( '../icons/q_artist.svg', __FILE__), 'Ev'); ?>" alt="Künstler" class="q_icon">
					<div class="qanuk-block-title-header">
						<h2><?php _e('Artist Management', 'Ev'); ?></h2>
					</div>
				</div>
				<div class="q_list">
					<?php _e('
					<ul>
						<li>Managing of all artists and concerts in one place</li>
						<li>Assingnment of agencies per artist</li>
						<li>Central management of all dates and options</li>
						<li>Creation of different programs and tour titles</li>
						<li>Use of an image per program for several events / dates </li>
						<li>Sorting all artist and concerts via genre and types</li>
					</ul>', 'Ev'); ?>
				</div>
				<div class="q_upsell_button">
					<a class="wp-block-column button-upgrade" href="https://www.qanuk.io/plugins" target="_blank"><span><?php _e('Upgrade', 'Ev'); ?></span></a>
				</div>
			</div>
	
			<!-- Zeile 2 -->
			<div class="wp-block-columns">
			
			<div class="wp-block-column upsell">
				<div class="qanuk-block-title">
					<img src="<?php _e(plugins_url( '../icons/q_location.svg', __FILE__), 'Ev'); ?>" alt="Location" class="q_icon"> 
					<div class="qanuk-block-title-header">
						<h2><?php _e('Location Management', 'Ev'); ?></h2>
					</div>
				</div>
				<div class="q_list">
					<?php _e('
					<ul>
						<li>Management of all locations in one single point</li>
						<li>Creation and management of all rooms and their capacities</li>
						<li>Saving all contact details of your locations</li>
					</ul>', 'Ev'); ?>
				</div>
				<div class="q_upsell_button">
					<a class="wp-block-column button-upgrade" href="https://www.qanuk.io/plugins" target="_blank"><span><?php _e('Upgrade', 'Ev'); ?></span></a>
				</div>
			</div>
			
			<div class="wp-block-column upsell">
				<div class="qanuk-block-title">
					<img src="<?php _e(plugins_url( '../icons/q_organizer.svg', __FILE__), 'Ev'); ?>" alt="Veranstalter" class="q_icon"> 
					<div class="qanuk-block-title-header">
						<h2><?php _e('Event Management', 'Ev'); ?></h2>
					</div>
				</div>
				<div class="q_list">
					<?php _e('
					<ul>
						<li>Full control of all organizers (event managers)</li>
						<li>Organizing all contact information of the event managers</li>
						<li>Assignment of the organizer per event</li>
					</ul>', 'Ev'); ?>
				</div>
				<div class="q_upsell_button">
					<a class="wp-block-column button-upgrade" href="https://www.qanuk.io/plugins" target="_blank"><span><?php _e('Upgrade', 'Ev'); ?></span></a>
				</div>
			</div>
		</div>	
			
		
		<!-- Zeile 3 -->
		<div class="wp-block-columns">
			<div class="wp-block-column upsell">
				<!--<div class="header_image_loc"></div>-->
				
				<div class="qanuk-block-title">
					<img src="<?php _e(plugins_url( '../icons/q_frontend.svg', __FILE__), 'Ev'); ?>" alt="Frontend" class="q_icon"> 
					<div class="qanuk-block-title-header">
						<h2><?php _e('Front-End Layouts', 'Ev'); ?></h2>
					</div>
				</div>

				<div class="q_list">
					<?php _e('
					<ul>
						<li> 3 different layouts per requirement</li>
						<ul>
							<li>Grid-Layout with bigger pictures</li>
							<li>List with pictures</li>
							<li>List without pictures (ideally for artists and bands)</li>
						</ul>
						<li>Disruptors for postponements / cancellations / change of locations</li>
						<li>Links to you ticket shop</li>
						<li>Link to facebook event</li>
					</ul>', 'Ev'); ?>
				</div>
				<div class="q_upsell_button">
					<a class="wp-block-column button-upgrade" href="https://www.qanuk.io/plugins" target="_blank"><span><?php _e('Upgrade', 'Ev'); ?></span></a>
				</div>
			</div>
			
			<div class="wp-block-column upsell">
				<!--<div class="header_image_em"></div>-->
				
				<div class="qanuk-block-title">
					<img src="<?php _e(plugins_url( '../icons/q_dsgvo.svg', __FILE__), 'Ev'); ?>" alt="Data Protection" class="q_icon"> 
					<div class="qanuk-block-title-header">
						<h2><?php _e('Data Protection', 'Ev'); ?></h2>
					</div>
				</div>
				
				<div class="q_list">
					<?php _e('
					<ul>
						<li>Data Protection is important to us!</li>
						<li>Encryption of all data on your database!</li>
						<li>Encryption only possible with the Encryption-Key</li>
					</ul>', 'Ev'); ?>
				</div>
				<div class="q_upsell_button">
					<a class="wp-block-column button-upgrade" href="https://www.qanuk.io/plugins" target="_blank"><span><?php _e('Upgrade', 'Ev'); ?></span></a>
				</div>
			</div>
		</div>	
		</div>
		<div class="qanuk_spacer"></div>
  	</div>
</div>


<!--<div id="sc_q_right"><?php //_e('by <a href="https://www.qanuk.io">qanuk.io</a>', 'Ev'); ?></div>-->
</div>