<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       qanuk.io
 * @since      1.0.0
 *
 * @package    Events
 * @subpackage Events/admin/partials
 */

require_once plugin_dir_path(__FILE__) . '../../includes/class-constants.php';
?>

<div class="milan-events-page events-page">
  <!-- This file should primarily consist of HTML with a little bit of PHP. -->
  
  <h1 class="headerline">
    <img id="img_snowflake" src="<?php echo esc_url(plugins_url( '../img/qanuk_snowflake.png', __FILE__)); ?>"> 
	<span id="qanuk_title"><?php _e('Q EVENTS by qanuk.io', 'Ev'); ?></span>
	<span id="qanuk_title_media"><?php _e('Q', 'Ev'); ?></span>
    <span class="add_new_button">
      <input type="button" name="add_new" value="<?php _e('Add new Event', 'Ev'); ?>" id="new_event" class="button button-primary new_item new_event">
    </span>
  </h1>
  
  
  <div class="page_content">
    <div class="tab">
      <button class="tablinks" data-tab-target="Aktuell" id="defaultOpen"><?php _e('Actual', 'Ev'); ?></button>
      <button class="tablinks" data-tab-target="Geplant"><?php _e('Planned', 'Ev'); ?></button>
      <button class="tablinks" data-tab-target="Archiv"><?php _e('Archive', 'Ev'); ?></button>
    </div>

    <div class="tab_content_wrapper">
      <div id="Aktuell" class="tabcontent">
        <?php

        // Get events
        global $wpdb;
        $table_name = $wpdb->prefix . QELI_Events_Constants::table_event;
        $events = $wpdb->get_results("SELECT * FROM $table_name ORDER BY STR_TO_DATE(event_date, '%Y-%m-%d') ASC");

        // Check if any term exists
        if (!empty($events) && is_array($events)) { ?>
          <table class="wp-list-table widefat fixed striped tags">
            <thead>
              <tr>
                <th scope="col" id="datum" class="manage-column ninety_col column-datum sortable desc "><?php _e('Date', 'Ev'); ?></th>
                <th scope="col" id="event" class="manage-column threehundred_col column-event"><?php _e('Event', 'Ev'); ?></th>
                <th scope="col" id="location" class="manage-column hundred_col column-location"><?php _e('Location', 'Ev'); ?></th>
                <th scope="col" id="uhrzeit" class="manage-column eighty_col column-uhrzeit"><?php _e('Time', 'Ev'); ?></th>
                <th scope="col" id="vvk-preis" class="manage-column eighty_col column-vvk-preis"><?php _e('Ticket Price', 'Ev'); ?></th>
                <th scope="col" id="status" class="manage-column fifty_col column-status"><?php _e('Status', 'Ev'); ?></th>
                <th scope="col" id="bearbeiten" class="manage-column eighty_col column-bearbeiten "><?php _e('Edit', 'Ev'); ?></th>
              </tr>
            </thead>
            <?php foreach ($events as $event) {
              $id = $event->id;
              $today = (new DateTime())->format('Y-m-d');
              $difference = strtotime($today) - strtotime($event->event_date);
              $is_in_future = $difference <= 0 || ($event->verlegen && $difference <= 0);
              if ($event->status == 1 && $is_in_future) {
            ?>
                <tr>
                  <td class="manage-column eighty_col column-bearbeiten"> <?php $date = date_create($event->event_date);
                        echo date_format($date, "d.m.Y"); ?></td>
                  <td><?php echo $event->show ? esc_html($event->show) : ''; ?> </td>
                  <td> <?php echo $event->location ? esc_html($event->location) : ''; ?></td>
                  <td class="manage-column eighty_col column-bearbeiten"> <?php echo $event->event_time ? esc_html($event->event_time) : ''; ?> Uhr</td>
                  <td class="manage-column eighty_col column-bearbeiten"> <?php echo $event->vvk_preis ? esc_html($event->vvk_preis) : ''; ?> €</td>
                  <td class="manage-column fifty_col aktiv column-bearbeiten"> <?php echo 'Active'; ?></td>
                  <td class="manage-column eighty_col column-bearbeiten">
                    <a href="javascript:void(0)" class="bearbeiten" id="<?php echo esc_attr($id); ?>" title="edit"><i class="fas fa-pencil-alt"></i></a>
                    <a href="javascript:void(0)" class="loschen" id="<?php echo esc_attr($id); ?>" title="delete"><i class="fas fa-trash"></i></a>
                  </td>
                </tr>
            <?php }
            } ?>
          </table>
        <?php } ?>
      </div>

      <div id="Geplant" class="tabcontent">
        <?php

        // Check if any term exists
        if (!empty($events) && is_array($events)) { ?>
          <table class="wp-list-table widefat fixed striped tags">
            <thead>
              <tr>
                <th scope="col" id="datum" class="manage-column ninety_col column-datum sortable desc "><?php _e('Date', 'Ev'); ?></th>
                <th scope="col" id="event" class="manage-column threehundred_col column-event"><?php _e('Event', 'Ev'); ?></th>
                <th scope="col" id="location" class="manage-column hundred_col column-location"><?php _e('Location', 'Ev'); ?></th>
                <th scope="col" id="uhrzeit" class="manage-column eighty_col column-uhrzeit"><?php _e('Time', 'Ev'); ?></th>
                <th scope="col" id="vvk-preis" class="manage-column eighty_col column-vvk-preis"><?php _e('Ticket Price', 'Ev'); ?></th>
                <th scope="col" id="status" class="manage-column fifty_col column-status"><?php _e('Status', 'Ev'); ?></th>
                <th scope="col" id="bearbeiten" class="manage-column eighty_col column-bearbeiten "><?php _e('Edit', 'Ev'); ?></th>
              </tr>
            </thead>
            <?php 
			  // planned Events
			  foreach ($events as $event) {
              $id = $event->id;
              $today = (new DateTime())->format('Y-m-d');
              $difference = strtotime($today) - strtotime($event->event_date);
              $is_in_future = $difference <= 0 || ($event->verlegen && $difference <= 0);
              if ($event->status == 0 && $is_in_future) {
            ?>
                <tr>
                  <td class="manage-column ninety_col column-bearbeiten"> <?php $date = date_create($event->event_date);
                        echo date_format($date, "d.m.Y"); ?></td>
                  <td><?php echo $event->show ? esc_html($event->show) : ''; ?> </td>
                  <td> <?php echo $event->location ? esc_html($event->location) : ''; ?></td>
                  <td class="manage-column eighty_col column-bearbeiten"> <?php echo $event->event_time ? esc_html($event->event_time) : ''; ?> Uhr</td>
                  <td class="manage-column eighty_col column-bearbeiten"> <?php echo $event->vvk_preis ? esc_html($event->vvk_preis) : ''; ?> €</td>
                  <td class="manage-column fifty_col geplant column-bearbeiten"> <?php echo 'Aktiv'; ?></td>
                  <td class="manage-column eighty_col column-bearbeiten">
                    <a href="javascript:void(0)" class="bearbeiten" id="<?php echo esc_attr($id); ?>" title="bearbeiten"><i class="fas fa-pencil-alt"></i></a>
                    <a href="javascript:void(0)" class="loschen" id="<?php echo esc_attr($id); ?>" title="loschen"><i class="fas fa-trash"></i></a>
                  </td>
                </tr>
            <?php }
            } ?>
          </table>
        <?php } ?>
      </div>

      <div id="Archiv" class="tabcontent">
        <?php

        // Check if any term exists
        if (!empty($events) && is_array($events)) { ?>
          <table class="wp-list-table widefat fixed striped tags">
            <thead>
              <tr>
                <th scope="col" id="datum" class="manage-column ninety_col column-datum sortable desc "><?php _e('Date', 'Ev'); ?></th>
                <th scope="col" id="event" class="manage-column threehundred_col column-event"><?php _e('Event', 'Ev'); ?></th>
                <th scope="col" id="location" class="manage-column hundred_col column-location"><?php _e('Location', 'Ev'); ?></th>
                <th scope="col" id="uhrzeit" class="manage-column eighty_col column-uhrzeit"><?php _e('Time', 'Ev'); ?></th>
                <th scope="col" id="vvk-preis" class="manage-column eighty_col column-vvk-preis"><?php _e('Ticket Price', 'Ev'); ?></th>
                <th scope="col" id="status" class="manage-column fifty_col column-status"><?php _e('Status', 'Ev'); ?></th>
                <th scope="col" id="bearbeiten" class="manage-column eighty_col column-bearbeiten "><?php _e('Edit', 'Ev'); ?></th>
              </tr>
            </thead>
            <?php 
			  // Archive Output
			  foreach ($events as $event) {
              $id = $event->id;
              $today = (new DateTime())->format('Y-m-d');
              $difference = strtotime($today) - strtotime($event->event_date);
              $is_in_future = $difference <= 0 || ($event->verlegen && $difference <= 0);
              if ($event->status == 0 && !$is_in_future) {
            ?>
                <tr>
                  <td class="manage-column ninety_col column-bearbeiten"> <?php $date = date_create($event->event_date);
                        echo date_format($date, "d.m.Y"); ?></td>
                  <td><?php echo $event->show ? esc_html($event->show) : ''; ?> </td>
                  <td> <?php echo $event->location ? esc_html($event->location) : ''; ?></td>
                  <td class="manage-column eighty_col column-bearbeiten"> <?php echo $event->event_time ? esc_html($event->event_time) : ''; ?> Uhr</td>
                  <td class="manage-column eighty_col column-bearbeiten"> <?php echo $event->vvk_preis ? esc_html($event->vvk_preis) : ''; ?> €</td>
                  <td class="manage-column fifty_col archiv column-bearbeiten"> <?php echo 'Active'; ?></td>
                  <td class="manage-column eighty_col column-bearbeiten">
                    <a href="javascript:void(0)" class="bearbeiten" id="<?php echo esc_attr($id); ?>" title="Edit"><i class="fas fa-pencil-alt"></i></a>
                    <a href="javascript:void(0)" class="loschen" id="<?php echo esc_attr($id); ?>" title="Delete"><i class="fas fa-trash"></i></a>
                  </td>
                </tr>
            <?php }
            } ?>
          </table>
        <?php } ?>
      </div>
    </div>
  </div>
  <div id="sc_q"><?php _e('Shortcode: [q_events]', 'Ev'); ?></div>
  <!--<div id="sc_q_right"><?php //_e('by <a href="https://www.qanuk.io">qanuk.io</a>', 'Ev'); ?></div>-->

  <script>
    jQuery(document).ready(function() {
      const tabcontent = jQuery(".tabcontent");
      const tablinks = jQuery(".tablinks");

      tabcontent.hide();

      tablinks.on('click', function(e) {
        const button = jQuery(this);
        const target = button.data('tab-target');

        button.addClass('active').siblings().removeClass('active');
        jQuery(`#${target}`).show().siblings().hide();
      });

      jQuery('#defaultOpen').click();
    });
  </script>
  <div class="col-wrap form_wrapper event_wrapper">
    <div class="form-wrap" id="add_event_wrapper">
      <h2>New Event</h2>
      <form name="add_event" class="add_form" id="add_event" method="POST">
        <table>
          <tr class="form-field">
            <th scope="row"><label for="show"><?php _e('Event-Name', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="show" id="show" value="" required>
            </td>
          </tr>

          <tr class="form-field">
            <th scope="row"><label for="untertitel"><?php _e('Subtitle', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="untertitel" id="untertitel" value="">
            </td>
          </tr>

          <tr class="form-field">
            <th scope="row"><label for="event_date"><?php _e('Date', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="event_date" class="datepicker event_date" value="" required autocomplete="off"> <span style="margin-left:8px;"><input type="text" name="event_time" class="timepicker event_time" value="" autocomplete="off"></span>
            </td>
          </tr>

          <!--<tr class="form-field">
            <th scope="row"><label for="event_time"><?php _e('time', 'Ev'); ?></label></th>
            <td>
              
            </td>
          </tr>-->

          <tr class="form-field">
            <th scope="row"><label for="comment"><?php _e('Comment', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="comment" id="comment" value="">
            </td>
          </tr>

          <tr class="form-field">
            <th scope="row"><label for="location"><?php _e('Location', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="location" id="location" value="" required>
            </td>
          </tr>

          <tr class="form-field">
            <th scope="row"><label for="city"><?php _e('City', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="city" id="city" value="" required>
            </td>
          </tr>

          <tr class="form-field">
            <th scope="row" style="vertical-align:top"><label for="picture"><?php _e('Picture', 'Ev'); ?></label></th>
            <td>
			  <!--  <a href="#" class="qanuk_remove_image"></a> -->
			        <span id="picture_remove" class="qanuk_remove_image"></span>
              <span id="picture_preview"></span>
              <input type="button" class="button button-primary button-picture" value="Select">
              <input type="text" name="picture" id="picture">			
            </td>
          </tr>

          <tr class="form-field">
            <th scope="row"><label for="vvk_preis"><?php _e('Ticket Price', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="vvk_preis" id="vvk_preis" value="" maxlength="7">
            </td>
          </tr>

          <tr class="form-field">
            <th scope="row"><label for="vvk_sys1"><?php _e('Ticket-System', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="vvk_sys1" id="vvk_sys1" value="" maxlength="12">
              <input type="text" name="vvk_sys1_link" id="vvk_sys1_link" value="">
            </td>
          </tr>

          <!-- <tr class="form-field">
            <th scope="row"><label for="vvk_sys2"><?php _e('VVK-System 2', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="vvk_sys2" id="vvk_sys2" value="" maxlength="12">
              <input type="text" name="vvk_sys2_link" id="vvk_sys2_link" value="">
            </td>
          </tr>

          <tr class="form-field">
            <th scope="row"><label for="verlegen"><?php _e('Moved', 'Ev'); ?></label></th>
            <td>
              <label class="switch large">
                <input type="checkbox" name="verlegen" id="verlegen" value="1">
                <span class="slider round"></span>
              </label>
            </td>
          </tr>

          <tr class="form-field new_date_row">
            <th scope="row"><label for="new_date"><?php _e('Moved', 'Ev'); ?></label></th>
            <td>
              <input type="text" name="new_date" class="datepicker new_date" value="" autocomplete="off">
            </td>
          </tr> -->

          <tr class="form-field">
            <th scope="row"><label for="status"><?php _e('Status', 'Ev'); ?></label></th>
            <td>
              <label class="switch large">
                <input type="checkbox" name="status" id="status" value="1" checked>
                <span class="slider round"></span>
              </label>
            </td>
          </tr>

        </table>
        <p class="submit">
          <input type="submit" name="submit" id="submit" class="button button-primary button-submit add_event" value="<?php _e('Insert', 'Ev'); ?>">
          <input type="button" name="submit" id="Zuruck" class="button button-primary button-close event_close" value="<?php _e('Back', 'Ev'); ?>">
        </p>
      </form>
    </div>
  </div>
  <div class="col-wrap form_wrapper edit-form" id="edit-event">
    <div class="form-wrap">
      <h2>
        <span class="page_title"><?php _e('Update Event', 'Ev'); ?></span>
        <!-- <span class="add_new_button">
          <input type="button" name="clone_new" value="<?php _e('Clone Event', 'Ev'); ?>" id="clone_event" class="button button-primary clone_item clone_event">
        </span> -->
      </h2>
      <form name="update_event" class="update_form" id="update_event" method="POST"></form>
    </div>
  </div>