<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       qanuk.io
 * @since      1.0.0
 *
 * @package    Events
 * @subpackage Events/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Events
 * @subpackage Events/admin
 * @author     qanuk.io <support@qanuk.io> - in cooperation with <deftcoders@gmail.com>
 */
require_once plugin_dir_path(__FILE__) . '../includes/class-constants.php';


/**
 *
 * Add special Color to "upgrade to pro" 
 *
 */
if ( ! function_exists( 'qeli_css_style' ) ) {
  function qeli_css_style() {
      wp_enqueue_style('my-admin-style', get_stylesheet_directory_uri() . '/css/events_admin.css');
  }
}
add_action('admin_enqueue_scripts', 'qeli_css_style');

if ( ! class_exists( 'QELI_Events_Admin' ) ) {
  class QELI_Events_Admin
  {

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version)
    {

      $this->plugin_name = $plugin_name;
      $this->version = $version;
    }

    /**
     * Register the stylesheets for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_styles()
    {

      /**
       * This function is provided for demonstration purposes only.
       *
       * An instance of this class should be passed to the run() function
       * defined in QELI_Events_Loader as all of the hooks are defined
       * in that particular class.
       *
       * The QELI_Events_Loader will then create the relationship
       * between the defined hooks and the functions defined in this
       * class.
       */

      wp_enqueue_style('q-jquery-ui', plugin_dir_url(__FILE__) . 'css/jquery-ui/jquery-ui.css', array(), $this->version, 'all');
      wp_enqueue_style('q-mtimepicker', plugin_dir_url(__FILE__) . 'css/timepicker/mtimepicker.css', array(), $this->version, 'all');
      wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/events-admin.css', array(), $this->version, 'all');
      wp_enqueue_style($this->plugin_name . '-font-awesome', plugin_dir_url(__FILE__) . 'css/font-awesome/css/all.css');
    }

    /**
     * Register the JavaScript for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts()
    {

      /**
       * This function is provided for demonstration purposes only.
       *
       * An instance of this class should be passed to the run() function
       * defined in QELI_Events_Loader as all of the hooks are defined
       * in that particular class.
       *
       * The QELI_Events_Loader will then create the relationship
       * between the defined hooks and the functions defined in this
       * class.
       */

      wp_enqueue_script( 'jquery-ui-datepicker' );
      wp_enqueue_script('q-mtimepicker', plugin_dir_url(__FILE__) . 'js/mtimepicker.js', array('jquery',), $this->version, false);
      wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/events-admin.js', array('jquery'), $this->version, false);
      wp_localize_script($this->plugin_name, 'events', array('ajax_url' => admin_url('admin-ajax.php')));
      wp_enqueue_media();
    }

    
    public function add_event_admin_menus()
    {
      /*add_menu_page(
        'Q Events',
        'Q Events',
        'manage_options',
        'q_events',
        array($this, 'load_events_page_content'),
        'dashicons-tickets-alt',
        25
      );*/
    
    // 05.11. Added by Daniel
    add_menu_page(
        __('Q Events', 'Ev'),
        __('Q Events', 'Ev'),
        'manage_options',
        'q_events',
        array($this, 'load_events_page_content'),
        'dashicons-tickets-alt',
        25
      );
      
    add_submenu_page(
        'q_events',
        __('Events', 'Ev'),
        __('Events', 'Ev'),
        'manage_options',
        'q_events',
        array($this, 'load_events_page_content')
      );

      add_submenu_page(
        'q_events',
        __('Upgrade to PRO', 'Ev'),
        __('Upgrade to PRO', 'Ev'),
        'manage_options',
        'q_upgrade',
        array($this, 'load_upgrade_page_content')
      );
    }
    
    

    // Load the plugin events page partial.
    public function load_events_page_content()
    {
      require_once plugin_dir_path(__FILE__) . 'partials/events-admin-display.php';
    }
    
    // 05.11. Added by Daniel
    // Load the plugin Update 2 PRO page partial.
    public function load_upgrade_page_content()
    {
      require_once plugin_dir_path(__FILE__) . 'partials/events-admin-upgrade.php';
    }

    public function add_event()
    {
      global $wpdb;

      $data = array();

      foreach ($_REQUEST['data'] as $val) {
        $data[sanitize_key($val['name'])] = sanitize_text_field($val['value']);
      }

      $table_name = $wpdb->prefix . QELI_Events_Constants::table_event;

      $result = $wpdb->insert($table_name, $data);
      $lastId = $wpdb->insert_id;

      if ($result) {
        echo json_encode(array('status' => 'success', 'id' => $lastId));
      } else {
        echo json_encode(array('status' => 'false', 'error' => $wpdb->last_error));
      }
      exit;
    }

    public function get_event_details()
    {
      global $wpdb;

      $id = sanitize_key($_REQUEST['id']);
      $table_name = $wpdb->prefix . QELI_Events_Constants::table_event;

      $sql = "SELECT * FROM $table_name WHERE id=$id LIMIT 1";
      $query = $wpdb->prepare($sql);
      $result = $wpdb->get_results($query);

      if ($result && $result[0]->picture) {
        $result[0]->picture_url = wp_get_attachment_url($result[0]->picture);
      }

      echo json_encode($result);
      exit;
    }

    public function update_event()
    {
      global $wpdb;

      $id = sanitize_key($_REQUEST['id']);
      $data = array();

      foreach ($_REQUEST['data'] as $val) {
        if (sanitize_key($val['name']) == "id") continue;

        $data[sanitize_key($val['name'])] = sanitize_text_field($val['value']);
      }

      $table_name = $wpdb->prefix . QELI_Events_Constants::table_event;

      $result = $wpdb->update($table_name, $data, array('id' => $id));

      if ($result) {
        echo json_encode(array('status' => 'success'));
      } else {
        echo json_encode(array('status' => 'false', 'error' => $wpdb->last_error));
      }
      exit;
    }

    public function update_event_status()
    {
      global $wpdb;

      $id = sanitize_key($_REQUEST['id']);
      $status = sanitize_key($_REQUEST['status']);
      $table_name = $wpdb->prefix . QELI_Events_Constants::table_event;

      $result = $wpdb->update($table_name, array('status' => $status), array('id' => $id));

      if ($result) {
        echo json_encode(array('status' => 'success'));
      } else {
        echo json_encode(array('status' => 'false', 'error' => $wpdb->last_error));
      }
      exit;
    }

    public function delete_event()
    {
      global $wpdb;

      $id = sanitize_key($_REQUEST['id']);
      $table_name = $wpdb->prefix . QELI_Events_Constants::table_event;

      $result = $wpdb->delete($table_name, array('id' => $id));

      if ($result) {
        echo json_encode(array('status' => 'success'));
      } else {
        echo json_encode(array('status' => 'false', 'error' => $wpdb->last_error));
      }
      exit;
    }
  } // end class
}  // endif class exists