<?php

namespace PaymentPlugins\WooCommerce\PPCP\Utilities;

/**
 * @since 1.1.2
 */
class MessageUtils {

	public static function get_process_code_message( $code ) {
		$processor_response_codes = [
			'0000' => __( 'Approved', 'pymntpl-paypal-woocommerce' ),
			'00N7' => __( 'CVV2 failure. Please try again with the correct CVV.', 'pymntpl-paypal-woocommerce' ),
			'0100' => __( 'Referral required. Please contact your card issuer.', 'pymntpl-paypal-woocommerce' ),
			'0390' => __( 'Account not found. Please check your card details.', 'pymntpl-paypal-woocommerce' ),
			'0500' => __( 'Transaction declined. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'0580' => __( 'Unauthorized transaction. Please contact your card issuer.', 'pymntpl-paypal-woocommerce' ),
			'0800' => __( 'Bad response. Reversal required.', 'pymntpl-paypal-woocommerce' ),
			'0880' => __( 'Cryptographic failure. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'0890' => __( 'Unacceptable PIN. Please try again with the correct PIN.', 'pymntpl-paypal-woocommerce' ),
			'0960' => __( 'System malfunction. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'0R00' => __( 'Payment cancelled. Please try again or use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'1000' => __( 'Partial authorization. Please use additional payment for the remaining amount.', 'pymntpl-paypal-woocommerce' ),
			'10BR' => __( 'Issuer rejected the transaction. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'1300' => __( 'Invalid data format. Please check your payment details.', 'pymntpl-paypal-woocommerce' ),
			'1310' => __( 'Invalid amount. Please check your payment amount.', 'pymntpl-paypal-woocommerce' ),
			'1312' => __( 'Invalid transaction card issuer/acquirer. Please try another card.', 'pymntpl-paypal-woocommerce' ),
			'1317' => __( 'Invalid capture date. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'1320' => __( 'Invalid currency code. Please select a supported currency.', 'pymntpl-paypal-woocommerce' ),
			'1330' => __( 'Invalid account. Please check your card details.', 'pymntpl-paypal-woocommerce' ),
			'1335' => __( 'Invalid account for recurring payment. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'1340' => __( 'Invalid terminal. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'1350' => __( 'Invalid merchant. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'1352' => __( 'Restricted or inactive account. Please contact your card issuer.', 'pymntpl-paypal-woocommerce' ),
			'1360' => __( 'Bad processing code. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'1370' => __( 'Invalid MCC. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'1380' => __( 'Invalid expiration date. Please check your card details.', 'pymntpl-paypal-woocommerce' ),
			'1382' => __( 'Invalid card verification value. Please check your CVV.', 'pymntpl-paypal-woocommerce' ),
			'1384' => __( 'Invalid life cycle of transaction. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'1390' => __( 'Invalid order. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'1393' => __( 'Transaction cannot be completed. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'5100' => __( 'Transaction declined. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'5110' => __( 'CVV2 failure. Please check your CVV and try again.', 'pymntpl-paypal-woocommerce' ),
			'5120' => __( 'Insufficient funds. Please use another card or payment method.', 'pymntpl-paypal-woocommerce' ),
			'5130' => __( 'Invalid PIN. Please try again with the correct PIN.', 'pymntpl-paypal-woocommerce' ),
			'5135' => __( 'PIN try exceeded. Please contact your card issuer.', 'pymntpl-paypal-woocommerce' ),
			'5140' => __( 'Card closed. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'5150' => __( 'Card pickup requested. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'5160' => __( 'Unauthorized user. Please contact your card issuer.', 'pymntpl-paypal-woocommerce' ),
			'5170' => __( 'Address verification failed. Please check your billing address.', 'pymntpl-paypal-woocommerce' ),
			'5180' => __( 'Invalid or restricted card. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'5190' => __( 'Address verification soft failure. Please check your billing address.', 'pymntpl-paypal-woocommerce' ),
			'5200' => __( 'Duplicate transaction. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'5210' => __( 'Invalid transaction. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'5400' => __( 'Expired card. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'5500' => __( 'Incorrect PIN. Please re-enter your PIN.', 'pymntpl-paypal-woocommerce' ),
			'5650' => __( 'Strong customer authentication required. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'5700' => __( 'Transaction not permitted. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'5710' => __( 'Transaction attempts exceed limit. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'5800' => __( 'Reversal rejected. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'5900' => __( 'Invalid issue. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'5910' => __( 'Issuer not available. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'5920' => __( 'Issuer temporarily not available. Please try again shortly.', 'pymntpl-paypal-woocommerce' ),
			'5930' => __( 'Card not activated. Please activate your card and try again.', 'pymntpl-paypal-woocommerce' ),
			'5950' => __( 'Updated card issued. Please use your new card.', 'pymntpl-paypal-woocommerce' ),
			'6300' => __( 'Account not on file. Please check your card details.', 'pymntpl-paypal-woocommerce' ),
			'7600' => __( 'Approved but not captured. No action needed.', 'pymntpl-paypal-woocommerce' ),
			'7700' => __( '3DS authentication error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'7710' => __( 'Authentication failed. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'7800' => __( 'BIN error. Please try another card.', 'pymntpl-paypal-woocommerce' ),
			'7900' => __( 'PIN error. Please try again with the correct PIN.', 'pymntpl-paypal-woocommerce' ),
			'8000' => __( 'Processor system error. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'8010' => __( 'Host key error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'8020' => __( 'Configuration error. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'8030' => __( 'Unsupported operation. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'8100' => __( 'Communication error. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'8110' => __( 'Communication error. Please try again shortly.', 'pymntpl-paypal-woocommerce' ),
			'8220' => __( 'System unavailable. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'9100' => __( 'Transaction declined. Please retry.', 'pymntpl-paypal-woocommerce' ),
			'9500' => __( 'Suspected fraud. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'9510' => __( 'Security violation. Please contact your card issuer.', 'pymntpl-paypal-woocommerce' ),
			'9520' => __( 'Card reported lost or stolen. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'9530' => __( 'Hold - call center. Please contact your card issuer.', 'pymntpl-paypal-woocommerce' ),
			'9540' => __( 'Card refused. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'9600' => __( 'Unrecognized response code. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'PCNR' => __( 'Contingencies not resolved. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PCVV' => __( 'CVV verification failed. Please check your CVV.', 'pymntpl-paypal-woocommerce' ),
			'PP06' => __( 'Account closed. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'PPRN' => __( 'Reattempt not permitted. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPAD' => __( 'Billing address error. Please check your billing details.', 'pymntpl-paypal-woocommerce' ),
			'PPAB' => __( 'Account blocked by issuer. Please contact your card issuer.', 'pymntpl-paypal-woocommerce' ),
			'PPAE' => __( 'American Express card disabled. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'PPAG' => __( 'Adult gaming not supported. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPAI' => __( 'Amount incompatible. Please try a different amount.', 'pymntpl-paypal-woocommerce' ),
			'PPAR' => __( 'Authorization result error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPAU' => __( 'MCC code error. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'PPAV' => __( 'Address verification failed. Please check your billing address.', 'pymntpl-paypal-woocommerce' ),
			'PPAX' => __( 'Amount exceeded. Please try a smaller amount.', 'pymntpl-paypal-woocommerce' ),
			'PPBG' => __( 'Gaming transaction error. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPC2' => __( 'CVV verification failed. Please check your CVV.', 'pymntpl-paypal-woocommerce' ),
			'PPCE' => __( 'Registration incomplete. Please complete registration.', 'pymntpl-paypal-woocommerce' ),
			'PPCO' => __( 'Country error. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPCR' => __( 'Credit error. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPCT' => __( 'Card type not supported. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'PPCU' => __( 'Invalid currency. Please select a supported currency.', 'pymntpl-paypal-woocommerce' ),
			'PPD3' => __( '3D Secure authentication error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPDC' => __( 'Dynamic currency conversion not supported. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPDI' => __( 'Diners Club card rejected. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'PPDV' => __( 'Authentication message error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPDT' => __( 'Decline threshold exceeded. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'PPEF' => __( 'Funding instrument expired. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPEL' => __( 'Frequency limit exceeded. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'PPER' => __( 'System error. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'PPEX' => __( 'Expiry date error. Please check your card details.', 'pymntpl-paypal-woocommerce' ),
			'PPFE' => __( 'Funding source already exists. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPFI' => __( 'Invalid funding instrument. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPFR' => __( 'Restricted funding instrument. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPFV' => __( 'Field validation failed. Please check your payment details.', 'pymntpl-paypal-woocommerce' ),
			'PPGR' => __( 'Gaming refund error. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'PPH1' => __( 'Processing error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPIF' => __( 'Idempotency failure. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPII' => __( 'Invalid input. Please check your payment details.', 'pymntpl-paypal-woocommerce' ),
			'PPIM' => __( 'ID mismatch. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPIT' => __( 'Invalid trace ID. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPLR' => __( 'Late reversal. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'PPLS' => __( 'Status code error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPMB' => __( 'Missing business rule or data. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPMC' => __( 'Mastercard blocked. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'PPMD' => __( 'Processing error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPNC' => __( 'Not supported. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPNL' => __( 'Network frequency limit exceeded. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'PPNM' => __( 'Merchant ID not found. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'PPNT' => __( 'Network error. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'PPPH' => __( 'Phone required for this transaction. Please update your details.', 'pymntpl-paypal-woocommerce' ),
			'PPPI' => __( 'Invalid product. Please try another product.', 'pymntpl-paypal-woocommerce' ),
			'PPPM' => __( 'Invalid payment method. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPQC' => __( 'Quasi-cash not supported. Please use another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPRE' => __( 'Refund not supported on pending transactions. Please try again later.', 'pymntpl-paypal-woocommerce' ),
			'PPRF' => __( 'Invalid parent transaction status. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPRR' => __( 'Merchant not registered. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'PPS0' => __( 'Bank authorization mismatch. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPS1' => __( 'Bank authorization already settled. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPS2' => __( 'Bank authorization voided. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPS3' => __( 'Bank authorization expired. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPS4' => __( 'Currency mismatch. Please try again with the correct currency.', 'pymntpl-paypal-woocommerce' ),
			'PPS5' => __( 'Credit card mismatch. Please check your card details.', 'pymntpl-paypal-woocommerce' ),
			'PPS6' => __( 'Amount mismatch. Please try again with the correct amount.', 'pymntpl-paypal-woocommerce' ),
			'PPSC' => __( 'Score error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPSD' => __( 'Status description error. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPSE' => __( 'American Express declined. Please use another card.', 'pymntpl-paypal-woocommerce' ),
			'PPTE' => __( 'Verification token expired. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPTF' => __( 'Invalid trace reference. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPTI' => __( 'Invalid transaction ID. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPTR' => __( 'Verification token revoked. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPTT' => __( 'Transaction type not supported. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPTV' => __( 'Invalid verification token. Please try again.', 'pymntpl-paypal-woocommerce' ),
			'PPUA' => __( 'User not authorized. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'PPUC' => __( 'Currency not supported. Please select a supported currency.', 'pymntpl-paypal-woocommerce' ),
			'PPUE' => __( 'Entity not supported. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPUI' => __( 'Installment not supported. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPUP' => __( 'POS flag not supported. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
			'PPUR' => __( 'Reversal not supported. Please contact support.', 'pymntpl-paypal-woocommerce' ),
			'PPVC' => __( 'Currency validation error. Please select a supported currency.', 'pymntpl-paypal-woocommerce' ),
			'PPVE' => __( 'Validation error. Please check your payment details.', 'pymntpl-paypal-woocommerce' ),
			'PPVT' => __( 'Virtual terminal not supported. Please try another payment method.', 'pymntpl-paypal-woocommerce' ),
		];

		return apply_filters( 'wc_ppcp_get_processor_code_message', $processor_response_codes[ $code ] ?? '', $code );
	}

}