<?php
/**
 * The template for displaying single provider
 *
 * This template can be overridden by copying it to yourtheme/puntr/single-puntr_provider.php
 *
 * @package Puntr
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header(); 

// Get provider data
$provider_id = get_the_ID();
$headline = get_post_meta($provider_id, '_puntr_headline', true);
$age = get_post_meta($provider_id, '_puntr_age', true);
$ethnicity = get_post_meta($provider_id, '_puntr_ethnicity', true);
$body_type = get_post_meta($provider_id, '_puntr_body_type', true);
$height = get_post_meta($provider_id, '_puntr_height_cm', true);
$weight = get_post_meta($provider_id, '_puntr_weight_kg', true);
$dress_size = get_post_meta($provider_id, '_puntr_dress_size', true);
$cup_size = get_post_meta($provider_id, '_puntr_cup_size', true);
$hair = get_post_meta($provider_id, '_puntr_hair_description', true);
$eye_color = get_post_meta($provider_id, '_puntr_eye_color', true);
$skin_tone = get_post_meta($provider_id, '_puntr_skin_tone', true);

// Get pricing
$prices = array(
    '30' => get_post_meta($provider_id, '_puntr_price_30_mins', true),
    '45' => get_post_meta($provider_id, '_puntr_price_45_mins', true),
    '60' => get_post_meta($provider_id, '_puntr_price_60_mins', true),
    '90' => get_post_meta($provider_id, '_puntr_price_90_mins', true),
    '120' => get_post_meta($provider_id, '_puntr_price_120_mins', true),
    '180' => get_post_meta($provider_id, '_puntr_price_180_mins', true)
);

// Get services
$services = wp_get_post_terms($provider_id, 'puntr_service', array('fields' => 'names'));
?>

<div class="puntr-single-wrapper">
    <?php while ( have_posts() ) : the_post(); ?>
        
        <article id="puntr_provider-<?php the_ID(); ?>" <?php post_class(); ?>>
            
            <header class="entry-header">
                <h1 class="entry-title"><?php the_title(); ?></h1>
                <?php if ($headline) : ?>
                    <p class="provider-headline"><?php echo esc_html($headline); ?></p>
                <?php endif; ?>
            </header>
            
            <div class="provider-layout">
                
                <div class="provider-main">
                    <?php
                    // Display gallery
                    do_action('puntr_before_provider_content', get_the_ID());
                    ?>
                    
                    <div class="entry-content">
                        <?php the_content(); ?>
                    </div>
                </div>
                
                <aside class="provider-sidebar">
                    
                    <!-- Quick Info -->
                    <div class="provider-info-box">
                        <h3><?php esc_html_e('Details', 'puntr'); ?></h3>
                        <dl class="provider-details">
                            <?php if ($age) : ?>
                                <dt><?php esc_html_e('Age', 'puntr'); ?></dt>
                                <dd><?php echo esc_html($age); ?></dd>
                            <?php endif; ?>
                            
                            <?php if ($ethnicity) : ?>
                                <dt><?php esc_html_e('Ethnicity', 'puntr'); ?></dt>
                                <dd><?php echo esc_html($ethnicity); ?></dd>
                            <?php endif; ?>
                            
                            <?php if ($body_type) : ?>
                                <dt><?php esc_html_e('Body Type', 'puntr'); ?></dt>
                                <dd><?php echo esc_html(ucfirst($body_type)); ?></dd>
                            <?php endif; ?>
                            
                            <?php if ($height) : ?>
                                <dt><?php esc_html_e('Height', 'puntr'); ?></dt>
                                <dd><?php echo esc_html($height); ?>cm</dd>
                            <?php endif; ?>
                            
                            <?php if ($weight) : ?>
                                <dt><?php esc_html_e('Weight', 'puntr'); ?></dt>
                                <dd><?php echo esc_html($weight); ?>kg</dd>
                            <?php endif; ?>
                            
                            <?php if ($dress_size) : ?>
                                <dt><?php esc_html_e('Dress Size', 'puntr'); ?></dt>
                                <dd><?php echo esc_html($dress_size); ?></dd>
                            <?php endif; ?>
                            
                            <?php if ($cup_size) : ?>
                                <dt><?php esc_html_e('Cup Size', 'puntr'); ?></dt>
                                <dd><?php echo esc_html($cup_size); ?></dd>
                            <?php endif; ?>
                            
                            <?php if ($hair) : ?>
                                <dt><?php esc_html_e('Hair', 'puntr'); ?></dt>
                                <dd><?php echo esc_html($hair); ?></dd>
                            <?php endif; ?>
                            
                            <?php if ($eye_color) : ?>
                                <dt><?php esc_html_e('Eyes', 'puntr'); ?></dt>
                                <dd><?php echo esc_html(ucfirst($eye_color)); ?></dd>
                            <?php endif; ?>
                            
                            <?php if ($skin_tone) : ?>
                                <dt><?php esc_html_e('Skin Tone', 'puntr'); ?></dt>
                                <dd><?php echo esc_html(ucfirst($skin_tone)); ?></dd>
                            <?php endif; ?>
                        </dl>
                    </div>
                    
                    <!-- Pricing -->
                    <?php if (array_filter($prices)) : ?>
                        <div class="provider-info-box">
                            <h3><?php esc_html_e('Rates', 'puntr'); ?></h3>
                            <table class="provider-pricing">
                                <?php foreach ($prices as $duration => $price) : ?>
                                    <?php if ($price) : ?>
                                        <tr>
                                            <td><?php echo esc_html($duration); ?> mins</td>
                                            <td>$<?php echo esc_html($price); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </table>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Services -->
                    <?php if (!empty($services) && !is_wp_error($services)) : ?>
                        <div class="provider-info-box">
                            <h3><?php esc_html_e('Services', 'puntr'); ?></h3>
                            <div class="provider-services">
                                <?php foreach ($services as $service) : ?>
                                    <span class="service-tag"><?php echo esc_html($service); ?></span>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                </aside>
                
            </div>
            
            <?php
            // Display roster below
            do_action('puntr_after_provider_content', get_the_ID());
            ?>
            
        </article>
        
    <?php endwhile; ?>
</div>

<?php get_footer(); ?>