<?php
/**
 * Template part for displaying provider in lists
 *
 * This template can be overridden by copying it to yourtheme/puntr/content-puntr_provider.php
 *
 * @package Puntr
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Get provider meta data
$provider_id = get_the_ID();
$age = get_post_meta($provider_id, '_puntr_age', true);
$ethnicity = get_post_meta($provider_id, '_puntr_ethnicity', true);
$body_type = get_post_meta($provider_id, '_puntr_body_type', true);
$height = get_post_meta($provider_id, '_puntr_height_cm', true);
$services = wp_get_post_terms($provider_id, 'puntr_service', array('fields' => 'names'));
?>

<article id="puntr_provider-<?php the_ID(); ?>" <?php post_class(); ?>>
    
    <?php if ( has_post_thumbnail() ) : ?>
        <a href="<?php the_permalink(); ?>" class="provider-thumbnail">
            <?php the_post_thumbnail('medium'); ?>
        </a>
    <?php endif; ?>
    
    <div class="provider-info">
        <h2 class="provider-name">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>
        
        <?php if ( $age || $ethnicity || $body_type || $height ) : ?>
            <div class="provider-meta">
                <?php
                $meta_items = array();
                if ($age) $meta_items[] = $age;
                if ($ethnicity) $meta_items[] = $ethnicity;
                if ($body_type) $meta_items[] = ucfirst($body_type);
                if ($height) $meta_items[] = $height . 'cm';
                echo esc_html(implode(' • ', $meta_items));
                ?>
            </div>
        <?php endif; ?>
        
        <?php if ( !empty($services) && !is_wp_error($services) ) : ?>
            <div class="provider-services">
                <?php echo esc_html(implode(', ', $services)); ?>
            </div>
        <?php endif; ?>
        
        <?php if ( has_excerpt() ) : ?>
            <div class="provider-excerpt">
                <?php the_excerpt(); ?>
            </div>
        <?php endif; ?>
    </div>
    
</article>