<?php
/**
 * The template for displaying provider archive
 *
 * This template can be overridden by copying it to yourtheme/puntr/archive-puntr_provider.php
 *
 * @package Puntr
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header(); ?>

<div class="puntr-archive-wrapper">
    <?php if ( have_posts() ) : ?>
        
        <header class="page-header">
            <h1 class="page-title"><?php post_type_archive_title(); ?></h1>
            <?php the_archive_description( '<div class="archive-description">', '</div>' ); ?>
        </header>
        
        <div class="puntr-providers-list">
            <?php while ( have_posts() ) : the_post(); ?>
                
                <?php
                // Load the provider content template
                puntr_get_template_part('content', 'puntr_provider');
                ?>
                
            <?php endwhile; ?>
        </div>
        
        <?php the_posts_navigation(); ?>
        
    <?php else : ?>
        
        <p><?php esc_html_e('No providers found.', 'puntr'); ?></p>
        
    <?php endif; ?>
</div>

<?php get_footer(); ?>