<?php
/**
 * Custom Taxonomies
 */

if (!defined('ABSPATH')) {
    exit;
}

class Puntr_Taxonomies {
    
    /**
     * Initialize taxonomies
     */
    public static function init() {
        add_action('init', array(__CLASS__, 'register_taxonomies'));
    }
    
    /**
     * Register custom taxonomies
     */
    public static function register_taxonomies() {
        // Services taxonomy
        $service_labels = array(
            'name'              => _x('Services', 'taxonomy general name', 'puntr'),
            'singular_name'     => _x('Service', 'taxonomy singular name', 'puntr'),
            'search_items'      => __('Search Services', 'puntr'),
            'all_items'         => __('All Services', 'puntr'),
            'parent_item'       => __('Parent Service', 'puntr'),
            'parent_item_colon' => __('Parent Service:', 'puntr'),
            'edit_item'         => __('Edit Service', 'puntr'),
            'update_item'       => __('Update Service', 'puntr'),
            'add_new_item'      => __('Add New Service', 'puntr'),
            'new_item_name'     => __('New Service Name', 'puntr'),
            'menu_name'         => __('Services', 'puntr'),
        );
        
        $service_args = array(
            'hierarchical'      => true,
            'labels'            => $service_labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array('slug' => 'service'),
            'show_in_rest'      => true,
        );
        
        register_taxonomy('puntr_service', array('puntr_provider'), $service_args);
    }
}