<?php
/**
 * Custom Post Types
 */

if (!defined('ABSPATH')) {
    exit;
}

class Puntr_Post_Types {
    
    /**
     * Initialize post types
     */
    public static function init() {
        add_action('init', array(__CLASS__, 'register_post_types'), 0);
        add_filter('single_template', array(__CLASS__, 'provider_single_template'));
        add_filter('archive_template', array(__CLASS__, 'provider_archive_template'));
    }
    
    /**
     * Register custom post types
     */
    public static function register_post_types() {
        // Provider post type
        $labels = array(
            'name'                  => _x('Providers', 'Post type general name', 'puntr'),
            'singular_name'         => _x('Provider', 'Post type singular name', 'puntr'),
            'menu_name'             => _x('Providers', 'Admin Menu text', 'puntr'),
            'name_admin_bar'        => _x('Provider', 'Add New on Toolbar', 'puntr'),
            'add_new'               => __('Add New', 'puntr'),
            'add_new_item'          => __('Add New Provider', 'puntr'),
            'new_item'              => __('New Provider', 'puntr'),
            'edit_item'             => __('Edit Provider', 'puntr'),
            'view_item'             => __('View Provider', 'puntr'),
            'all_items'             => __('All Providers', 'puntr'),
            'search_items'          => __('Search Providers', 'puntr'),
            'parent_item_colon'     => __('Parent Providers:', 'puntr'),
            'not_found'             => __('No providers found.', 'puntr'),
            'not_found_in_trash'    => __('No providers found in Trash.', 'puntr'),
            'featured_image'        => _x('Provider Profile Picture', 'Overrides the "Featured Image" phrase', 'puntr'),
            'set_featured_image'    => _x('Set profile picture', 'Overrides the "Set featured image" phrase', 'puntr'),
            'remove_featured_image' => _x('Remove profile picture', 'Overrides the "Remove featured image" phrase', 'puntr'),
            'use_featured_image'    => _x('Use as profile picture', 'Overrides the "Use as featured image" phrase', 'puntr'),
        );
        
        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => false, // We'll add it manually to Puntr menu
            'query_var'          => true,
            'rewrite'            => array('slug' => 'provider'),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => 20,
            'menu_icon'          => 'dashicons-groups',
            'supports'           => array('title', 'editor', 'thumbnail', 'excerpt'),
            'show_in_rest'       => true,
        );
        
        register_post_type('puntr_provider', $args);
        
        // Register Roster post type
        self::register_roster_post_type();
    }
    
    /**
     * Register Roster post type
     */
    private static function register_roster_post_type() {
        $labels = array(
            'name'                  => _x('Rosters', 'Post type general name', 'puntr'),
            'singular_name'         => _x('Roster', 'Post type singular name', 'puntr'),
            'menu_name'             => _x('Rosters', 'Admin Menu text', 'puntr'),
            'name_admin_bar'        => _x('Roster', 'Add New on Toolbar', 'puntr'),
            'add_new'               => __('Add New', 'puntr'),
            'add_new_item'          => __('Add New Roster Entry', 'puntr'),
            'new_item'              => __('New Roster Entry', 'puntr'),
            'edit_item'             => __('Edit Roster Entry', 'puntr'),
            'view_item'             => __('View Roster Entry', 'puntr'),
            'all_items'             => __('All Roster Entries', 'puntr'),
            'search_items'          => __('Search Roster Entries', 'puntr'),
            'not_found'             => __('No roster entries found.', 'puntr'),
            'not_found_in_trash'    => __('No roster entries found in Trash.', 'puntr'),
        );
        
        $args = array(
            'labels'             => $labels,
            'public'             => false,
            'publicly_queryable' => false,
            'show_ui'            => true,
            'show_in_menu'       => false, // Hide from menu
            'query_var'          => true,
            'rewrite'            => false,
            'capability_type'    => 'post',
            'has_archive'        => false,
            'hierarchical'       => false,
            'supports'           => array('title'),
            'show_in_rest'       => true,
        );
        
        register_post_type('puntr_roster', $args);
    }
    
    /**
     * Use custom template for single provider
     */
    public static function provider_single_template($template) {
        global $post;
        
        if ('puntr_provider' === $post->post_type) {
            $custom_template = PUNTR_PLUGIN_PATH . 'templates/single-puntr_provider.php';
            if (file_exists($custom_template)) {
                return $custom_template;
            }
        }
        
        return $template;
    }
    
    /**
     * Use custom template for provider archive
     */
    public static function provider_archive_template($template) {
        if (is_post_type_archive('puntr_provider')) {
            $custom_template = PUNTR_PLUGIN_PATH . 'templates/archive-puntr_provider.php';
            if (file_exists($custom_template)) {
                return $custom_template;
            }
        }
        
        return $template;
    }
}