<?php
/**
 * Hooks and Filters for Puntr plugin
 * 
 * This class defines all hooks and filters available for developers
 * to extend and customize the Puntr plugin functionality.
 */

if (!defined('ABSPATH')) {
    exit;
}

class Puntr_Hooks {
    
    /**
     * Initialize all hooks and filters
     */
    public static function init() {
        // Add hooks and filters throughout the plugin
        self::add_provider_hooks();
        self::add_roster_hooks();
        self::add_calendar_hooks();
        self::add_template_hooks();
        self::add_api_hooks();
    }
    
    /**
     * Provider-related hooks
     */
    private static function add_provider_hooks() {
        // Before/after saving provider
        add_action('puntr_before_save_provider', array(__CLASS__, 'before_save_provider'), 10, 2);
        add_action('puntr_after_save_provider', array(__CLASS__, 'after_save_provider'), 10, 2);
        
        // Provider meta fields
        add_filter('puntr_provider_meta_fields', array(__CLASS__, 'filter_provider_meta_fields'), 10, 1);
        add_filter('puntr_provider_meta_boxes', array(__CLASS__, 'filter_provider_meta_boxes'), 10, 1);
        
        // Provider display
        add_filter('puntr_provider_display_data', array(__CLASS__, 'filter_provider_display_data'), 10, 2);
        add_filter('puntr_provider_archive_columns', array(__CLASS__, 'filter_provider_archive_columns'), 10, 1);
    }
    
    /**
     * Roster-related hooks
     */
    private static function add_roster_hooks() {
        // Roster events
        add_action('puntr_before_create_roster_event', array(__CLASS__, 'before_create_roster_event'), 10, 1);
        add_action('puntr_after_create_roster_event', array(__CLASS__, 'after_create_roster_event'), 10, 2);
        
        // Roster display
        add_filter('puntr_roster_event_data', array(__CLASS__, 'filter_roster_event_data'), 10, 2);
        add_filter('puntr_roster_table_columns', array(__CLASS__, 'filter_roster_table_columns'), 10, 1);
    }
    
    /**
     * Calendar-related hooks
     */
    private static function add_calendar_hooks() {
        // Calendar events
        add_filter('puntr_calendar_event_colors', array(__CLASS__, 'filter_calendar_event_colors'), 10, 1);
        add_filter('puntr_calendar_event_text', array(__CLASS__, 'filter_calendar_event_text'), 10, 3);
        
        // Calendar settings
        add_filter('puntr_calendar_default_view', array(__CLASS__, 'filter_calendar_default_view'), 10, 1);
        add_filter('puntr_calendar_time_slots', array(__CLASS__, 'filter_calendar_time_slots'), 10, 1);
    }
    
    /**
     * Template-related hooks
     */
    private static function add_template_hooks() {
        // Template overrides
        add_filter('puntr_provider_template', array(__CLASS__, 'filter_provider_template'), 10, 1);
        add_filter('puntr_archive_template', array(__CLASS__, 'filter_archive_template'), 10, 1);
        
        // Content filters
        add_filter('puntr_provider_content', array(__CLASS__, 'filter_provider_content'), 10, 2);
        add_filter('puntr_gallery_settings', array(__CLASS__, 'filter_gallery_settings'), 10, 1);
    }
    
    /**
     * API-related hooks
     */
    private static function add_api_hooks() {
        // API endpoints
        add_filter('puntr_api_endpoints', array(__CLASS__, 'filter_api_endpoints'), 10, 1);
        add_filter('puntr_api_provider_fields', array(__CLASS__, 'filter_api_provider_fields'), 10, 1);
        
        // API authentication
        add_filter('puntr_api_authentication', array(__CLASS__, 'filter_api_authentication'), 10, 2);
    }
    
    /**
     * Example hook implementations (these do nothing by default)
     */
    public static function before_save_provider($post_id, $data) {
        // Developers can hook here to validate or modify data before saving
    }
    
    public static function after_save_provider($post_id, $data) {
        // Developers can hook here to perform actions after provider is saved
    }
    
    public static function filter_provider_meta_fields($fields) {
        // Developers can add custom meta fields
        return $fields;
    }
    
    public static function filter_provider_meta_boxes($meta_boxes) {
        // Developers can add custom meta boxes
        return $meta_boxes;
    }
    
    public static function filter_provider_display_data($data, $provider_id) {
        // Developers can modify provider display data
        return $data;
    }
    
    public static function filter_provider_archive_columns($columns) {
        // Developers can modify archive columns
        return $columns;
    }
    
    public static function before_create_roster_event($event_data) {
        // Developers can validate roster event data
    }
    
    public static function after_create_roster_event($event_id, $event_data) {
        // Developers can perform actions after roster event creation
    }
    
    public static function filter_roster_event_data($event_data, $event_id) {
        // Developers can modify roster event data
        return $event_data;
    }
    
    public static function filter_roster_table_columns($columns) {
        // Developers can modify roster table columns
        return $columns;
    }
    
    public static function filter_calendar_event_colors($colors) {
        // Developers can customize calendar event colors
        return $colors;
    }
    
    public static function filter_calendar_event_text($text, $event, $provider) {
        // Developers can customize calendar event text
        return $text;
    }
    
    public static function filter_calendar_default_view($view) {
        // Developers can change default calendar view
        return $view;
    }
    
    public static function filter_calendar_time_slots($slots) {
        // Developers can modify calendar time slots
        return $slots;
    }
    
    public static function filter_provider_template($template) {
        // Developers can override provider template
        return $template;
    }
    
    public static function filter_archive_template($template) {
        // Developers can override archive template
        return $template;
    }
    
    public static function filter_provider_content($content, $provider_id) {
        // Developers can modify provider content
        return $content;
    }
    
    public static function filter_gallery_settings($settings) {
        // Developers can modify gallery settings
        return $settings;
    }
    
    public static function filter_api_endpoints($endpoints) {
        // Developers can add custom API endpoints
        return $endpoints;
    }
    
    public static function filter_api_provider_fields($fields) {
        // Developers can modify API provider fields
        return $fields;
    }
    
    public static function filter_api_authentication($authenticated, $request) {
        // Developers can implement custom authentication
        return $authenticated;
    }
}

/**
 * Helper functions for common hook usage
 */

/**
 * Get provider meta fields
 */
function puntr_get_provider_meta_fields() {
    $fields = array(
        'headline' => '_puntr_headline',
        'gender' => '_puntr_gender',
        'sexuality' => '_puntr_sexuality',
        'age' => '_puntr_age',
        'ethnicity' => '_puntr_ethnicity',
        'language' => '_puntr_language',
        'body_type' => '_puntr_body_type',
        'cup_size' => '_puntr_cup_size',
        'height_cm' => '_puntr_height_cm',
        'weight_kg' => '_puntr_weight_kg',
        'dress_size' => '_puntr_dress_size',
        'eye_color' => '_puntr_eye_color',
        'hair_description' => '_puntr_hair_description',
        'skin_tone' => '_puntr_skin_tone',
        'price_30_mins' => '_puntr_price_30_mins',
        'price_45_mins' => '_puntr_price_45_mins',
        'price_60_mins' => '_puntr_price_60_mins',
        'price_90_mins' => '_puntr_price_90_mins',
        'price_120_mins' => '_puntr_price_120_mins',
        'price_180_mins' => '_puntr_price_180_mins',
        'min_booking_mins' => '_puntr_min_booking_mins',
        'external_url' => '_puntr_external_url',
        'photos_real' => '_puntr_photos_real',
        'is_active' => '_puntr_is_active',
        'gallery_images' => '_puntr_gallery_images'
    );
    
    return apply_filters('puntr_provider_meta_fields', $fields);
}

/**
 * Get roster event statuses
 */
function puntr_get_roster_statuses() {
    $statuses = array(
        'scheduled' => __('Scheduled', 'puntr'),
        'confirmed' => __('Confirmed', 'puntr'),
        'cancelled' => __('Cancelled', 'puntr'),
        'completed' => __('Completed', 'puntr')
    );
    
    return apply_filters('puntr_roster_statuses', $statuses);
}

/**
 * Get provider body types
 */
function puntr_get_body_types() {
    $body_types = array(
        'slim' => __('Slim', 'puntr'),
        'petite' => __('Petite', 'puntr'),
        'athletic' => __('Athletic', 'puntr'),
        'average' => __('Average', 'puntr'),
        'curvy' => __('Curvy', 'puntr'),
        'curvaceous' => __('Curvaceous', 'puntr'),
        'bbw' => __('BBW', 'puntr'),
        'muscular' => __('Muscular', 'puntr'),
        'other' => __('Other', 'puntr')
    );
    
    return apply_filters('puntr_body_types', $body_types);
}