jQuery(document).ready(function($) {
    // Frontend JavaScript for Puntr plugin
    
    // Product gallery functionality
    $('.puntr-thumb-item').on('click', function() {
        var $this = $(this);
        var newImage = $this.data('image');
        var newZoomImage = $this.data('zoom-image');
        
        // Update main image
        $('.puntr-main-image').attr('src', newImage).attr('data-zoom-image', newZoomImage);
        
        // Update active state
        $('.puntr-thumb-item').removeClass('active');
        $this.addClass('active');
    });
    
    // Lightbox for main image
    $('.puntr-main-image').on('click', function(e) {
        e.preventDefault();
        
        var imageUrl = $(this).attr('data-zoom-image') || $(this).attr('src');
        
        // Create lightbox overlay
        var $lightbox = $('<div class="puntr-lightbox-overlay">' +
            '<img src="' + imageUrl + '" alt="" />' +
            '<button class="puntr-lightbox-close">&times;</button>' +
            '</div>');
        
        // Add to body
        $('body').append($lightbox);
        
        // Show lightbox
        $lightbox.css('display', 'flex').hide().fadeIn(300);
        
        // Close on click outside image or close button
        $lightbox.on('click', function(e) {
            if (e.target === this || $(e.target).hasClass('puntr-lightbox-close')) {
                $lightbox.fadeOut(300, function() {
                    $lightbox.remove();
                });
            }
        });
        
        // Close on ESC key
        $(document).on('keyup.puntr-lightbox', function(e) {
            if (e.keyCode === 27) {
                $lightbox.fadeOut(300, function() {
                    $lightbox.remove();
                });
                $(document).off('keyup.puntr-lightbox');
            }
        });
    });
    
    // Keyboard navigation for gallery
    $(document).on('keydown', function(e) {
        if ($('.puntr-product-gallery').length) {
            var $activeThumb = $('.puntr-thumb-item.active');
            var $nextThumb = null;
            
            if (e.keyCode === 37) { // Left arrow
                $nextThumb = $activeThumb.prev('.puntr-thumb-item');
            } else if (e.keyCode === 39) { // Right arrow
                $nextThumb = $activeThumb.next('.puntr-thumb-item');
            }
            
            if ($nextThumb && $nextThumb.length) {
                $nextThumb.click();
                e.preventDefault();
            }
        }
    });
});