jQuery(document).ready(function($) {
    // Gallery functionality for Provider post type
    if ($('#puntr-gallery-images').length) {
        var frame;
        
        // Make gallery sortable
        $('#puntr-gallery-images').sortable({
            placeholder: 'gallery-placeholder',
            forcePlaceholderSize: true
        });
        
        // Add images
        $('#puntr-add-gallery-images').on('click', function(e) {
            e.preventDefault();
            
            if (frame) {
                frame.open();
                return;
            }
            
            frame = wp.media({
                title: puntrMetabox.selectGalleryImages,
                button: {
                    text: puntrMetabox.addToGallery
                },
                multiple: true
            });
            
            frame.on('select', function() {
                var attachments = frame.state().get('selection').toJSON();
                
                attachments.forEach(function(attachment) {
                    var html = '<li class="gallery-image" data-image-id="' + attachment.id + '">' +
                        '<img src="' + attachment.sizes.thumbnail.url + '" />' +
                        '<input type="hidden" name="puntr_gallery_images[]" value="' + attachment.id + '" />' +
                        '<a href="#" class="remove-gallery-image">&times;</a>' +
                        '</li>';
                    $('#puntr-gallery-images').append(html);
                });
            });
            
            frame.open();
        });
        
        // Remove image
        $(document).on('click', '.remove-gallery-image', function(e) {
            e.preventDefault();
            $(this).closest('.gallery-image').remove();
        });
    }
    
    // Roster functionality
    if ($('#puntr_provider_id').length) {
        // Auto-update title when provider is selected
        $('#puntr_provider_id').on('change', function() {
            var providerName = $(this).find('option:selected').text().trim();
            if (providerName && providerName !== '-- Select Provider --') {
                var startDate = $('#puntr_start_date').val();
                if (startDate) {
                    var date = new Date(startDate);
                    var dateStr = date.toLocaleDateString();
                    $('#title').val(providerName + ' - ' + dateStr);
                }
            }
        });
        
        // Toggle time fields based on all day checkbox
        $('#puntr_all_day').on('change', function() {
            if ($(this).is(':checked')) {
                $('#puntr_start_date, #puntr_end_date').attr('type', 'date');
            } else {
                $('#puntr_start_date, #puntr_end_date').attr('type', 'datetime-local');
            }
        });
    }
});