<?php
/**
 * Uninstall: remove ALL plugin data (tables + transients).
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

/**
 * 1) Delete plugin transients (stored in wp_options).
 * We first fetch matching option_name values, then delete them via delete_option().
 */
$wcpob_lite_transient_prefixes = array(
	'_transient_wcpob_lite_',
	'_transient_timeout_wcpob_lite_',
);

foreach ( $wcpob_lite_transient_prefixes as $wcpob_lite_prefix ) {
	// Uninstall routine: single-run cleanup query; caching is not relevant.
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
	$wcpob_lite_keys = $wpdb->get_col(
		$wpdb->prepare(
			"SELECT option_name FROM {$wpdb->options} WHERE option_name LIKE %s",
			$wcpob_lite_prefix . '%'
		)
	);

	if ( ! empty( $wcpob_lite_keys ) ) {
		foreach ( $wcpob_lite_keys as $wcpob_lite_key ) {
			delete_option( $wcpob_lite_key );
		}
	}
}

/**
 * 1b) Delete plugin options.
 */
delete_option( 'wcpob_lite_activated_at' );
delete_option( 'wcpob_lite_trial_days' );

/**
 * 2) Drop custom tables.
 * Table names are fully controlled by us ($wpdb->prefix + constant suffix),
 * so we can safely build the query without %i (not supported everywhere).
 */
$wcpob_lite_tables = array(
	$wpdb->prefix . 'wcpob_logs',
	$wpdb->prefix . 'wcpob_sessions',
	$wpdb->prefix . 'wcpob_buyers',
);

foreach ( $wcpob_lite_tables as $wcpob_lite_table ) {
	// Extra hardening: only allow exact expected names.
	$expected_logs     = $wpdb->prefix . 'wcpob_logs';
	$expected_sessions = $wpdb->prefix . 'wcpob_sessions';
	$expected_buyers   = $wpdb->prefix . 'wcpob_buyers';

	if (
		$wcpob_lite_table !== $expected_logs &&
		$wcpob_lite_table !== $expected_sessions &&
		$wcpob_lite_table !== $expected_buyers
	) {
		continue;
	}

	// Table name is strictly whitelisted above and cannot be user-controlled.
	// $wpdb->prepare() does not support identifiers (table names).
	// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.SchemaChange
	$wpdb->query( "DROP TABLE IF EXISTS `{$wcpob_lite_table}`" );
}