<?php
/**
 * Punchr Lite - Crypto helpers
 *
 * @package punchr-lite
 */

if (!defined('ABSPATH')) exit;

function wcpob_crypto_key(): string {
  return hash('sha256', AUTH_SALT . '|' . SECURE_AUTH_SALT, true); // 32 bytes
}

function wcpob_encrypt(string $plain): string {
  $key = wcpob_crypto_key();
  $iv  = random_bytes(12);
  $tag = '';
  $cipher = openssl_encrypt($plain, 'aes-256-gcm', $key, OPENSSL_RAW_DATA, $iv, $tag);
  return base64_encode($iv . $tag . $cipher);
}

function wcpob_decrypt(string $enc): ?string {
  $raw = base64_decode($enc, true);
  if ($raw === false || strlen($raw) < (12 + 16 + 1)) return null;

  $iv  = substr($raw, 0, 12);
  $tag = substr($raw, 12, 16);
  $cipher = substr($raw, 28);

  $key = wcpob_crypto_key();
  $plain = openssl_decrypt($cipher, 'aes-256-gcm', $key, OPENSSL_RAW_DATA, $iv, $tag);
  return $plain === false ? null : $plain;
}