The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

= [4.10.1] - 06 November 2025 =

* Fixed: Author search doesn't include "Guest Author With No User Account", #2161
* Fixed: Creating post using PublishPress Planner calendar shows ["post_author" is empty], #2163
* Fixed: PHP Warning: Attempt to read property "post_type" on null, #2157
* Fixed: Yoast SEO schema validation shows only one author for posts with multiple authors, #2169
* Fixed: Author url been replaced by current user url when editing other authors, #2174
* Update: Show error message when editing author with user account without permissions, #2175
* Fixed: Errors when opening the PublishPress Authors translation file (.po or .pot), #2156
* Update: Authors Translation Updates v.4.10.0, #2159

= [4.10.0] - 14 October 2025 =

* Update: Add a setting to choose which roles are available as Mapped Authors, #1693
* Update: Allow subscribers as multiple author selection, #1693
* Fixed: Author profile rich editor field Line breaks not reflecting in the frontend, #2132
* Update: Add a settings to disable Polylang Author Profiles translation, #2144
* Update: Replace "Mapped User" with "Registered User" in Author Editor, #2146
* Update: Move Import button to the top of Maintenance lists, #2108
* Update: Add required (*) to new author field name, #2129
* Fixed: Prevent author filter on post type not enabled for Authors, #2140
* Fixed: Media Library queries, #2131
* Fixed: Prevent duplicate queries on get_post_authors, #2141

= [4.9.1] - 18 September 2025 =

* Fixed: Excess queries in Media Library and page load, #2119
* Update: Allow users to hide editor Author Box in settings, #2110
* Fixed: Bug with converting "Guest Author With No User Account" to "Guest Author With User Account", #2107
* Changed: Move Author Profiles "Enable Guest Author With No User Account" to "Advanced Tab(legacy), #2109
* Update: Translations update, #2113

= [4.9.0] - 25 August 2025 =

* Feature: Allow users to choose an author box for posts, #1761
* Compat: Polylang compat: Posts not showing in frontend when switching language,  #1721
* Update: Add maintenance button to Import from Molongui, #2063
* Fixed: objectcache.notice: The cache key 47732 is incompatible with prefetching and the group get_post_authors:authors, #2087
* Fixed: No authors found when searching by last name and/or first name, #1531
* Fixed: No results displayed when searching authors by email address, #1523
* Feature: Allow user to choose post types for Author Box Recent Posts [PRO], #1560
* Feature: Add post type options to Author Categories [PRO], #1561
* Feature: Sort authors in Author Lists by number of posts [PRO], #1598
* Feature: Allow a custom link for Author Box "View All Posts" [PRO], #2048
* Feature: Add option to remove the link from the Author Box display name [Pro], #1855
* Feature: Exclude users from Author lists based on Roles, Author Types and Author Categories [PRO], #2086

= [4.8.1] - 30 July 2025 =

* Fixed: PHP Fatal error: Uncaught TypeError: array_search(): Argument #2 ($haystack) must be of type array, null given, #2081
* Update: Add Maintenance button to create Author Categories table, #2046
* Update: Add a loco.xml file for Authors Pro, #2055

= [4.8.0] - 23 July 2025 =

* Feature: Add new Rest API endpoint to create and update Authors and their fields, #2065
* Fixed: Issue with get_the_author_posts_link(), #2054
* Fixed: Incorrect post counts for non mapped users, #2064
* Fixed: Deprecated: str_replace(): Passing null to parameter #2 ($replace), #2050
* Fixed: Error 404 on Author Archive Page (Next Page), #2062
* Fixed: Author names in Icelandic or no UTF-8 character not included in Author Index, #2056
* Compat: ACF Compatibility when secondary author is editing post ACF Block, #2024
* Update: Pro upgrade nudges, #2058

= [4.7.6] - 22 April 2025 =

* Fixes: Limit Author boxes custom template to theme directory, #2034
* Update: Authors FREE Translation Updates_v.4.7.5, #2033

= [4.7.5] - 07 April 2025 =

* Update: Add field to assign Authors to default Author Category from Author Edit screen, #1808
* Update: Add Authors to their assigned defauly category on new post, #1808
* Update: Add option to show Authors belonging to same category in Author List User tab, #1809
* Update: Add Exclude Users options on Author List, #1882
* Update: Add a settings to enable profile checkbox field that exclude authors from Author Boxes and public display, #1973
* Fixed: Post not showing on Authors page for some sites, #2011
* Fixed: Conflict with Jetpack Social, #2010
* Update: Allow to modify Author Boxes "View All Post" label, #2009
* Fixed: Trying to access array offset on value of type bool, #2008
* Fixed: Missing field "mainEntity" in rankmath integration, #2007
* Update: Allow biographic information and other details in Categories boxes, #1897
* Update: Change Authors "Name" column to "Display name publicly as", #1887
* Fixed: Deprecated: Creation of dynamic property MA_Author_Pages, #1883
* Update: Change author biographical information to rich editor, #1877
* Update: Disable "View all posts" by default, #1807
* Update: Authors Translation Updates v.4.7.4, #2004
* Update: Translation pt_BR, #2005

= [4.7.4] - 20 Feb 2025 =

* Fixed: Fix data sanitization on author categories
* Fixed: PHP Warning with Rank Math, #1970
* Fixed: Conflict between Polylang and Authors, #1931
* Update: Add sub headings to Author Boxes > Author Fields, #1889
* Update: Allow Display Name Author Categories to be in front, #1894
* Fixed: PHP Fatal error: Uncaught Error: Call to a member function get_user_object() on bool, #1997
* Update: Add settings to show Author profile above the content, #1929
* Fixed: Post Filter Not Working when filtering on Author and Category together, #1933
* Fixed: Admin "Mine" tab count is incorrect, and also including post from all post types instead of current post type, #1989
* Fixed: "Mine" not showing when author is a secondary author on posts, #1939
* Fixed: Undefined property: WP_Error::$count, #1974
* Fixed: Author Categories Errors on installs, #1972
* Fixed: Redundant repeated CSS and move Author box styling from content to footer(filtereable), #1976
* Fixed: Fatal error: "Class "MultipleAuthors\WP_Error" not found", #1971
* Update: Update "Twitter" for "X" on new installation, #1955
* Update: Update text for bulk edit, #1978
* Update: Authors Translation Updates v.4.7.3, #1966

= [4.7.3] - 16 Dec 2024 =

* Fixed: Can't change the layout for new Author Lists, #1892
* Fixed: HTML Title Issue with AIO SEO, #1899
* Fixed: Schema Issue with RankMath, #1901
* Fixed: Wrong Author name on Yoast Description, #1898
* Fixed: Missing Schema on Page, #1926
* Update: Add Author Recent featured image size settings in Authors Lists, #1891
* Update: Add twitter icon and bluesky from, FA #1920
* Update: Update FontAwesome to 6.7.1, #1930
* Fixed: Prevented mid-word cuts for readability, #1922
* Fixed: Small typo with the Display Name, #1895
* Update: Move the Author Pages warning, #1893
* Fixed: Deprecated: Dynamic properties MA_Author_Pages::$module_url and $module, #1946
* Update: Add option for hyperlink in author bio box, #1938
* Fixed: 4.7.0 introduced a slow query from avatar alt text, Add option to filter avatar alt 'multiple_authors_avatar_alt_text', #1923
* Fixed: Refactor flush_cache Method, #1952
* Update: Add margin to warnings on the Authors screen, #1909
* Update: Use Alt text on Avatar Author Box, #1880
* Fixed: Author category filter returning all Authors when none is found, #1878
* Fixed: Moving Authors to new category is not reflecting after saving and reloading post, #1932
* Update: Authors Translation Updates v.4.7.2, #1919

= [4.7.2] - 15 Oct 2024 =

* Update: Improve Author User data update capability check
* Fixed: Fix Guest Author conversion not working for Author without email, #1908
* Update: Brazil Translation Update, #1910

= [4.7.1] - 10 July 2024 =

* Update: Add Trash feature to Authors Lists, #1848
* Fixed: Author Box Export Template not same as layout, #1754
* Update: Add redirect for new installs, #1796
* Fixed: Deprecated Message on PHP 8.3, #1858
* Update: Add a bulk edit action to switch "Guest Author" to "Guest Author With User Account", #1859
* Fixed: Support for Divi Guest author, #1856
* Update: Make Author Lists title required, #1845
* Update: Add documentation link for Author Pages, #1843
* Update: Update promo box, #1840
* Update: Authors Translation Updates_v.4.7.0, #1853

= [4.7.0] - 20 June 2024 =

* Update: Add Authors List Menu, #1009
* Update: Move Author Pages to the Main Menu, #1779
* Update: Allow shortcodes in Author Boxes, #1489
* Update: Add a wrapper to Author Pages, #1821
* Update: Update author category column check icon, #1793
* Update: Update Author Box text labels, #1795
* Update: Authors Translation Updates, #1799

= [4.6.0] - 03 June 2024 =

* Update: Add Author Boxes Gutenberg Block, #11
* Update: Add Author box icon search, #1771
* Update: Use Code editor for Author Boxes Custom Css and Generate Theme template textarea, #1710
* Update: Hide all author fields for existing sites Simple List, Inline and Inline with Avatars author boxes, #1776
* Fixed: JSON files with strings are not generated, #1743
* Fixed: Fix "PublishPress Authors: View is not readable: inline" error when using legacy layout in shortcode, #1780
* Update: Remove generatepress 'by' author box prefix, #1777
* Fixed: wp_ppma_author_categories_meta' doesn't exist on some sites, #1774
* Fixed: Some Strings are hardcoded and not translatable, #1742
* Update: Only enable the Author Box on Posts on new installation, #1766
* Update: Authors Translation Updates v.4.5.0, #1770

= [4.5.0] - 15 May 2024 =

* Update: Add new author box : Boxed (Categories), #1737
* Update: Add new author box : Two Columns (Categories), #1738
* Update: Add new author box (Boxed Right), #1736
* Update: Add default "Job Title" field, #1725
* Removed: Remove Author Box Meta Field, #1501
* Update: Strip html tags from author rich editor author fields schema value, #1744
* Update: Replace "Show Author Field" with "Hide Author Field" in Author Boxes, #1723
* Update: Add support for Yoast SEO slack sharing data for Guest Author, #1726
* Update: Add Field Type to the "Author Fields" column, #1728
* Fixed: Duplicate Query when user doesn't have an author profile, #1717
* Fixed: Custom Author Box Produce Errors, #1691
* Fixed: Fixed text domain in footer-base.html.php file, #1740
* Update: Update promo box to add "Support for Polylang", #1727
* Update: Translation Updates and typo error in Authors FREE v.4.4.1, #1715

= [4.4.1] - 3 April 2024 =

* Update: Add a setting to choose which Author types are allowed, #1692
* Fixed: SEO Framework: deprecated Hook notice in error log, #1700
* Fixed: Authors causing custom post type and taxonomy archives SEO title to be untitled, #1013
* Fixed: RankMath Schema (Logo & Location) Issue, #1380
* Fixed: PublishPress Authors plugin changes "Organization" to "Person", #1708
* Fixed: Author boxes are not displayed correctly when using Inline with Avatars layout – punctuation, #1499
* Update: Disable the lightweight Guest Authors feature by default for new installation, #1703
* Update: Translation Updates ES-FR-IT Authors FREE v4.4.0, #1695

= [4.4.0] - 6 Mar 2024 =

* Update: Add User Account option for Guest Authors, #1287
* Update: Add Schema option for Author Categories, #1642
* Update: Add Schema Property Options for Author Fields, #1641
* Fixed: Attempt to read property "user_nicename", #1675
* Fixed: Fatal error: Uncaught TypeError: Illegal offset type in isset or empty, #1644
* Update: Translation Updates for Authors FREE v. 4.3.2, #1673

= [4.3.2] - 22 Feb 2024 =

* Update: Add author_categories parameter to authors data shortcode [publishpress_authors_data author_categories="reviewer"], #1658
* Update: Add author_categories parameter to authors box shortcode [publishpress_authors_box author_categories="reviewer,coauthor"], #1658
* Fixed: Schema Filter is not showing when Authors activated, #1655
* Fixed: PHP Warnings: Illegal string offset '@type' in SchemaFacade.php, #1635
* Update: Add settings to select legacy layout('simple_list', 'centered', 'boxed', 'inline', 'inline_avatar') author boxes, #1640
* Update: Disable the Co-Authors category by default for new installs, #1659
* Fixed: PHP Fatal error: Uncaught Error: Class "MA_Author_Categories" not found, #1647
* Update: Show Post Default Author box in Author box lists, #1639
* Update: Authors FREE Translations Updates 25 January 2024, #1636

= [4.3.1] - 24 Jan 2024 =

* Update: Allow users to choose the target=”_blank” attribute for author field links, #1600
* Update: Add rel options on Author Field Link, #1488
* Update: Update Field Slug description, #1476
* Fixed: Missing Field Schema Rank Math, #1618
* Fixed: Unspecified Type on RankMath Schema Integration, #1583
* Fixed: Optimized author queries to fix Authors slowing down some websites
* Fixed: PHP Warning: Attempt to read property "post_type" on int, #1624
* Fixed: PHP 8.2 Deprecated notices, #1533
* Update: Authors Translation Updates January 2024, #1617

= [4.3.0] - 10 Jan 2024 =

* Feature: Add the ability to group / categorize Authors (Author Categories), #58
* Update: Add user_id and term_id parameter to [publishpress_authors_box] shortcode, #1602
* Update: Add the Edit links for all Author Fields, #1475
* Fixed: Author Boxes screen isn't fully responsive, #1594
* Fixed: Author Fields are in the wrong order, #1587
* Update: Move author field sidebar promo panel to the bottom, #1506
* Update: Add support for multiple authors posts when using get_posts() function via 'ppma_filter' => true parameter, #1591
* Fixed: Authors Profile not being created when "Enable Guest Author" is disabled, #1584
* Update: Rename maintenance button tools, #1526
* Update: WordPress Reviews library to 1.1.20, #1490
* Update: Upgrade Reviews and Version Notices libraries, #1491
* Fixed: PostX – Post Grid Gutenberg Blocks and WordPress Blog Plugin Compatibility, #1485
* Fixed: Elementor Archive widget showing wrong author, #1481
* Fixed: Uncaught TypeError: array_intersect(): Argument #2 must be of type array, null given, #1479
* Update: Add filter to disable settings flush_rewrite_rules when authors page is enabled/disabled, #1425
* Update: ES-FR-IT translation updates September 2023, #1478

= [4.2.1] - 04 Sep 2023 =

* Feature: Allow users to re-order Author Boxes fields, #1441
* Feature: Allow user to control the order of fields in the "Author Profile" via "Author Fields" Drag and Drop, #1463
* Update: Hook into the action to flush cache when authors are saved, #1270
* Update: Update instance of 'Author: %s' to use wordpress translation, #1235
* Fixed: Fix ppma_edit_own_profile capability missing for required role, #1443
* Update: Add rel="nofollow" to links in Author Boxes, #1249
* Feature: Extend Search Box to all layouts, #1262
* Fixed: Additional Rank math Integration conflict, #1434
* Update: Remove custom names for each Author Fields label, #1289
* Fixed: Author box Avatar Border Radius not reflecting when set to "0", #1432
* Update: Improve message for mapping authors, #1131
* Fixed: WYSIWYG Fields line breaks not working, #1444
* Fixed: Compatibility with Admin Menu Editor, #1247
* Fixed: [publishpress_authors_list] shortcode issue, #1448
* Fixed: Authors data shortcode separator does not having space, #1445

= [4.2.0] - 16 Aug 2023 =

* Changed: Replaced Pimple library with a prefixed version of the library to avoid conflicts with other plugins;
* Changed: Replaced Psr/Container library with a prefixed version of the library to avoid conflicts with other plugins;
* Changed: Change min PHP version to 7.2.5. If not compatible, the plugin will not execute;
* Changed: Change min WP version to 5.5. If not compatible, the plugin will not execute;
* Changed: Updated internal libraries to latest versions;
* Changed: Refactor some occurrences of "plugins_loaded" replacing it by a new action: "plublishpress_authors_loaded" which runs after the requirements and libraries are loaded, but before the plugin is initialized;

= [4.1.7] - 10 Jul 2023 =

* Feature: New "Display Name" setting, #1407
* Fixed: Improve "display name as publicly” field, #1409
* Fixed: Warning: Attempt to read property "display_name" when editing guest author, #1410

= [4.1.6] - 4 Jul 2023 =

* Feature: Added author boxes author separator field, #1379
* Feature: Added Prefix and suffix fields for author box row #1382
* Fixed: Conflict with the Advanced Ads plugins, #1398
* Update: Extended Pagination to other layouts shortcode [publishpress_authors_list layout="boxed" limit_per_page="20"], #1381
* Update: Update Display Name field to match WordPress style, #1373
* Update: Spelling typo of roleName in Installer, #1400
* Fixed: Rankmath "The property @type is not recognized by the schema", #1399
* Update: Move "Author Bio" to the bottom of the "Edit My Author Profile" screen, #1372
* Update: Update shortcodes tab for new author boxes, #1336
* Fixed: 8.2 deprecations warning, #1330
* Update: Remove "Create default Author Boxes" maintenance button, #1371
* Fixed: Conflict with Pattern Manager plugin, #1378
* Update: Small text update: Update data from mapped user, #1374
* Update: Small text update for Maintenance, #1370
* Update: Drop the ad for Blocks, #1317
* Fixed: Issues with Divi WordPress Theme, #1383

= [4.1.5] - 1 Jun 2023 =

* Fixed: Author boxes styles not working after migration from legacy layout, #1341
* Fixed: Last column has different size on Author List, #1345
* Fixed: Missed semicolon on generated author box theme template, #1352
* Fixed: authors_index and authors_recent layout not working, #1357
* Update: Include Display Name in "Update data from mapped user" feature, #1344
* Fixed: PublishPress Authors query issue conflict with Planner Content Overview Filter, #1350
* Fixed: Authors FREE ES-IT Translation Updates May 12, 2023, #1343
* Fixed: French translation update for Authors FREE May 2023, #1347

= [4.1.4] - 10 May 2023 =

* Update: Add support legacy layout slug in author boxes, #1334

= [4.1.3] - 9 May 2023 =

* Update: Remove support for legacy layouts and twig dependency, #1204
* Feature: Allow users to choose a default avatar, #1301
* Fixed: get_page_by_title Depreciated in WordPress 6.2, #1324
* Feature: Allow users to disable the Guest Authors feature, #1310
* Feature: Filter to override limit number of author in search, #1294
* Fixed: Jannah theme multiple author support, #1306
* Fixed: Problem with multiple author boxes instance, #1304
* Fixed: Issue with italian translation, #1253
* Fixed: Avatar data shortcode shows array, #1302
* Fixed: Fatal error: Uncaught Error: Call to a member function get_avatar_url() yoast seo, #1297
* Fixed: Fatal error: Uncaught Error: Call to a member function get_avatar_url() in rankmath, #1273
* Fixed: PHP Fatal error: Uncaught TypeError: abs(), #1291
* Fixed: Schema not getting right Author for Publisher schema, #1271
* Fixed: Authors not in alphabetical order for authors_index layout, #1267
* Fixed: Problem with select required field when updating authors, #1257

= [4.1.2] - 31 Jan 2023 =

* Update: Add "SameAs" schema option to links, #1189
* Fixed: Compability Issue with beaver builder, #1227
* Update: Remove domain translation from "Recent Posts" and "Author" in favour of WordPress translation, #1194
* Fixed: Issue with author box styles when multiple author box is on the same page, #1208
* Update: Add fallback field for [publishpress_authors_data] shortcode, #1150
* Update: Make Author Box edit page responsive, #1172
* Fixed: PHP Warning – Undefined array key “url”, #1190
* Fixed: Can't use HTML in Author Boxes Bio, #1175
* Update: Remove Edit bulk action Author Box screen, #1173
* Update: Replace "Biographical Info" with "Author Bio", #1176
* Update: ES-FR-IT Translations Updates January 2023, #1177

= [4.1.1] - 16 Jan 2023 =

* Update: Update Author Pages Schema to Person Schema type, #1163
* Fixed: Incorrect display name is being used for schema, #1160
* Update: Extra text for "Display Name" field, #1161
* Update: ES-FR-IT Translations Updates January 2023, #1177

= [4.1.0] - 04 Jan 2023 =

* Update: Integrate PublishPress Authors with Yoast, #1102
* Update: Add support for structured data for authors for RankMath SEO Plugin, #391
* Fixed: Post Author widget not updating, #1122
* Update: Accessibility improvements for links, #1138
* Update: Add "archive" parameter to [publishpress_authors_data] shortcode, #1136
* Update: Rename public methods for better clarity and avoiding name conflicts, #520 https://publishpress.com/knowledge-base/deprecated-functions/
* Fixed: Issue with author boxes profile field background color, #1128
* Update: Add author pages excerpt ellipsis in settings, #1124
* Update: Add new before and after prefix or suffix for author boxes profile fields, #1119
* Update: Move function generatepress_author_output to a new module, #587
* Fixed: Code looking for wrong function before getting multiple authors in the author box, #571
* Update: Italian Translation Update December 2022, #1145

= [4.0.1] - 06 Dec 2022 =

* Fixed: Icon does not hide when there is no value, #1103
* Fixed: Author pages pulling excerpts from content, #1112
* Update: Allow to set author's page post limit, #1108
* Fixed: Author Field Link is not Active link, #1105
* Fixed: Link does not rendered on WYSIWYG field, #1101

= [4.0.0] - 29 Nov 2022 =

* Update: Added last_article_date to publishpress_authors_list shortcode [publishpress_authors_list last_article_date="1 year ago"]
* Update: Allow to set Author Boxes previewing authors, #913
* Update: Added group by field name to authors_index [publishpress_authors_list layout="authors_index" group_by="last_name"], #977
* Update: Allow Author list to have 2 columns for custom layout [publishpress_authors_list layout="boxed" layout_columns="2"], #996
* Fixed: Issue with Translatepress + WPUlike, #962
* Update: Make new "Boxed" the default layout, #980
* Fixed: Authors causing custom post type and taxonomy archives SEO title to be untitled, #1013
* Fixed: Authors_Iterator call in Author_box.php assumes that $post global is populated (which it isn't sometimes) #999
* Update: Change author 'Name' label to 'Display Name', #991
* Update: Remove the "All dates" feature in Author Boxes, #990
* Update: Add Required / Optional settings to Author fields, #1066
* Fixed: An incongruence in the line 170 between singular and plural, #982
* Update: Change name of Settings to PublishPress Authors, #981
* Fixed: Documentation link missing for Author boxes generate template, #978
* Update: Remove Legacy options and "Layouts" menu, #960
* Update: Add a Pro sidebar, #1050
* Update: New "Advanced" tab in settings, #1020
* Update: Add Dashicons and Fontawesome icon pages link to Author Boxes profile icon field, #1064
* Update: Move Author Bio up the "Author Profile" screen, #1058
* Update: Display Pro banner on Boxes and Fields screen, #1052
* Update: Rename and add option to hide Author Box Display Name, #1057
* Update: Rename Author Boxes "Author Bio" to "Biographical Info", #1056
* Update: Use "Avatar" on Profile tab, #1060
* Update: Authors_ES-IT_Translation_Update-19-October 2022, #979
* Update: FRENCH_Translation Update_Authors 20 October2022, #984

= [3.30.1] - 02 Nov 2022 =

* Update: Added last_article_date to publishpress_authors_list shortcode [publishpress_authors_list last_article_date="1 year ago"]
* Update: Allow to set Author Boxes previewing authors, #913
* Update: Added group by field name to authors_index [publishpress_authors_list layout="authors_index" group_by="last_name"], #977
* Update: Allow Author list to have 2 columns for custom layout [publishpress_authors_list layout="boxed" layout_columns="2"], #996
* Fixed: Issue with Translatepress + WPUlike, #962
* Update: Make new "Boxed" the default layout, #980
* Fixed: Authors causing custom post type and taxonomy archives SEO title to be untitled, #1013
* Fixed: Authors_Iterator call in Author_box.php assumes that $post global is populated (which it isn't sometimes) #999
* Update: Change author 'Name' label to 'Display Name', #991
* Update: Remove the "All dates" feature in Author Boxes, #990
* Fixed: An incongruence in the line 170 between singular and plural, #982
* Update: Change name of Settings to PublishPress Authors, #981
* Fixed: Documentation link missing for Author boxes generate template, #978
* Update: Authors_ES-IT_Translation_Update-19-October 2022, #979
* Update: FRENCH_Translation Update_Authors 20 October2022, #984

= [3.30.0] - 18 Oct 2022 =

* Feature: Add new improved layouts (Author Boxes), #896
* Update: Deprecate Twig layout as legacy, #758
* Fixed: Authors plugin causes a fatal error and prevents pages from loading, #863
* Update: Remove "Layouts" promo link, #959
* Update: Remove Author Recent and Author Index from layout list, #956
* Update: Move Disable the "Authors" box when using "Quick Edit" to General tab, #953
* Fixed: Small settings typo, #955
* Update: Add an ALT Text for the avatars, #931
* Update: Allow users to disable Authors Box in Quick Edit, #897
* Update: Add descriptive text to Authors links, #807
* Update: Prevent some critical error on wp api author response, #898
* Update: authors-IT-translation-update_september2022, #899
* Update: Authors-FR-TranslationUpdate-September2022, #908
* Update: NewAuthors-Version3.22.0-ES-FR-IT-TranslationUpdate-7October2022, #932

= [3.23.0] - 3 Oct 2022 =

* Update: Upgrade twig to v1.44.7, #921
* Update: Update minimum php requirement to PHP 7.2.5

= [3.22.0] - 1 Sep 2022 =

* Update: Added avatar to publishpress_authors_data shortcode [publishpress_authors_data field="avatar"]  #887
* Update: Added settings to disable mapped user check when creating author, #885
* Update: Added First Name to Authors REST API data #877
* Update: Added Last Name to Authors REST API data #877
* Update: Added User Biography to Authors REST API data #877
* Update: Added Custom fields to Authors REST API data #877
* Update: Authors_ES_FR_IT_Translations_August17-2022, #876

= [3.21.1] - 23 Aug 2022 =

* Fixed: Empty author result when using [publishpress_authors_list] shortcode, #878

= [3.21.0] - 17 Aug 2022 =

* Update: Improved REST API support, #509
* Feature: Add profile field sorting options to the Authors List (first_name last_name custom_field_slug), #257
* Update: Add shortcode to display specific authors using [publishpress_authors_data term_id="102"], #556
* Update: Allow user to change author pages headers (H1, H2, H3, H4, H5, H6), #832
* Update: Allow users to disable the title for Authors Pages, #833
* Update: Improve design for layout shortcodes, #844
* Update: Add avatar_url to Post Author REST API, #837
* Fixed: Double widget header title div for authors list widget, #852
* Fixed: New taxonomy box showing for Authors, #866
* Fixed: Issue with Easy Digital Download and Authors installed together, #865
* Fixed: Double submit button in php 8.1.6 author screen, #861
* Fixed: SEO Framework plugin integration errors, #709
* Fixed: Broken closing div in author page, #841
* Update: Authors-ES-FR-IT- Translation-Update-August2022, #847

= [3.20.1] - 08 Aug 2022 =

* Feature: Added 'search_box' option to authors shortcode and widget, #780
* Feature: Added 'search_field' option to authors shortcode and widget, #780
* Feature: Added pagination and Search to all defaults layout, #819
* Feature: Added search box and search field option to authors list widget #822
* Fixed: Conflict with PublishPress Calendar, #818
* Update: Allow users to edit "Authors Recent", "Authors Index" and default layouts, #801
* Update: ES-FR-IT translation updates, #804

= [3.20.0] - 28 Jul 2022 =

* Fixed: Bulk edit not working, #741
* Feature: Added 'authors_recent' layout for Authors List, #124
* Feature: Added 'authors_index' layout for Authors List, #124
* Feature: Added 'limit_per_page' option to authors shortcode and widget, #788
* Feature: Added 'show_empty' option to authors shortcode and widget, #788
* Feature: Added 'authors' option to authors shortcode and widget, #788
* Feature: Added 'order' option to authors shortcode and widget, #788
* Feature: Added 'orderby' option to authors shortcode and widget, #788
* Feature: Added 'authors_recent_col' to authors shortcode and widget, #788
* Feature: Add new options to author list widget, #788
* Update: Italian and spanish translation update, #772

= [3.19.1] - 18 Jul 2022 =

* Feature: Add a setting for selecting Fallback user for Guest Authors, #743
* Feature: Allow users to limit the length of a bio in a layout using author.get_description(150), #754
* Fixed: Conflict between All in one SEO and PublishPress Authors Pro, #762
* Update: Updated Spanish and Italian translation files, #757
* Fixed: Empty space between categories is missing, #753
* Update: Change "Display" tab to "Author Boxes" in settings, #755
* Update: Remain on active tab after updating settings, #746

= [3.19.0] - 27 Jun 2022 =

* Feature: Added new Author Profile Pages, #417
* Added: Settings tab for "Author Pages", #729
* Update: Authors taxonomy queries improvement, #527
* Added: Added filter to authors rest response, #726

= [3.18.0] - 13 Jun 2022 =

* Fixed: Allow authors to have the same name, #682
* Added: Extend [publishpress_authors_data] shortcode to return authors user object, #697
* Fixed: Search box doesn't accept ' characters in username, #699
* Added: Add Authors important menu link to plugin row, #714
* Fixed: Author menu missing in admin menus, #715
* Fixed: PHP 7.2 compability, #711
* Added: Add [publishpress_authors_list] shortcode to the Free version, #706
* Fixed: Most important buttons should be yellow only, #704
* Fixed: Author Box shortcode is in the wrong place, #695
* Fixed: Small typo in shortcode, #693

= [3.17.0] - 30 May 2022 =

* Added: Option to enable/disable loading font awesome assets in frontend, #625
* Added: Support for user fields WPML translations, #642
* Added: Add new shortcode [publishpress_authors_data] which can be used to display the author names or any profile field, #673
* Fixed: Multiple Authors Compability with Yoast SEO authors's title, #672
* Update: Change [author_box] to [publishpress_authors_box] in shortcode tab, #670

= [3.16.3] - 18 May 2022 =

* Added: Add an Author Filter for Posts, #90
* Update: Enable Author Profile for Administator and other roles with 'ppma_manage_authors', #649
* Added: Add a shortcodes tab to settings, #641
* Update: Run the WordPress VIP scans on Authors, #639
* Fixed: Authors menu links can be split up by PODS content types, #684

= [3.16.2] - 09 May 2022 =

* Fixed: Fix incorrect "Mine" counter in admin posts list, #591
* Fixed: Fix error with subscribers/non admin inability to see see Author page posts, #584
* Added: Add metabox to control author display on pages #60
* Added: Added Author Profile URL #616
* Update: Use built-in capability check when searching users via ajax, #645
* Added: Disable Free version with Pro is active #615

= [3.16.1] - 13 Apr 2022 =

* Fixed: Fix author mapped to user error when adding new author, #626;
* Fixed: Fix test for checking the author link in the frontend;
* Fixed: Fix Undefined array key "tag-name" when bulk delete all authors, #628;
* Fixed: Fix Fatal error when "Create missed post authors" button is clicked, #623;
* Fixed: Fix author profile allowing to add html tags in the bio text, #619;

= [3.16.0] - 23 Mar 2022 =

* Added: Add option to authors update their own profile, #24;
* Fixed: Fix new author form not allowing to map a user to multiple authors, #64;
* Fixed: Fix PHP notice Constant PP_WP_BANNERS_VERSION already defined, #603;
* Fixed: Improve the selection of avatar for authors, making it clear if is using gravatar or custom image, #564;
* Fixed: Updated Italian translation files;
* Fixed: Fix description field that were displayed in the author profile after navigating throw the tabs, #605;
* Fixed: Fix small extra spacing in image link, #607;

= [3.15.1] - 17 Mar 2022 =

* Fixed: Fix fatal error: Cannot declare class PublishPress\WordPressBanners\BannersMain;

= [3.15.0] - 16 Mar 2022 =

* Fixed: Fix error where secondary authors were dropped off the posts if loading author pages on sites using plain permalinks, #593;
* Fixed: Fix error when trying to create an author for user that already is author, #592;
* Fixed: Abort author creation if user is empty;
* Fixed: Removed redundant check for existent user when creating author from user;
* Fixed: Fix compatibility with Elementor Pro and archive page title checking the constant "PUBLISHPRESS_AUTHORS_DISABLE_FILTER_THE_AUTHOR", if true, disables the "the_author" filter, #563;
* Fixed: Fix nonce validation all over the plugin;
* Fixed: Fix input sanitization all over the plugin;
* Fixed: Fix output escaping;
* Fixed: Added additional capability check before running maintenance tasks: manage_options;
* Fixed: Added capability check before allowing to search users and authors in the admin: ppma_edit_post_authors;
* Fixed: Improved data escaping and sanitization on a few queries;
* Fixed: Improved performance removing redundant plugin version option update on every request, #588;
* Fixed: Improved upgrade and install routines to not run on front-end requests, only in the admin, #589;
* Fixed: Fixed many WP Vip PHPCS warnings and errors;
* Removed: Remove not used method "MA_Settings::helper_print_error_or_description";
* Removed: Remove commented code from WP_Cli class;
* Removed: Remove deprecated class "PublishPress\Addon\Multiple_authors\Classes\Integrations\RSS";
* Changed: Deprecated function "get_multiple_authors", which is replaced by "get_post_authors" and "get_archive_author";
* Changed: Added conditional looking for WP_DEBUG = true before logging some errors;
* Fixed: Fix WordPress Banners library using autoload to fix an issue about file not found "BannersMain.php" on the Pro plugin, or sites that rely on Composer;

= [3.14.10] - 16 Mar 2022 =

* Fixed: Fix the character "&" in the Bibliographical Info field, which was converted to "&amp;", #566;
* Fixed: Fix PHP 8 compatibility addressing the error: PHP Fatal error: Uncaught TypeError: array_key_exists, #585;
* Fixed: Fix avatar URL on the structured data schema, #552;
* Fixed: Fix PHP error generated when method create_from_user was called for a post with post_author = 0;
* Fixed: Fix compatibility with Elementor Pro and the archive page title adding new constant to disable the filter "the_author", #563;
* Fixed: Fix fatal error on method_exists, argument should be object|bool, #590;
* Fixed: Sanitize some nonce tokens for a second layout of protection;
* Fixed: Fix PHP 8 fatal error about unsupported types: string + string, #559;
* Fixed: Fix PHP 7 warning about non-numeric value encountered, #560;
* Fixed: Fix PHP warning about trying to get property term_id of non-object, #562;
* Fixed: Fix PHP 8 fatal error Attempt to assign property "userObject" on bool, #561;
* Fixed: Fix the banner about PublishPress Blocks that was displayed even if Blocks is already activated, #549;
* Changed: Error log messages are only added if WP_DEBUG is enabled;

= [3.14.9] - 18 Nov 2021 =

* Fixed: The author profile URL for guest authors was not added to the schema for Google rich results with Yoast SEO, #545;
* Fixed: PHP Fatal error: Call to undefined method stdClass::get_avatar_url(), #544;
* Fixed: Call to undefined method stdClass::is_guest() in rest-api.php, #546;
* Changed: Show the reviews banner on any admin page;

= [3.14.8] - 04 Nov 2021 =

* Fixed: HTML special chars in the author name are not displayed correctly, #531;
* Fixed: Access denied while creating posts with contributor and another user as default author, #534;
* Fixed: Fix duplicated prefix for text elements with dynamic content on Divi builder, #528;
* Fixed: Remove gap in the settings tabs, #532;
* Fixed: Fix style for buttons in the settings page, #537;
* Added: Add notice asking for a review;

= [3.14.7] - 21 Sep 2021 =

* Fixed: Fix robots meta tag when Yoast SEO is installed and it is not the authors page, #508;
* Fixed: Can't save multiple authors if Yoast SEO is activated, #504;
* Fixed: Only allow mapping authors to users who have edit_posts capability, #492;
* Fixed: Convert author to guest author when its user is deleted, #505;
* Fixed: Secondary author's comments remain as awaiting moderation, #469;
* Fixed: Restore the CLI command: assign-coauthors, but renaming to assign-author-by-meta-key, #438;
* Fixed: Authors mapped to user are treated as as guest authors after removing all other authors in the post edit page, #523;
* Fixed: PHP notice: Trying to get property of non-object in Post_Editor.php on line 293, #521;

= [3.14.6] - 14 Sep 2021 =

* Fixed: Fix the output of guest authors data on the frontend, #500;
* Fixed: Fix "get_multiple_authors" resulting on error 500 when post author is zero, #511;
* Fixed: Fix PublishPress Calendar integration with guest authors to avoid empty value on "post_author", #512;
* Fixed: Fix PHP Notice: Trying to get property 'display_name' of non-object on authors column for post_author = 0, #514;
* Fixed: Fix Yoast SEO structured data schema. Bumped min Yoast SEO version to 14.0, #472;

= [3.14.5] - 01 Sep 2021 =

* Fixed: Fix query for author posts doesn't work if instead of the author name we have the author ID or term ID, #487;
* Fixed: Fix reduced font size for the author description, #435;
* Fixed: Fix error message when post is not found, showing warning about "post_author" and "post_type" on null, #495;
* Fixed: Fix the selection of fallback user for guest authors in the posts bulk edit form, #497;
* Fixed: Fix PHP warnings for the shortcode "authors_list", used in the Pro plugin, #498;
* Fixed: Add "author" taxonomy to Polylang, #18;

= [3.14.4] - 19 Aug 2021 =

* Fixed: Fix author profiles that are automatically created for users that are not on the selected user roles, #464;
* Fixed: Fix authors not created when registered from the frontend for the selected user roles, #420;
* Fixed: Fix guest authors compatibility with YoastSEO archive pages and the "robots" tag, #471;
* Fixed: Fix PHP notice: Trying to get property 'name' of non-object in Utils.php, #485;
* Fixed: Fix PHP notice: Trying to access array offset on value of type bool in class-wp-list-util.php, #486;

= [3.14.3] - 01 Aug 2021 =

* Fixed: Add class "bypostauthor" for secondary authors on comments, #154;
* Fixed: Fixed the author byline on 3rd party themes in the front-end, #473;
* Added: Added CSS class with the author slug to each author in the default layouts;

= [3.14.2] - 21 Jul 2021 =

* Fixed: Fix error on block editor for posts with guest authors, #463;

= [3.14.1] - 20 Jul 2021 =

* Changed: Invert position of Edit User and Edit Author Profile links in the term actions, #453;
* Fixed: Fix sanitization of the user_id before adding it to a query;
* Fixed: Fix compatibility with the search results on the plugin "Knowledge Base for Documents and FAQs" when an article is not found;
* Fixed: Fix compatibility with PublishPress' calendar create item form for the author field, to select guest or mapped to user authors;
* Fixed: Add compatibility with PublishPress' calendar to support multiple authors in the calendar form;
* Fixed: Fix the warning: Undefined array key "post" in multiple-authors.php file, when opening the General settings page, #459;

= [3.14.0] - 26 May 2021 =

* Added: Added new setting for selecting multiple post types to display in the author page, #436;
* Added: Added new function "get_by_id" to the Author class, accepting positive integer for User ID, and negative integer for term ID, #423;
* Changed: Shortcode [author_box] was renamed to [publishpress_authors_box], #426;
* Changed: Shortcode [ppma_test] was renamed to [publishpress_authors_test], #426;
* Changed: Legacy shortcodes are loaded by default, but defining the constant PUBLISHPRESS_AUTHORS_LOAD_LEGACY_SHORTCODES = false will prevent to load them, #426;
* Fixed: Fix the Author::get_avatar_url method returning the avatar URL, #443;

= [3.13.1] - 22 Apr 2021 =

* Fixed: Fix the color scheme for the Pro plugin, #411;
* Fixed: Fix the links style for the boxed and centered layouts, #414;
* Fixed: Hide the core author field in the post edit pages and add field to set a user as author if a post has only guest authors, #344;
* Fixed: Fix relationship between post and author if not existent when running the function "get_multiple_authors". It fallbacks to the current post author, creating the Author term and relationship with the post, #396;
* Fixed: Fix the CLI subcommand list-posts-without-terms adding support for the following arguments: [--post_type=<ptype>] [--posts_per_page=<num>] [--paged=<page>] [--order=<order>] [--orederby=<orderby>], #415;
* Fixed: Fix the CLI subcommand create-terms-for-posts adding support for the following arguments: [--post_type=<ptype>] [--posts_per_page=<num>] [--paged=<page>], #415;
* Changed: Temporarily disabled the CLI subcommands: update-author-terms, assign-coauthors, assign-user-to-coauthor, reassign-terms, rename-coauthor, swap-coauthors, remove-terms-from-revisions, #415;

= [3.13.0] - 18 Mar 2021 =

* Added: Improve layout for Centered box and add a color picker to choose a base color, #376, #377;
* Added: Added new filter to extend the "post" variable exposed to the layouts. The new filter: "publishpress_authors_layout_post_properties", #384;
* Fixed: Fix the Authors List widget sorting by the author name, #389;
* Fixed: Fixed Notice: Undefined index: title_plural in the Widget.php file, #393;
* Fixed: Error Cannot access private property MultipleAuthors\Classes\Objects\Author::$term_id, #386;
* Fixed: The authors field is not displayed for custom post types created by Toolset, or other plugins, #385;
* Fixed: Fix link for authors in the Genesis Framework Featured Posts widget, #378;
* Fixed: PHP Warning: in_array() expects parameter 2 to be array, string given "multiple-authors/multiple-authors.php" #402;
* Fixed: PHP Fatal error: Uncaught Error: [] operator not supported for strings in MA_Multiple_Authors->filter_workflow_receiver_post_authors #403;
* Changed: Change the default layout to "boxed", #370;

= [3.12.0] - 23 Feb 2021 =

* Added: Added filters for customizing the byline on Elementor skins: publishpress_authors_elementor_posts_skin_cards_byline, publishpress_authors_elementor_posts_skin_classic_byline, #335;
* Changed: Improved the style for the Boxed layout, #332;
* Changed: Automatically sync the author URL with the user nicename when the user is saved, #53;
* Fixed: Fixed encoding of UTF-8 chars in the Author URL column in the Authors list, #352;
* Fixed: Fixed PHP warnings on Nested Pages plugin, #345;
* Fixed: Improved performance on author pages reducing the number of database queries only looking for an author taxonomy if a user was not found;
* Fixed: Fix compatibility with the SEO Framework archive title for guest authors, #351;
* Fixed: Fixed the query to list authors considering only published posts, #350;
* Fixed: Fixed warning about undefined index: ID, the rest-api.php file, #342;
* Fixed: Fix PublishPress notifications for guest authors with email address, #349;
* Fixed: Fix the PHP warning "Call to a member function get_user_object() on bool", #348;
* Fixed: Duplicated queries caused by multiple calls to "get_user_by" for the same slug, #343;
* Fixed: Fix the authors list widget form removing not used field, #339;
* Fixed: Fix error: "Twig file not found" for shortcodes in the Pro version using a custom layout. And avoid to show the authors twice if Free and Pro are activated, #336;
* Fixed: Fix compatibility with WP Engine object cache, #327;
* Fixed: Fixed the invalid taxonomy error message, #326;
* Fixed: Improved performance on author pages reducing the number of database queries only looking for an author taxonomy if a user was not found;
* Fixed: Fix the Authors List widget title alignment wrapping it on a H2 tag;

= [3.11.0] - 25 Jan 2021 =

* Added: Added fields for setting the plural and single title to the author box and widget, #75;
* Added: Added Rest API support to list the post's authors, #311;
* Added: Added new action to set authors to a post: "publishpress_authors_set_post_authors";
* Added: Added filter and constant for specifying to not load styles in the frontend, so users can use their own styles, #313;
* Added: Added Italian language files. Thanks to Angelo Giammarresi;
* Added: Added more automated tests;
* Changed: Updated Brazilian Portuguese language files;
* Fixed: Improved general performance removing unnecessary permissions validation on every text in the page, #325;
* Fixed: Improved general performance ignoring the body class change method if not in the frontend;
* Fixed: Fixed support to PHP 5.6 downgrading the Twig's requirement "symfony/polyfill-ctype" to v1.19, the last one that supports PHP 5, #323;
* Fixed: Fixed support to PHP 5.6 downgrading "pimple/pimple" to v3.2.3, the last one that supports PHP 5, #323;
* Fixed: Removed meaningless warnings when the post doesn't have an author: "[PublishPress Authors] Warning - The link for the author_id="" was changed to the post page because the author is not specified in the given url", #308;
* Fixed: If the post doesn't have an author term, the function filter_author_link doesn't recognized the user from "post_author" as author of the post, #308;
* Fixed: If the post doesn't have an author term, the function "get_multiple_authors" returns a WP_User instance (based on "post_author") even if the user is mapped to an author term, #306;
* Fixed: In the function "is_multiple_author_for_post", recognize user as author of a post even if he doesn't have a term, #307;
* Fixed: One test is trying to create a term which already exists, logging the error message: "A term with the name provided already exists";
* Fixed: Fixed multiple footers displayed when both Free and Pro are activated, #312;
* Fixed: Fix PHP error when an older version of YoastSEO is installed and the warning "not compatible YoastSEO" is showed;

= [3.10.0] - 15 Dec 2020 =

* Fixed: Changed the way we sync post_author column: Current user will only be set as author if no terms where found for the post, or there are only guest authors. If post_author is empty, we set it for the current user, creating an author term for it, #286.
* Fixed: Duplicated queries for the same given email in the method MultipleAuthors\Classes\Author_Utils::get_author_term_id_by_email(). Added a cache for the query results and an option to ignore the cache, #293;
* Fixed: Performance issue. Optimized some methods and modules loading for reducing the server overload and reduce duplicated queries. Some modules now are only loaded if the required plugin is installed, #297;
* Fixed: Fix the path for the template-tags.php file when called by the author box, if not loaded yet;
* Fixed: Only register admin hooks if in the admin, #297;
* Fixed: Fixed JS warning about variable being implicitly defined;
* Fixed: Fixed compatibility issue with Select2 library loaded by WS Form Plugin, #292;
* Fixed: Improved performance when opening the post edit page and quick edit panel for sites with thousands of authors;
* Changed: Deprecated functions and classes now can be disabled if you define the constant "PUBLISHPRESS_AUTHORS_LOAD_DEPRECATED_LEGACY_CODE" as false. Default is true, #297;
* Changed: CoAuthors' backward compatibility functions now can be disabled if you define the constant "PUBLISHPRESS_AUTHORS_LOAD_COAUTHORS_FUNCTIONS" as false. Default is true, #297;
* Changed: Bylines' backward compatibility functions now can be disabled if you define the constant "PUBLISHPRESS_AUTHORS_LOAD_BYLINES_FUNCTIONS" as false. Default is true, #297;
* Added: Added new maintenance task for syncing the authors' slug with the respective user's sanitized login (user_nicename). There is a new constant "PUBLISHPRESS_AUTHORS_SYNC_AUTHOR_SLUG_CHUNK_SIZE" for customizing the size of the chunk of authors to update at a time (default to 50), #287;
* Added: Added new constant "PUBLISHPRESS_AUTHORS_SYNC_POST_AUTHOR_CHUNK_SIZE" for defining the size of the chunck of posts to convert authors in the maintenance task: Update author field on posts. Default to 10;
* Removed: Removed the support to the filter "coauthors_auto_apply_template_tags", #297;

= [3.9.0] - 24 Nov 2020 =

* Added: Added support to Bulk Edit for authors in the post list, #263 and #280;
* Fixed: Fixed maintenance tasks to consider all the selected post types and not "post" only, #276;
* Fixed: Fixed compatibility issue with the WP RSS Aggregator plugin, #278;
* Fixed: Restored the posts count in the Authors and Users list, #275;

= [3.8.1] - 05 Nov 2020 =

* Fixed: Fixed the consistency of avatar dimensions between the img tag attributes and the CSS, #258;
* Fixed: Fixed edit_posts permission check for the PublishPress calendar, #264;
* Fixed: Restored the post count column in the Authors list, #95;

= [3.8.0] - 08 Aug 2020 =

* Fixed: Fixed PHP warning about undefined "default_author_for_new_posts" attribute for the module options;
* Fixed: Fixed the empty setting field "Default author for new posts", #242;
* Fixed: Fixed empty post_author on posts saved without any author. The current user will be added as the author, #238;
* Fixed: Fixed post_author field on posts when saving posts to store the user ID of the first author, ignoring guest authors, #171;
* Fixed: Fixed support for authors and guest authors in the PublishPress' calendar and content overview filters, #249;
* Added: Added new maintenance task to sync post_author with author terms for all posts, #171;
* Added: Added basic support for multiple authors in the Ultimate Members plugin's posts, #251;

= [3.7.3] - 21 Sep 2020 =

* Fixed: Fixed unresponsive author select box for new posts, #244;

= [3.7.2] - 14 Sep 2020 =

* Fixed: Fixed the reordering issue on authors in the post edit page;

= [3.7.1] - 11 Sep 2020 =

* Fixed: Fixed the authors field in the quick edit panel. It was displaying all authors instead of only the post authors, #236;

= [3.7.0] - 10 Sep 2020 =

* Fixed: Fixed performance issue in the post list and edit page removing avatars from the authors fields, #227;
* Added: Added option to change the default author for new posts in the site, #50;

= [3.6.3] - 04 Sep 2020 =

* Fixed: Fix error "Uncaught Error: Call to a member function add_cap() on null", #223;

= [3.6.2] - 03 Sep 2020 =

* Fixed: Fix error "Call to a member function get_error_message() on boolean", a regression bug result of the recent updates, #221;

= [3.6.1] - 03 Sep 2020 =

* Fixed: Fix admin notice for Co-Authors Plus displaying even when the plugin is not installed;

= [3.6.0] - 02 Sep 2020 =

* Added: Added support to update authors for posts using the quick edit form, #180;
* Added: Added argument "$ignoreCache" to the get_multiple_authors;
* Added: Added new capability (ppma_edit_post_authors) to control who can edit post authors, #213;
* Added: Added an admin notice if Co-Authors Plus is installed asking to read the documentation for migrating data, #209;
* Fixed: Removed mentions to the old name: Multiple Authors;
* Fixed: Error message "The plugin does not have a valid header" in PHP 5.6, #215;
* Fixed: Optimize performance in the get_multiple_authors again, replacing a function call with a specific db query; #190;
* Fixed: Fixed Co-Authors Plus data migration after installing. We still require to manually run the maintenance task to migrate the data;
* Fixed: Fixed get_multiple_authors cache when no arguments are passed to the functions;
* Fixed: Fixed fatal error that happens when get_term returns an error;
* Fixed: Upgrade link and banner were displayed for all users with access to the admin, #208;

= [3.5.1] - 20 Aug 2020 =

* Fixed: Avoid warnings regarding constants already defined;
* Fixed: Fixed the cache for the get_multiple_authors function for archive pages, #190;
* Fixed: Fixed fatal error Object of class WP_Error could not be converted to string, #182;
* Fixed: Fixed the value for $author->display_name which was returning the value from the user object instead of the custom value set for the author, #183;
* Fixed: Fixed Plugin::filter_user_has_cap() is passing a param to Util::get_current_post_type() which doesn't support params, #187;
* Fixed: Fixed Plugin::filter_user_has_cap() to use the correct user, not the current one, #186;
* Fixed: Removed leftovers from the deprecated capability: ppma_edit_orphan_post, #193;

= [3.5.0] - 06 Aug 2020 =

* Added: Added a new widget to display all the authors, #76;
* Added: Added option to display the username in the authors search field, #162;
* Fixed: Fix compatibility with WooCommerce products, #169;
* Fixed: Performance issue in the frontend. Added cache for queries that can run multiple times in the frontend, #171;
* Fixed: Fix PHP notice on author page when user is not an author, #156;
* Fixed: Fixed notice when a post doesn't exist after deleting the post, #167;

= [3.4.0] - 23 Jul 2020 =

* Added: Add new filter "publishpress_authors_author_attribute" for customizing author attributes in the layouts;
* Fixed: Fix syntax on the file Author_Editor.php removing an invalid char;

= [3.3.2] - 13 Jul 2020 =

* Fixed: Fix the text domain loading, fixing the translations;
* Fixed: Fix "orphan" authors when the mapped user is deleted, converting them in guest authors, #142;
* Fixed: Fix infinity loop when user's and author's slug are different and you are trying to save an author profile, #143;
* Fixed: Fix hardcoded table prefix from a query, #146;
* Fixed: Fix error about missed Authors_Iterator class, #144;
* Changed: Updated the min PHP version to 5.6;
* Changed: Updated the WordPress tested up to version, to 5.4;

= [3.3.1] - 27 May 2020 =

* Added: Added the static function "get_by_email" to the Author class for getting an author by his e-mail address;
* Changed: Improved error messages;
* Fixed: Fatal error for WP < 5.4 due to the function "is_favicon" not being defined;
* Fixed: Fix the get_avatar_url output for authors with a custom avatar, #122;
* Fixed: HTML entities were not rendered in the frontend using the default author layouts, #123;
* Fixed: Secondary authors don't have the edit_others_posts capability for their own posts, #129;
* Fixed: Improved integration with PublishPress adding support for multiple authors in the calendar. #129, #131;
* Fixed: Updated the POT file;

= [3.3.0] - 05 May 2020 =

* Added: Some error messages are now added to the error log;
* Added: Added links to the slug column in the authors list to open the authors page in the frontend;
* Added: Added post data to the twig layout context - #112;
* Added: Added multiple authors support to the Elementor Pro, adding new skins to the Posts and Archive Posts widgets;
* Added: Added support to Divi's theme builder and dynamic data related to authors;
* Changed: Reorganized the folder structure of the plugin moving the code to a "src" folder;
* Changed: Guest authors are now identified by author->ID < 0, which corresponds to the term_id. If ID > 0, it is a user, otherwise, an author term. This increases the compatibility rate with standard author functions;
* Fixed: Improved text and fixed typo in the data migration messages;
* Fixed: Added pointer cursor when hovering the "x" for removing authors from the list;
* Fixed: Fixed minor style issue in the Simple List layout CSS;
* Fixed: Centered avatar and fixed minor style issues in the Centered layout;
* Fixed: Removed the blank '-' char from the Simple List layout due to undefined "age" field;
* Fixed: Error message when the installed Yoast SEO doesn't have the function add_piece_language;
* Fixed: Detection of minimum required Yoast SEO version for the module to be activated, so the error message is not displayed if Yoast SEO is not installed;
* Fixed: Yoast SEO structured data was not displaying pages data correctly;
* Fixed: Yoast SEO structured data was not working well when a guest author was the first author in posts;
* Fixed: Yoast SEO structured data with incorrect @id for pages;
* Fixed: Fixed the method that implements the column for authors in the post list, to only run for enabled post types;
* Fixed: Fixed PHP Deprecated error for non-static method being called statically in the Term_Editor class;
* Fixed: Fixed the notice in the frontend saying the is_author was called incorrectly;
* Fixed: Empty output for shortcodes if the layout doesn't exists. Added fallback layout and an error message in the error log;
* Fixed: Wrong author data in the query for authors mapped to user;
* Fixed: The get_author_posts_url function was not working for guest authors;
* Fixed: The get_the_author_meta function was not working for guest authors;
* Fixed: The get_the_author_posts_link function was not working for guest authors;
* Fixed: The get_the_author function was not working for guest authors;
* Fixed: The the_post function was not working well for posts with guest authors;
* Fixed: The feed_links_extra function was not working for guest authors;
* Fixed: For themes that don't implement support for PublishPress Authors and multiple authors, we were displaying all the author names separated by comma, but only one link (due to the limitations imposed by the theme). Now we display only the first author and its respective link on those cases. The multiple authors can be added creating a child theme and adapting the code;
* Fixed: The title for authors archive pages of guest authors;
* Fixed: The author object is now compatible with the main properties of WP_User objects, so guest authors can be treated as users on most cases;
* Fixed: The custom user_url is not returned for authors mapped to user;

= [3.2.4] - 13 Apr 2020 =

* Added: Button to migrate data from the Bylines (Daniel Bachhuber) plugin;
* Added: Button to migrate data from the Byline (Matt Dulin) plugin;
* Added: Added a body class for guest authors "author-<author_slug>" (#45);
* Fixed: Fixed the error displayed on Windows servers when the constant DIRECTORY_SEPARATOR is not defined;
* Fixed: Fixed compatibility with composer based sites;
* Fixed: Broken body class for guest authors "author-" (#43);
* Fixed: Wrong authors in the header of pages based on Genesis framework (#46);
* Fixed: Empty author headline for guest authors (#47);
* Fixed: Fixed some texts and style in the Co-authors plugin migration box;
* Fixed: Wrong author data in the Yoast SEO schema for structured data (#77);
* Fixed: Fixed author page title when using Yoast SEO (#80);
* Fixed: Fix the result of the function get_the_author_posts_link for supporting multiple authors;
* Changed: Renamed the name of the Widget, from Multiple Authors to Authors;

= [3.2.3] - 16 Mar 2020 =

* Fixed: Wrong URL for the file multiple-authors-widget.css;
* Fixed: Fixed the author page for compatibility to the Genesis framework;
* Added: Added new filter to bypass the installation and data migration on special cases;
* Added: Add top banner for the Pro version;

= [3.2.2] - 25 Feb 2020 =

* Fixed: Undefined class Authors_Iterator, #26;
* Fixed: Error message related to Phing class file not found. Removed Phing from the package;

= [3.2.1] - 13 Feb 2020 =

* Fixed: Fixed the query for migrating posts' authors when installed for the first time;
* Fixed: Fixed the assets URL for the plugin when it is installed in a folder different from wp-content/plugins
* Fixed: Fixed the count of authors' posts using the correct field in the query: term_id. Issue #17;
* Fixed: Fixed the query in the installer that look for posts without author's taxonomy to migrate;
* Added: Added actions for before and after the settings fields: publishpress_authors_register_settings_before, publishpress_authors_register_settings_after;
* Added: Added new filter: pp_authors_twig for extending the Twig environment object;
* Changed: Cleanup the installer class;
* Changed: Removed the CMB2 library since it is only used in the Pro plugins;
* Changed: Refactored the code to support the Pro version;
* Removed: Removed the CMB2 library dependency;

= [3.2.0] - 03 Jan 2020 =

* First free public release. Based on PublishPress Multiple Authors v3.1.0.
