<?php
/**
 * Plugin Name: Product Video Showcase for WooCommerce
 * Description: Enables dynamic video previews on product hover in WooCommerce shop pages.
 * Version: 1.0.0
 * Author: WooDevNet
 * Author URI: https://woodev.net
 * Text Domain: product-video-showcase-for-woocommerce
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * WC requires at least: 3.0
 * WC tested up to: 5.9
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package WooCommerce_Product_Video_Showcase
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Define plugin constants
define('WPVS_VERSION', '1.0.0');
define('WPVS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WPVS_PLUGIN_URL', plugin_dir_url(__FILE__));

// Declare compatibility with high-performance order storage
add_action('before_woocommerce_init', function() {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

// Check if WooCommerce is active
if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    
    // Include the main plugin class
    require_once WPVS_PLUGIN_DIR . 'includes/class-woo-product-video-showcase.php';

    // Initialize the plugin
    function wpvs_init() {
        $plugin = new Woo_Product_Video_Showcase();
        $plugin->init();
    }
    add_action('plugins_loaded', 'wpvs_init');

    // Add settings link on plugin page
    add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'wpvs_settings_link');
    function wpvs_settings_link($links) {
        $settings_link = '<a href="' . admin_url('edit.php?post_type=product') . '">' . __('Add Videos to Products', 'product-video-showcase-for-woocommerce') . '</a>';
        array_unshift($links, $settings_link);
        return $links;
    }

} else {
    // WooCommerce is not active, show admin notice
    function wpvs_admin_notice_woocommerce_not_active() {
        ?>
        <div class="notice notice-error">
            <p><?php esc_html_e('Product Video Showcase for WooCommerce requires WooCommerce to be installed and active.', 'product-video-showcase-for-woocommerce'); ?></p>
        </div>
        <?php
    }
    add_action('admin_notices', 'wpvs_admin_notice_woocommerce_not_active');
}

// Add a notice to help users find where to add videos
function wpvs_admin_notice_help() {
    $screen = get_current_screen();
    if ($screen->id === 'edit-product') {
        ?>
        <div class="notice notice-info is-dismissible">
            <p><?php esc_html_e('To add a video preview to a product, edit the product and look for the "Product Video URL" field in the "General" tab.', 'product-video-showcase-for-woocommerce'); ?></p>
        </div>
        <?php
    }
}
add_action('admin_notices', 'wpvs_admin_notice_help');