jQuery(document).ready(function($) {
    console.log('Script loaded and running');

    $(document).on('mouseenter', '.product-inner, .wc-block-grid__product-link', function() {
        console.log('Hover detected on:', this);
        var $container = $(this).find('.wpvp-video-container');
        console.log('Video container found:', $container.length);
        
        if ($container.length === 0) {
            console.log('No video container found');
            return;
        }
        
        var videoUrl = $container.data('video-url');
        var videoType = $container.data('video-type');
        var videoFit = $container.data('video-fit') || 'cover';
        
        console.log('Video data:', {
            url: videoUrl,
            type: videoType,
            fit: videoFit
        });
        
        if (videoUrl && $container.children().length === 0) {
            switch(videoType) {
                case 'youtube':
                    var videoId = getYouTubeId(videoUrl);
                    if (videoId) {
                        var embedUrl = 'https://www.youtube.com/embed/' + videoId + '?autoplay=1&mute=1&controls=0&loop=1&playlist=' + videoId + '&showinfo=0&rel=0&modestbranding=1&iv_load_policy=3';
                        $container.html('<div class="video-wrapper"><iframe src="' + embedUrl + '" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe></div>');
                    } else {
                        console.error('Invalid YouTube URL');
                    }
                    break;
                case 'vimeo':
                    var videoId = getVimeoId(videoUrl);
                    if (videoId) {
                        var embedUrl = 'https://player.vimeo.com/video/' + videoId + '?autoplay=1&loop=1&background=1&title=0&byline=0&portrait=0';
                        $container.html('<div class="video-wrapper"><iframe src="' + embedUrl + '" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe></div>');
                    } else {
                        console.error('Invalid Vimeo URL');
                    }
                    break;
                default:
                    $container.html('<video src="' + videoUrl + '" autoplay loop muted playsinline></video>');
            }
            $container.addClass('active');
            applyVideoFit($container, videoFit);
            console.log('Video added to container with fit:', videoFit);
        }
    }).on('mouseleave', '.product-inner, .wc-block-grid__product-link', function() {
        var $container = $(this).find('.wpvp-video-container');
        $container.removeClass('active').empty();
        console.log('Video removed');
    });

    function applyVideoFit($container, videoFit) {
        var $video = $container.find('video');
        var $wrapper = $container.find('.video-wrapper');
        var $iframe = $container.find('iframe');
        
        $container.css({
            'width': '100%',
            'height': '100%',
            'overflow': 'hidden'
        });

        if ($video.length) {
            $video.css({
                'width': '100%',
                'height': '100%',
                'object-fit': videoFit
            });
        } else if ($wrapper.length && $iframe.length) {
            $wrapper.css({
                'width': '100%',
                'height': '100%',
                'position': 'relative'
            });

            switch(videoFit) {
                case 'contain':
                    $iframe.css({
                        'position': 'absolute',
                        'top': '50%',
                        'left': '50%',
                        'transform': 'translate(-50%, -50%)',
                        'max-width': '100%',
                        'max-height': '100%',
                        'width': 'auto',
                        'height': 'auto'
                    });
                    break;
                case 'cover':
                    $iframe.css({
                        'position': 'absolute',
                        'top': '50%',
                        'left': '50%',
                        'transform': 'translate(-50%, -50%)',
                        'width': '100%',
                        'height': '100%',
                        'object-fit': 'cover'
                    });
                    break;
                case 'fill':
                    $iframe.css({
                        'position': 'absolute',
                        'top': '0',
                        'left': '0',
                        'width': '100%',
                        'height': '100%'
                    });
                    break;
                case 'scale-down':
                    $iframe.css({
                        'position': 'absolute',
                        'top': '50%',
                        'left': '50%',
                        'transform': 'translate(-50%, -50%)',
                        'max-width': '100%',
                        'max-height': '100%',
                        'width': 'auto',
                        'height': 'auto'
                    });
                    break;
            }
        }
    }

    function getYouTubeId(url) {
        var regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
        var match = url.match(regExp);
        return (match && match[2].length === 11) ? match[2] : null;
    }

    function getVimeoId(url) {
        var regExp = /(?:www\.|player\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/(?:[^\/]*)\/videos\/|album\/(?:\d+)\/video\/|video\/|)(\d+)(?:[a-zA-Z0-9_\-]+)?/;
        var match = url.match(regExp);
        return match ? match[1] : null;
    }
});