<?php
/**
 * Uninstall Product Vendor Manager for WooCommerce
 *
 * Removes all vendor metadata and taxonomy terms when the plugin is uninstalled.
 *
 * @package Product_Vendor_Manager
 * @since 1.1 
 */

// Prevent direct access						
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Check if the current plugin is being uninstalled
if (__FILE__ !== WP_UNINSTALL_PLUGIN) {
    exit;
}

// Delete all vendor terms and their meta
delete_tulosspvmw_vendor_data();
		 

function delete_tulosspvmw_vendor_data() {
    $vendor_meta_keys = array('vendor_contact', 'vendor_phone', 'vendor_email', 'vendor_address');

    $vendor_terms = get_terms(array(
        'taxonomy'   => 'tulosspvmw_vendor',
        'hide_empty' => false,
        'fields'     => 'ids',
    ));

    if (!is_wp_error($vendor_terms) && !empty($vendor_terms)) {
        foreach ($vendor_terms as $term_id) {
            foreach ($vendor_meta_keys as $meta_key) {
                delete_term_meta($term_id, $meta_key);
            }
            wp_delete_term($term_id, 'tulosspvmw_vendor');
        }
    }

    // Optionally remove plugin options here if added later
    // delete_option('tulosspvmw_some_option');
						
}
?>

											   
										 
																	 
			
   

					   
									
										   
	 
 

																									

																
									

	   