<?php

/**
 * Plugin Name: Product Photo AI for WooCommerce
 * Description: AI-powered product image generation for WooCommerce stores.
 * Author: Codeneric
 * Author URI: https://product-photo-ai.com
 * License: GPLv2
 * Version: 1.0.3
 * Requires at least: 5.9
 * Requires PHP: 7.2
 * Text Domain: product-photo-ai-for-woocommerce
 * WC tested up to: 10.0.4
 * Requires Plugins: woocommerce
 *
 * @package Product Photo AI for WooCommerce
 */

use CodenericProductPhotoAI\Core\Install;

defined('ABSPATH') || exit;

// Define plugin constants
define('CPPAI_VERSION', '1.0.1');
define('CPPAI_PLUGIN_FILE', __FILE__);
define('CPPAI_DIR', plugin_dir_path(__FILE__));
define('CPPAI_URL', plugin_dir_url(__FILE__));
define('CPPAI_ASSETS_URL', CPPAI_URL . '/assets');
define('CPPAI_ROUTE_PREFIX', 'cppai/v1');

require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';
require_once plugin_dir_path(__FILE__) . 'plugin.php';

/**
 * Declare WooCommerce HPOS compatibility before WooCommerce initializes
 *
 * @since 1.0.0
 * @return void
 */
add_action('before_woocommerce_init', function() {
	if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
	}
});

/**
 * Initializes the CodenericProductPhotoAI plugin when plugins are loaded.
 *
 * @since 1.0.0
 * @return void
 */
function codeneric_productphoto_ai_init()
{
	CodenericProductPhotoAI::get_instance()->init();
}

// Hook for plugin initialization.
add_action('plugins_loaded', 'codeneric_productphoto_ai_init');

// Hook for plugin activation.
register_activation_hook(__FILE__, array(Install::get_instance(), 'init'));
